/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.variation;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.VariantContextConverter;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat$;
import org.bdgenomics.adam.rdd.variation.GenotypeRDDFunctions;
import org.bdgenomics.adam.rdd.variation.VariantContextRDDFunctions;
import org.bdgenomics.adam.rdd.variation.VariationContext$;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.formats.avro.DatabaseVariantAnnotation;
import org.bdgenomics.formats.avro.Genotype;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.seqdoop.hadoop_bam.VCFInputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.slf4j.Logger;
import parquet.hadoop.util.ContextUtil;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ur!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0005,be&\fG/[8o\u0007>tG/\u001a=u\u0015\t\u0019A!A\u0005wCJL\u0017\r^5p]*\u0011QAB\u0001\u0004e\u0012$'BA\u0004\t\u0003\u0011\tG-Y7\u000b\u0005%Q\u0011A\u00032eO\u0016tw.\\5dg*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011C\u0001\tWCJL\u0017\r^5p]\u000e{g\u000e^3yiN\u0019qB\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\t\u0019\u0012$\u0003\u0002\u001b)\ta1+\u001a:jC2L'0\u00192mK\")Ad\u0004C\u0001;\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\u0006?=!\u0019\u0001I\u0001\u001fgB\f'o[\"p]R,\u0007\u0010\u001e+p-\u0006\u0014\u0018.\u0019;j_:\u001cuN\u001c;fqR$2!IA\u0001!\tq!E\u0002\u0003\u0011\u0005\u0001\u00193\u0003\u0002\u0012\u00131\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0011AB1qC\u000eDW-\u0003\u0002,M\t9Aj\\4hS:<\u0007\u0002C\u0017#\u0005\u000b\u0007I\u0011\u0001\u0018\u0002\u0005M\u001cW#A\u0018\u0011\u0005\u0015\u0002\u0014BA\u0019'\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011!\u0019$E!A!\u0002\u0013y\u0013aA:dA!\u0012!'\u000e\t\u0003'YJ!a\u000e\u000b\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"\u0002\u000f#\t\u0003IDCA\u0011;\u0011\u0015i\u0003\b1\u00010\u0011\u0015a$\u0005\"\u0001>\u0003-\tG-Y7W\u0007\u001acu.\u00193\u0015\u0007yJ%\u000bE\u0002@\u0003\u000ek\u0011\u0001\u0011\u0006\u0003\u000b\u0019J!A\u0011!\u0003\u0007I#E\t\u0005\u0002E\u000f6\tQI\u0003\u0002G\r\u00051Qn\u001c3fYNL!\u0001S#\u0003\u001dY\u000b'/[1oi\u000e{g\u000e^3yi\")!j\u000fa\u0001\u0017\u0006Aa-\u001b7f!\u0006$\b\u000e\u0005\u0002M\u001f:\u00111#T\u0005\u0003\u001dR\ta\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011a\n\u0006\u0005\b'n\u0002\n\u00111\u0001U\u0003\u0011!\u0017n\u0019;\u0011\u0007M)v+\u0003\u0002W)\t1q\n\u001d;j_:\u0004\"\u0001\u0012-\n\u0005e+%AE*fcV,gnY3ES\u000e$\u0018n\u001c8befDQa\u0017\u0012\u0005\u0002q\u000bQ#\u00193b[Z\u001be)\u00118o_R\fG/[8o\u0019>\fG\rF\u0002^M\u001e\u00042aP!_!\tyF-D\u0001a\u0015\t\t'-\u0001\u0003bmJ|'BA2\t\u0003\u001d1wN]7biNL!!\u001a1\u00033\u0011\u000bG/\u00192bg\u00164\u0016M]5b]R\feN\\8uCRLwN\u001c\u0005\u0006\u0015j\u0003\ra\u0013\u0005\b'j\u0003\n\u00111\u0001U\u0011\u0015I'\u0005\"\u0001k\u0003-\tG-Y7W\u0007\u001a\u001b\u0016M^3\u0015\tyZGN\u001c\u0005\u0006\u0015\"\u0004\ra\u0013\u0005\u0006[\"\u0004\rAP\u0001\tm\u0006\u0014\u0018.\u00198ug\"91\u000b\u001bI\u0001\u0002\u0004!\u0006b\u00029##\u0003%\t!]\u0001\u0016C\u0012\fWNV\"G\u0019>\fG\r\n3fM\u0006,H\u000e\u001e\u00133+\u0005\u0011(F\u0001+tW\u0005!\bCA;{\u001b\u00051(BA<y\u0003%)hn\u00195fG.,GM\u0003\u0002z)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005m4(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9QPII\u0001\n\u0003\t\u0018aH1eC646IR!o]>$\u0018\r^5p]2{\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%e!9qPII\u0001\n\u0003\t\u0018!F1eC646IR*bm\u0016$C-\u001a4bk2$He\r\u0005\u0006[y\u0001\ra\f\u0005\b\u0003\u000byA1AA\u0004\u0003Y\u0011H\r\u001a+p-\u0006\u0014\u0018.\u00198u\u0007>tG/\u001a=u%\u0012#E\u0003BA\u0005\u0003\u001f\u00012ADA\u0006\u0013\r\tiA\u0001\u0002\u001b-\u0006\u0014\u0018.\u00198u\u0007>tG/\u001a=u%\u0012#e)\u001e8di&|gn\u001d\u0005\u0007\u000b\u0005\r\u0001\u0019\u0001 \t\u000f\u0005Mq\u0002b\u0001\u0002\u0016\u0005!\"\u000f\u001a3U_\u0006#\u0015)T$f]>$\u0018\u0010]3S\t\u0012#B!a\u0006\u0002\u001eA\u0019a\"!\u0007\n\u0007\u0005m!A\u0001\u000bHK:|G/\u001f9f%\u0012#e)\u001e8di&|gn\u001d\u0005\b\u000b\u0005E\u0001\u0019AA\u0010!\u0011y\u0014)!\t\u0011\u0007}\u000b\u0019#C\u0002\u0002&\u0001\u0014\u0001bR3o_RL\b/\u001a\u0005\n\u0003Sy\u0011\u0011!C\u0005\u0003W\t1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0006\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0012\u0001\u00026bm\u0006LA!a\u000f\u00022\t1qJ\u00196fGR\u0004")
public class VariationContext
implements Serializable,
Logging {
    private final transient SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static GenotypeRDDFunctions rddToADAMGenotypeRDD(RDD<Genotype> rDD) {
        return VariationContext$.MODULE$.rddToADAMGenotypeRDD(rDD);
    }

    public static VariantContextRDDFunctions rddToVariantContextRDD(RDD<VariantContext> rDD) {
        return VariationContext$.MODULE$.rddToVariantContextRDD(rDD);
    }

    public static VariationContext sparkContextToVariationContext(SparkContext sparkContext) {
        return VariationContext$.MODULE$.sparkContextToVariationContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public RDD<VariantContext> adamVCFLoad(String filePath, Option<SequenceDictionary> dict) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading VCF file from %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        VariantContextConverter vcc = new VariantContextConverter(dict);
        RDD records = this.sc().newAPIHadoopFile(filePath, VCFInputFormat.class, LongWritable.class, VariantContextWritable.class, ContextUtil.getConfiguration((JobContext)job));
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Converted %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)records.count())})));
        return records.flatMap((Function1)new Serializable(this, vcc){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter vcc$1;

            public final Seq<VariantContext> apply(Tuple2<LongWritable, VariantContextWritable> p) {
                return this.vcc$1.convert(((VariantContextWritable)p._2()).get());
            }
            {
                this.vcc$1 = vcc$1;
            }
        }, ClassTag$.MODULE$.apply(VariantContext.class));
    }

    public Option<SequenceDictionary> adamVCFLoad$default$2() {
        return None$.MODULE$;
    }

    public RDD<DatabaseVariantAnnotation> adamVCFAnnotationLoad(String filePath, Option<SequenceDictionary> dict) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading VCF file from %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        VariantContextConverter vcc = new VariantContextConverter(dict);
        RDD records = this.sc().newAPIHadoopFile(filePath, VCFInputFormat.class, LongWritable.class, VariantContextWritable.class, ContextUtil.getConfiguration((JobContext)job));
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Converted %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)records.count())})));
        return records.map((Function1)new Serializable(this, vcc){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter vcc$2;

            public final DatabaseVariantAnnotation apply(Tuple2<LongWritable, VariantContextWritable> p) {
                return this.vcc$2.convertToAnnotation(((VariantContextWritable)p._2()).get());
            }
            {
                this.vcc$2 = vcc$2;
            }
        }, ClassTag$.MODULE$.apply(DatabaseVariantAnnotation.class));
    }

    public Option<SequenceDictionary> adamVCFAnnotationLoad$default$2() {
        return None$.MODULE$;
    }

    public RDD<VariantContext> adamVCFSave(String filePath, RDD<VariantContext> variants, Option<SequenceDictionary> dict) {
        VCFFormat vcfFormat;
        VCFFormat vCFFormat = vcfFormat = VCFFormat.inferFromFilePath((String)filePath);
        VCFFormat vCFFormat2 = VCFFormat.VCF;
        Predef$.MODULE$.assert(!(vCFFormat != null ? !vCFFormat.equals(vCFFormat2) : vCFFormat2 != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "BCF not yet supported";
            }
        });
        variants.cache();
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Writing %s file to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vcfFormat, filePath})));
        List<String> header2 = VariationContext$.MODULE$.rddToVariantContextRDD(variants).getCallsetSamples();
        Broadcast bcastHeader = this.sc().broadcast(header2, ClassTag$.MODULE$.apply(List.class));
        long mp = variants.mapPartitionsWithIndex((Function2)new Serializable(this, bcastHeader){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariationContext $outer;
            private final Broadcast bcastHeader$1;

            public final Iterator<Object> apply(int idx, Iterator<VariantContext> iter) {
                this.$outer.log().warn(new StringBuilder().append((Object)"Setting header for partition ").append((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
                VariationContext variationContext = this.$outer;
                synchronized (variationContext) {
                    ADAMVCFOutputFormat$.MODULE$.setHeader((Seq<String>)((Seq)this.bcastHeader$1.value()));
                    this.$outer.log().warn(new StringBuilder().append((Object)"Set VCF header for partition ").append((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
                    return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bcastHeader$1 = bcastHeader$1;
            }
        }, variants.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Int()).count();
        if (mp != 0L) {
            this.log().warn("Had more than 0 elements after map partitions call to set VCF header across cluster.");
        }
        VariantContextConverter converter = new VariantContextConverter(dict);
        RDD gatkVCs = variants.map((Function1)new Serializable(this, converter){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter converter$1;

            /*
             * WARNING - void declaration
             */
            public final VariantContextWritable apply(VariantContext v) {
                void var2_2;
                VariantContextWritable vcw = new VariantContextWritable();
                vcw.set(this.converter$1.convert(v));
                return var2_2;
            }
            {
                this.converter$1 = converter$1;
            }
        }, ClassTag$.MODULE$.apply(VariantContextWritable.class));
        RDD withKey = gatkVCs.keyBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LongWritable apply(VariantContextWritable v) {
                return new LongWritable((long)v.get().getStart());
            }
        });
        Configuration conf = this.sc().hadoopConfiguration();
        conf.set("hadoopbam.vcf.output-format", vcfFormat.toString());
        SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(VariantContextWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsNewAPIHadoopFile(filePath, LongWritable.class, VariantContextWritable.class, ADAMVCFOutputFormat.class, conf);
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Write %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)gatkVCs.count())})));
        return variants.unpersist(variants.unpersist$default$1());
    }

    public Option<SequenceDictionary> adamVCFSave$default$3() {
        return None$.MODULE$;
    }

    public VariationContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

