/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.ValidationStringency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.cli.CLIMRBAMPlugin;
import org.seqdoop.hadoop_bam.cli.CLIMergingAnySAMOutputFormat;
import org.seqdoop.hadoop_bam.cli.Utils;
import org.seqdoop.hadoop_bam.cli.plugins.SortInputFormat;
import org.seqdoop.hadoop_bam.cli.plugins.SortReducer;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;
import org.seqdoop.hadoop_bam.util.Timer;

public final class Sort
extends CLIMRBAMPlugin {
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();
    private static final CmdLineParser.Option stringencyOpt = new CmdLineParser.Option.StringOption("validation-stringency=S");

    public Sort() {
        super("sort", "BAM and SAM sorting and merging", "4.2", "WORKDIR INPATH [INPATH...]", optionDescs, "Merges together the BAM and SAM files in the INPATHs, sorting the result in standard coordinate order, all in a distributed fashion using Hadoop MapReduce. Output parts are placed in WORKDIR in, by default, headerless and unterminated BAM format.");
    }

    @Override
    protected int run(CmdLineParser parser) {
        List<String> args = parser.getRemainingArgs();
        if (args.isEmpty()) {
            System.err.println("sort :: WORKDIR not given.");
            return 3;
        }
        if (args.size() == 1) {
            System.err.println("sort :: INPATH not given.");
            return 3;
        }
        if (!this.cacheAndSetProperties(parser)) {
            return 3;
        }
        ValidationStringency stringency = Utils.toStringency(parser.getOptionValue(stringencyOpt, ValidationStringency.DEFAULT_STRINGENCY.toString()), "sort");
        if (stringency == null) {
            return 3;
        }
        Path wrkDir = new Path(args.get(0));
        List<String> strInputs = args.subList(1, args.size());
        ArrayList<Path> inputs = new ArrayList<Path>(strInputs.size());
        for (String in : strInputs) {
            inputs.add(new Path(in));
        }
        Configuration conf = this.getConf();
        Utils.setHeaderMergerSortOrder(conf, SAMFileHeader.SortOrder.coordinate);
        conf.setStrings("hadoopbam.headermerger.inputs", strInputs.toArray(new String[0]));
        if (stringency != null) {
            conf.set("hadoopbam.samheaderreader.validation-stringency", stringency.toString());
        }
        String intermediateOutName = (this.outPath == null ? (Path)inputs.get(0) : this.outPath).getName();
        conf.set("hadoopbam.work.filename", intermediateOutName);
        Timer t = new Timer();
        try {
            wrkDir = wrkDir.getFileSystem(conf).makeQualified(wrkDir);
            Utils.configureSampling(wrkDir, intermediateOutName, conf);
            Job job = new Job(conf);
            job.setJarByClass(Sort.class);
            job.setMapperClass(Mapper.class);
            job.setReducerClass(SortReducer.class);
            job.setMapOutputKeyClass(LongWritable.class);
            job.setOutputKeyClass(NullWritable.class);
            job.setOutputValueClass(SAMRecordWritable.class);
            job.setInputFormatClass(SortInputFormat.class);
            job.setOutputFormatClass(CLIMergingAnySAMOutputFormat.class);
            for (Path in : inputs) {
                FileInputFormat.addInputPath((Job)job, (Path)in);
            }
            FileOutputFormat.setOutputPath((Job)job, (Path)wrkDir);
            job.setPartitionerClass(TotalOrderPartitioner.class);
            System.out.println("sort :: Sampling...");
            t.start();
            InputSampler.writePartitionFile((Job)job, (InputSampler.Sampler)new InputSampler.RandomSampler(0.01, 10000, Math.max(100, this.reduceTasks)));
            System.out.printf("sort :: Sampling complete in %d.%03d s.\n", t.stopS(), t.fms());
            job.submit();
            System.out.println("sort :: Waiting for job completion...");
            t.start();
            if (!job.waitForCompletion(this.verbose)) {
                System.err.println("sort :: Job failed.");
                return 4;
            }
            System.out.printf("sort :: Job complete in %d.%03d s.\n", t.stopS(), t.fms());
        }
        catch (IOException e) {
            System.err.printf("sort :: Hadoop error: %s\n", e);
            return 4;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.outPath != null) {
            try {
                Utils.mergeSAMInto(this.outPath, wrkDir, "", "", this.samFormat, conf, "sort");
            }
            catch (IOException e) {
                System.err.printf("sort :: Output merging failed: %s\n", e);
                return 5;
            }
        }
        return 0;
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(stringencyOpt, Utils.getStringencyOptHelp()));
    }
}

