/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins.chipster;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.seqdoop.hadoop_bam.BAMRecordReader;
import org.seqdoop.hadoop_bam.cli.plugins.chipster.BlockCompressedLineRecordReader;

final class SortRecordReader
extends RecordReader<LongWritable, Text> {
    private final LongWritable key = new LongWritable();
    private final BlockCompressedLineRecordReader lineRR = new BlockCompressedLineRecordReader();

    SortRecordReader() {
    }

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws IOException {
        this.lineRR.initialize(spl, ctx);
    }

    public void close() throws IOException {
        this.lineRR.close();
    }

    public float getProgress() {
        return this.lineRR.getProgress();
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public Text getCurrentValue() {
        return this.lineRR.getCurrentValue();
    }

    public boolean nextKeyValue() throws IOException, CharacterCodingException {
        if (!this.lineRR.nextKeyValue()) {
            return false;
        }
        Text line = this.getCurrentValue();
        int tabOne = line.find("\t");
        int rid = Integer.parseInt(Text.decode((byte[])line.getBytes(), (int)0, (int)tabOne));
        int tabTwo = line.find("\t", tabOne + 1);
        int posBeg = tabOne + 1;
        int posEnd = tabTwo - 1;
        int pos = Integer.parseInt(Text.decode((byte[])line.getBytes(), (int)posBeg, (int)(posEnd - posBeg + 1)));
        this.key.set(BAMRecordReader.getKey0(rid, pos));
        return true;
    }
}

