/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.ValidationStringency;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;

public final class SAMHeaderReader {
    public static final String VALIDATION_STRINGENCY_PROPERTY = "hadoopbam.samheaderreader.validation-stringency";

    public static SAMFileHeader readSAMHeaderFrom(Path path, Configuration conf) throws IOException {
        FSDataInputStream i = path.getFileSystem(conf).open(path);
        SAMFileHeader h = SAMHeaderReader.readSAMHeaderFrom((InputStream)i, conf);
        i.close();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAMFileHeader readSAMHeaderFrom(InputStream in, Configuration conf) {
        SAMFileHeader header;
        ValidationStringency stringency = SAMHeaderReader.getValidationStringency(conf);
        ValidationStringency origStringency = null;
        try {
            if (stringency != null) {
                origStringency = ValidationStringency.DEFAULT_STRINGENCY;
                SAMFileReader.setDefaultValidationStringency((ValidationStringency)stringency);
            }
            header = new SAMFileReader(in, false).getFileHeader();
        }
        finally {
            if (origStringency != null) {
                SAMFileReader.setDefaultValidationStringency((ValidationStringency)origStringency);
            }
        }
        return header;
    }

    public static ValidationStringency getValidationStringency(Configuration conf) {
        String p = conf.get(VALIDATION_STRINGENCY_PROPERTY);
        return p == null ? null : ValidationStringency.valueOf((String)p);
    }
}

