/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ClassContractHandle;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.agent.ContractMethodSignatures;
import com.google.java.contract.core.agent.MethodContractHandle;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.util.Iterables;
import com.google.java.contract.util.Predicates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

@Invariant(value={"className == null || ClassName.isBinaryName(className)", "classHandles != null", "!classHandles.contains(null)", "methodHandles != null", "!methodHandles.keySet().contains(null)", "Iterables.all(methodHandles.values(), Predicates.<MethodContractHandle>all(Predicates.nonNull()))"})
class ContractAnalyzer
extends ClassVisitor {
    protected List<ClassContractHandle> classHandles;
    protected Map<String, ArrayList<MethodContractHandle>> methodHandles;
    protected String className;
    protected MethodNode lastMethodNode;

    ContractAnalyzer() {
        super(262144);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.classHandles = new ArrayList<ClassContractHandle>();
            this.methodHandles = new HashMap<String, ArrayList<MethodContractHandle>>();
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ContractAnalyzer.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractAnalyzer.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$agent$ContractAnalyzer();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null"})
    @Ensures(value={"result != null", "!result.contains(null)"})
    List<ClassContractHandle> getClassHandles(ContractKind contractKind) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void kind;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getClassHandles(contractKind);
                contractContext.leaveContract();
            }
            ArrayList<ClassContractHandle> matched = new ArrayList<ClassContractHandle>();
            for (ClassContractHandle h : this.classHandles) {
                if (!kind.equals((Object)h.getKind())) continue;
                matched.add(h);
            }
            ArrayList<ClassContractHandle> arrayList = matched;
            if (contractContext.tryEnterContract()) {
                ArrayList<ClassContractHandle> arrayList2;
                arrayList = arrayList2 = arrayList;
                this.com$google$java$contract$Q$getClassHandles((ContractKind)kind, arrayList2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getClassHandles")
    private /* synthetic */ void com$google$java$contract$P$getClassHandles(ContractKind kind) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$getClassHandles(kind, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getClassHandles")
    private /* synthetic */ void com$google$java$contract$Q$getClassHandles(ContractKind kind, List<ClassContractHandle> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractAnalyzer$getClassHandles(kind, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "name != null", "desc != null", "extraCount >= 0"})
    @Ensures(value={"result != null", "!result.contains(null)"})
    List<MethodContractHandle> getMethodHandles(ContractKind contractKind, String string, String string2, int n) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void extraCount;
            void desc;
            void kind;
            void name;
            ArrayList<MethodContractHandle> candidates;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getMethodHandles(contractKind, string, string2, n);
                contractContext.leaveContract();
            }
            if ((candidates = this.methodHandles.get(name)) == null) {
                List<MethodContractHandle> list = Collections.emptyList();
                if (contractContext.tryEnterContract()) {
                    List<MethodContractHandle> list2;
                    list = list2 = list;
                    this.com$google$java$contract$Q$getMethodHandles((ContractKind)kind, (String)name, (String)desc, (int)extraCount, list2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return list;
            }
            ArrayList<MethodContractHandle> matched = new ArrayList<MethodContractHandle>();
            for (MethodContractHandle h : candidates) {
                if (!kind.equals((Object)h.getKind()) || !this.descArgumentsMatch((String)desc, h.getContractMethod().desc, (int)extraCount)) continue;
                matched.add(h);
            }
            ArrayList<MethodContractHandle> arrayList = matched;
            if (contractContext.tryEnterContract()) {
                ArrayList<MethodContractHandle> arrayList2;
                arrayList = arrayList2 = arrayList;
                this.com$google$java$contract$Q$getMethodHandles((ContractKind)kind, (String)name, (String)desc, (int)extraCount, arrayList2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getMethodHandles")
    private /* synthetic */ void com$google$java$contract$P$getMethodHandles(ContractKind kind, String name, String desc, int extraCount) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$getMethodHandles(kind, name, desc, extraCount, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getMethodHandles")
    private /* synthetic */ void com$google$java$contract$Q$getMethodHandles(ContractKind kind, String name, String desc, int extraCount, List<MethodContractHandle> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractAnalyzer$getMethodHandles(kind, name, desc, extraCount, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null"})
    ClassContractHandle getClassHandle(ContractKind contractKind) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getClassHandle(contractKind);
                contractContext.leaveContract();
            }
            ArrayList matched = new ArrayList();
            for (ClassContractHandle h : this.classHandles) {
                void kind;
                if (!kind.equals((Object)h.getKind())) continue;
                ClassContractHandle classContractHandle = h;
                if (contractContext.tryEnterContract()) {
                    ClassContractHandle classContractHandle2;
                    classContractHandle = classContractHandle2 = classContractHandle;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return classContractHandle;
            }
            ClassContractHandle classContractHandle = null;
            if (contractContext.tryEnterContract()) {
                ClassContractHandle classContractHandle3;
                classContractHandle = classContractHandle3 = classContractHandle;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return classContractHandle;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getClassHandle")
    private /* synthetic */ void com$google$java$contract$P$getClassHandle(ContractKind kind) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$getClassHandle(kind, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "name != null", "desc != null", "extraCount >= 0"})
    MethodContractHandle getMethodHandle(ContractKind contractKind, String string, String string2, int n) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void name;
            ArrayList<MethodContractHandle> candidates;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getMethodHandle(contractKind, string, string2, n);
                contractContext.leaveContract();
            }
            if ((candidates = this.methodHandles.get(name)) == null) {
                MethodContractHandle methodContractHandle = null;
                if (contractContext.tryEnterContract()) {
                    MethodContractHandle methodContractHandle2;
                    methodContractHandle = methodContractHandle2 = methodContractHandle;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return methodContractHandle;
            }
            for (MethodContractHandle h : candidates) {
                void extraCount;
                void desc;
                void kind;
                if (!kind.equals((Object)h.getKind()) || !this.descArgumentsMatch((String)desc, h.getContractMethod().desc, (int)extraCount)) continue;
                MethodContractHandle methodContractHandle = h;
                if (contractContext.tryEnterContract()) {
                    MethodContractHandle methodContractHandle3;
                    methodContractHandle = methodContractHandle3 = methodContractHandle;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return methodContractHandle;
            }
            MethodContractHandle methodContractHandle = null;
            if (contractContext.tryEnterContract()) {
                MethodContractHandle methodContractHandle4;
                methodContractHandle = methodContractHandle4 = methodContractHandle;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return methodContractHandle;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getMethodHandle")
    private /* synthetic */ void com$google$java$contract$P$getMethodHandle(ContractKind kind, String name, String desc, int extraCount) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$getMethodHandle(kind, name, desc, extraCount, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"desc1 != null", "desc2 != null", "offset >= 0"})
    private boolean descArgumentsMatch(String string, String string2, int n) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void offset;
            void desc2;
            void desc1;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$descArgumentsMatch(string, string2, n);
                contractContext.leaveContract();
            }
            Type[] types1 = Type.getArgumentTypes((String)desc1);
            Type[] types2 = Type.getArgumentTypes((String)desc2);
            if (types2.length - types1.length != offset) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            for (int i = 0; i < types1.length; ++i) {
                if (types1[i].equals(types2[i])) continue;
                boolean bl4 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl5;
                    bl4 = bl5 = bl4;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl4;
            }
            boolean bl6 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl7;
                bl6 = bl7 = bl6;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="descArgumentsMatch")
    private /* synthetic */ void com$google$java$contract$P$descArgumentsMatch(String desc1, String desc2, int offset) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$descArgumentsMatch(desc1, desc2, offset, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void name;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.className = name;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void exceptions;
            void signature;
            void desc;
            void name;
            void access;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.captureLastMethodNode();
            MethodNode methodNode = this.lastMethodNode = new MethodNode((int)access, (String)name, (String)desc, (String)signature, (String[])exceptions);
            if (contractContext.tryEnterContract()) {
                MethodNode methodNode2;
                methodNode = methodNode2 = methodNode;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return methodNode;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Override
    public void visitEnd() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.captureLastMethodNode();
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"lastMethodNode == null"})
    protected void captureLastMethodNode() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (this.lastMethodNode == null) {
                if (contractContext.tryEnterContract()) {
                    this.com$google$java$contract$Q$captureLastMethodNode();
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            ContractKind kind = ContractMethodSignatures.getKind(this.lastMethodNode);
            if (kind != null) {
                List<Long> lineNumbers = ContractMethodSignatures.getLineNumbers(this.lastMethodNode);
                if (kind.isClassContract() || kind.isHelperContract()) {
                    ClassContractHandle ch = new ClassContractHandle(kind, this.className, this.lastMethodNode, lineNumbers);
                    this.classHandles.add(ch);
                } else {
                    MethodContractHandle mh = new MethodContractHandle(kind, this.className, this.lastMethodNode, lineNumbers);
                    this.internMethod(mh.getMethodName()).add(mh);
                }
            }
            this.lastMethodNode = null;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$captureLastMethodNode();
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="captureLastMethodNode")
    private /* synthetic */ void com$google$java$contract$Q$captureLastMethodNode() {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractAnalyzer$captureLastMethodNode();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"name != null"})
    @Ensures(value={"result != null", "result == methodHandles.get(name)"})
    protected List<MethodContractHandle> internMethod(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void name;
            ArrayList<MethodContractHandle> handles;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$internMethod(string);
                contractContext.leaveContract();
            }
            if ((handles = this.methodHandles.get(name)) == null) {
                handles = new ArrayList();
                this.methodHandles.put((String)name, handles);
            }
            ArrayList<MethodContractHandle> arrayList = handles;
            if (contractContext.tryEnterContract()) {
                ArrayList<MethodContractHandle> arrayList2;
                arrayList = arrayList2 = arrayList;
                this.com$google$java$contract$Q$internMethod((String)name, arrayList2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="internMethod")
    private /* synthetic */ void com$google$java$contract$P$internMethod(String name) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$internMethod(name, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="internMethod")
    private /* synthetic */ void com$google$java$contract$Q$internMethod(String name, List<MethodContractHandle> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractAnalyzer$internMethod(name, result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={54L, 55L, 56L, 57L, 58L, 59L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$agent$ContractAnalyzer() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.className == null || ClassName.isBinaryName(this.className);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("className == null || ClassName.isBinaryName(className)", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.classHandles != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("classHandles != null", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = !this.classHandles.contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("!classHandles.contains(null)", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = this.methodHandles != null;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("methodHandles != null", com$google$java$contract$local$exception$7));
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = !this.methodHandles.keySet().contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            ContractRuntime.raise(new InvariantError("!methodHandles.keySet().contains(null)", com$google$java$contract$local$exception$9));
        }
        boolean com$google$java$contract$local$success$5 = false;
        Throwable com$google$java$contract$local$exception$11 = null;
        try {
            com$google$java$contract$local$success$5 = Iterables.all(this.methodHandles.values(), Predicates.all(Predicates.nonNull()));
        }
        catch (Throwable com$google$java$contract$local$exception$10) {
            com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
        }
        if (!com$google$java$contract$local$success$5) {
            ContractRuntime.raise(new InvariantError("Iterables.all(methodHandles.values(), Predicates.<MethodContractHandle>all(Predicates.nonNull()))", com$google$java$contract$local$exception$11));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getClassHandles", lines={85L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$getClassHandles(ContractKind kind, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getClassHandles", lines={87L, 88L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractAnalyzer$getClassHandles(ContractKind kind, List<ClassContractHandle> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !result.contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("!result.contains(null)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getMethodHandles", lines={112L, 113L, 114L, 115L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$getMethodHandles(ContractKind kind, String name, String desc, int extraCount, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = desc != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("desc != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = extraCount >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("extraCount >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getMethodHandles", lines={118L, 119L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractAnalyzer$getMethodHandles(ContractKind kind, String name, String desc, int extraCount, List<MethodContractHandle> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !result.contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("!result.contains(null)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getClassHandle", lines={146L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$getClassHandle(ContractKind kind, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getMethodHandle", lines={170L, 171L, 172L, 173L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$getMethodHandle(ContractKind kind, String name, String desc, int extraCount, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = desc != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("desc != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = extraCount >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("extraCount >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="descArgumentsMatch", lines={197L, 198L, 199L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$descArgumentsMatch(String desc1, String desc2, int offset, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = desc1 != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("desc1 != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = desc2 != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("desc2 != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = offset >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("offset >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="captureLastMethodNode", lines={244L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractAnalyzer$captureLastMethodNode() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.lastMethodNode == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("lastMethodNode == null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="internMethod", lines={275L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractAnalyzer$internMethod(String name, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="internMethod", lines={277L, 278L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractAnalyzer$internMethod(String name, List<MethodContractHandle> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = result == this.methodHandles.get(name);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("result == methodHandles.get(name)", com$google$java$contract$local$exception$3));
        }
    }
}

