/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.ContractEnvironment;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.AgentContractEnvironment;
import com.google.java.contract.core.agent.ContractClassFileTransformer;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.DebugUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.security.ProtectionDomain;
import javax.tools.JavaFileObject;
import org.objectweb.asm.ClassReader;

public class PreMain {
    public PreMain() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    private static void configure() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(PreMain.class);
        try {
            String configClass;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if ((configClass = System.getProperty("com.google.java.contract.configurator")) != null) {
                try {
                    Class<?> clazz = Class.forName(configClass);
                    Object instance = clazz.newInstance();
                    clazz.getMethod("configure", ContractEnvironment.class).invoke(instance, new AgentContractEnvironment());
                }
                catch (ClassNotFoundException e) {
                    DebugUtils.warn("agent", "cannot find configurator class");
                }
                catch (NoSuchMethodException e) {
                    DebugUtils.warn("agent", "cannot find configure method");
                }
                catch (InvocationTargetException e) {
                    DebugUtils.warn("agent", "configure method threw an exception: " + e.getTargetException().toString());
                }
                catch (Exception e) {
                    DebugUtils.warn("agent", "error during configure method: " + e.toString());
                }
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void premain(String string, Instrumentation instrumentation) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(PreMain.class);
        try {
            void inst;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            ClassFileTransformer transformer = new ContractClassFileTransformer();
            String dumpDir = System.getProperty("com.google.java.contract.dump");
            if (dumpDir != null) {
                transformer = new DumpClassFileTransformer(transformer, dumpDir);
            }
            inst.addTransformer(transformer);
            PreMain.configure();
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            throw throwable2;
        }
    }

    public static void main(String[] stringArray) throws IllegalClassFormatException, IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(PreMain.class);
        try {
            String[] args;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            String classout = System.getProperty("com.google.java.contract.classoutput");
            PreMain.instrument(args, classout, null);
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void instrument(String[] stringArray, String string, ClassLoader classLoader) throws IllegalClassFormatException, IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(PreMain.class);
        try {
            String[] args;
            void loader;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            ContractClassFileTransformer transformer = loader == null ? new ContractClassFileTransformer() : new ContractClassFileTransformer((ClassLoader)loader);
            PreMain.configure();
            String[] arr$ = args;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                File helperOutputFileName;
                File outputFileName;
                void classout;
                String arg;
                String baseName = arg = arr$[i$];
                if (arg.endsWith(JavaFileObject.Kind.CLASS.extension)) {
                    baseName = baseName.substring(0, baseName.length() - JavaFileObject.Kind.CLASS.extension.length());
                }
                if (baseName.endsWith("$com$google$java$contract$H")) continue;
                File fileName = new File(baseName + JavaFileObject.Kind.CLASS.extension);
                File contractFileName = new File(baseName + ".contracts");
                File helperFileName = new File(baseName + "$com$google$java$contract$H" + JavaFileObject.Kind.CLASS.extension);
                byte[] bytecode = PreMain.getBytes(fileName);
                byte[] instrumented = null;
                byte[] instrumentedHelper = null;
                if (classout == null) {
                    outputFileName = new File(baseName + ".class.contracted");
                    helperOutputFileName = new File(baseName + "$com$google$java$contract$H" + ".class.contracted");
                } else {
                    String className = PreMain.getClassName(bytecode);
                    String baseOutputName = (String)classout + "/" + className;
                    outputFileName = new File(baseOutputName + JavaFileObject.Kind.CLASS.extension);
                    helperOutputFileName = new File(baseOutputName + "$com$google$java$contract$H" + JavaFileObject.Kind.CLASS.extension);
                }
                if (helperFileName.isFile()) {
                    byte[] helperBytecode = PreMain.getBytes(helperFileName);
                    instrumentedHelper = transformer.transformWithDebug(helperBytecode);
                } else if (contractFileName.isFile()) {
                    byte[] contractBytecode = PreMain.getBytes(contractFileName);
                    instrumented = transformer.transformWithContracts(bytecode, contractBytecode);
                }
                outputFileName.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outputFileName);
                out.write(instrumented == null ? bytecode : instrumented);
                out.close();
                if (instrumentedHelper == null) continue;
                helperOutputFileName.getParentFile().mkdirs();
                FileOutputStream helperOut = new FileOutputStream(helperOutputFileName);
                helperOut.write(instrumentedHelper);
                helperOut.close();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            throw throwable2;
        }
    }

    private static byte[] getBytes(File file) throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(PreMain.class);
        try {
            int len;
            File path;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            FileInputStream in = new FileInputStream(path);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            in.close();
            byte[] byArray = out.toByteArray();
            if (contractContext.tryEnterContract()) {
                byte[] byArray2;
                byArray = byArray2 = byArray;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            throw throwable2;
        }
    }

    private static String getClassName(byte[] byArray) throws IllegalClassFormatException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(PreMain.class);
        try {
            String string;
            block8: {
                String string2;
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                try {
                    byte[] bytecode;
                    string = new ClassReader(bytecode).getClassName();
                    if (!contractContext.tryEnterContract()) break block8;
                }
                catch (Throwable t) {
                    IllegalClassFormatException e = new IllegalClassFormatException();
                    e.initCause(t);
                    throw e;
                }
                string = string2 = string;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(PreMain.class);
            }
            throw throwable2;
        }
    }

    @Invariant(value={"transformer != null"})
    private static class DumpClassFileTransformer
    implements ClassFileTransformer {
        protected ClassFileTransformer transformer;

        @Requires(value={"parent != null", "dumpDir != null"})
        public DumpClassFileTransformer(ClassFileTransformer parent, String dumpDir) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    this.com$google$java$contract$P$DumpClassFileTransformer(parent, dumpDir);
                    contractContext.leaveContract();
                }
                this.transformer = parent;
                DebugUtils.setDumpDirectory(dumpDir);
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == DumpClassFileTransformer.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == DumpClassFileTransformer.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
        private /* synthetic */ void com$google$java$contract$P$DumpClassFileTransformer(ClassFileTransformer parent, String dumpDir) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$PreMain$DumpClassFileTransformer$DumpClassFileTransformer(parent, dumpDir, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$agent$PreMain$DumpClassFileTransformer();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void bytecode;
                void protectionDomain2;
                void redefinedClass;
                void className;
                void loader;
                byte[] data;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if ((data = this.transformer.transform((ClassLoader)loader, (String)className, (Class<?>)redefinedClass, (ProtectionDomain)protectionDomain2, (byte[])bytecode)) != null) {
                    DebugUtils.dump((String)className, data, JavaFileObject.Kind.CLASS);
                }
                byte[] byArray2 = data;
                if (contractContext.tryEnterContract()) {
                    byte[] byArray3;
                    byArray2 = byArray3 = byArray2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return byArray2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, lines={49L})
        protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$agent$PreMain$DumpClassFileTransformer() {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = this.transformer != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                ContractRuntime.raise(new InvariantError("transformer != null", com$google$java$contract$local$exception$1));
            }
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={55L, 56L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$PreMain$DumpClassFileTransformer$DumpClassFileTransformer(ClassFileTransformer parent, String dumpDir, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = parent != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("parent != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            boolean com$google$java$contract$local$success$1 = false;
            Throwable com$google$java$contract$local$exception$3 = null;
            try {
                com$google$java$contract$local$success$1 = dumpDir != null;
            }
            catch (Throwable com$google$java$contract$local$exception$2) {
                com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
            }
            if (!com$google$java$contract$local$success$1) {
                return new PreconditionError("dumpDir != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
            }
            return null;
        }
    }
}

