/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.ClassContractCreator;
import com.google.java.contract.core.apt.ContractFinder;
import com.google.java.contract.core.apt.ContractJavaCompiler;
import com.google.java.contract.core.apt.ContractWriter;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.apt.FactoryUtils;
import com.google.java.contract.core.apt.TypeFactory;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.ElementScanner;
import com.google.java.contract.core.util.SyntheticJavaFile;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"com.google.java.contract.debug", "com.google.java.contract.dump", "com.google.java.contract.sourcepath", "com.google.java.contract.classpath", "com.google.java.contract.classoutput", "com.google.java.contract.depspath", "com.google.java.contract.experimental"})
public class AnnotationProcessor
extends AbstractProcessor {
    protected static final String OPT_DEBUG = "com.google.java.contract.debug";
    protected static final String OPT_DUMP = "com.google.java.contract.dump";
    protected static final String OPT_SOURCEPATH = "com.google.java.contract.sourcepath";
    protected static final String OPT_CLASSPATH = "com.google.java.contract.classpath";
    protected static final String OPT_CLASSOUTPUT = "com.google.java.contract.classoutput";
    protected static final String OPT_DEPSPATH = "com.google.java.contract.depspath";
    protected static final String OPT_EXPERIMENTAL = "com.google.java.contract.experimental";
    protected TypeFactory factory;
    protected FactoryUtils utils;
    protected String sourcePath;
    protected String classPath;
    protected String outputDirectory;
    protected boolean debug;
    protected boolean dump;

    public AnnotationProcessor() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void processingEnv;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            super.init((ProcessingEnvironment)processingEnv);
            Map<String, String> options = processingEnv.getOptions();
            this.debug = options.containsKey(OPT_DEBUG);
            this.dump = options.containsKey(OPT_DUMP);
            String dumpDir = options.get(OPT_DUMP);
            if (dumpDir != null) {
                DebugUtils.setDumpDirectory(dumpDir);
            }
            this.utils = new FactoryUtils((ProcessingEnvironment)processingEnv);
            this.factory = new TypeFactory(this.utils, options.get(OPT_DEPSPATH));
            this.setupPaths();
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            SourceVersion sourceVersion = SourceVersion.latest();
            if (contractContext.tryEnterContract()) {
                SourceVersion sourceVersion2;
                sourceVersion = sourceVersion2 = sourceVersion;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return sourceVersion;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void roundEnv;
            Set<TypeElement> rootElements;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if ((rootElements = this.getContractedRootElements((RoundEnvironment)roundEnv)).isEmpty()) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            DiagnosticManager diagnosticManager = new DiagnosticManager();
            List<TypeModel> types = this.createTypes(rootElements, diagnosticManager);
            boolean success = diagnosticManager.getErrorCount() == 0;
            ArrayList<SyntheticJavaFile> sources = new ArrayList<SyntheticJavaFile>(types.size());
            if (success) {
                for (TypeModel type : types) {
                    ContractWriter writer = new ContractWriter(this.debug);
                    type.accept(writer);
                    sources.add(new SyntheticJavaFile(type.getName().getBinaryName(), writer.toByteArray(), writer.getLineNumberMap()));
                }
                if (this.dump) {
                    this.dumpSources(types, sources);
                }
                try {
                    ContractJavaCompiler compiler = new ContractJavaCompiler(this.sourcePath, this.classPath, this.outputDirectory);
                    JavaCompiler.CompilationTask task = compiler.getTask(sources, diagnosticManager);
                    success = task.call();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!success || diagnosticManager.getCount() != 0) {
                for (DiagnosticManager.Report r : diagnosticManager) {
                    this.printDiagnostic(r);
                }
            }
            boolean bl4 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    private void setupPaths() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.sourcePath = this.processingEnv.getOptions().get(OPT_SOURCEPATH);
            this.classPath = this.processingEnv.getOptions().get(OPT_CLASSPATH);
            this.outputDirectory = this.processingEnv.getOptions().get(OPT_CLASSOUTPUT);
            if (this.processingEnv.getClass().getName().equals("com.sun.tools.javac.processing.JavacProcessingEnvironment")) {
                JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)this.processingEnv;
                Options options = Options.instance(javacEnv.getContext());
                if (this.sourcePath == null) {
                    this.sourcePath = options.get(OptionName.SOURCEPATH);
                }
                if (this.classPath == null) {
                    String classPath1 = options.get(OptionName.CP);
                    String classPath2 = options.get(OptionName.CLASSPATH);
                    this.classPath = classPath1 != null ? (classPath2 != null ? classPath1 + File.pathSeparator + classPath2 : classPath1) : classPath2;
                }
                if (this.outputDirectory == null) {
                    this.outputDirectory = options.get(OptionName.D);
                }
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"r != null"})
    protected void printDiagnostic(DiagnosticManager.Report report) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void r;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$printDiagnostic(report);
                contractContext.leaveContract();
            }
            Messager messager = this.processingEnv.getMessager();
            if (r.getElement() == null) {
                messager.printMessage(r.getKind(), r.getMessage(null));
            } else {
                messager.printMessage(r.getKind(), r.getMessage(null), r.getElement(), r.getAnnotationMirror(), r.getAnnotationValue());
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="printDiagnostic")
    private /* synthetic */ void com$google$java$contract$P$printDiagnostic(DiagnosticManager.Report r) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$printDiagnostic(r, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"types != null", "sources != null", "types.size() == sources.size()"})
    protected void dumpSources(List<TypeModel> list, List<SyntheticJavaFile> list2) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void sources;
            void types;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$dumpSources(list, list2);
                contractContext.leaveContract();
            }
            Iterator itType = types.iterator();
            Iterator itFile = sources.iterator();
            while (itType.hasNext() && itFile.hasNext()) {
                TypeModel type = (TypeModel)itType.next();
                SyntheticJavaFile file = (SyntheticJavaFile)itFile.next();
                DebugUtils.dump(type.getName().getBinaryName(), ((Object)file.getCharContent(true)).toString().getBytes(), JavaFileObject.Kind.SOURCE);
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="dumpSources")
    private /* synthetic */ void com$google$java$contract$P$dumpSources(List<TypeModel> types, List<SyntheticJavaFile> sources) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$dumpSources(types, sources, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"roots != null", "diagnosticManager != null"})
    @Ensures(value={"result != null", "result.size() >= roots.size()", "result.size() <= 2 * roots.size()"})
    protected List<TypeModel> createTypes(Set<TypeElement> set, DiagnosticManager diagnosticManager) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void diagnosticManager2;
            void roots;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$createTypes(set, diagnosticManager);
                contractContext.leaveContract();
            }
            boolean errors = false;
            final HashSet knownTypeNames = new HashSet();
            for (TypeElement r : roots) {
                ElementScanner6<Void, Void> visitor = new ElementScanner6<Void, Void>(){

                    @Override
                    public Void visitType(TypeElement e, Void p) {
                        knownTypeNames.add(e.getQualifiedName().toString());
                        return (Void)super.visitType(e, p);
                    }
                };
                r.accept(visitor, null);
            }
            ArrayList<TypeModel> undecoratedTypes = new ArrayList<TypeModel>(roots.size());
            for (TypeElement r : roots) {
                TypeModel type = this.factory.createType(r, (DiagnosticManager)diagnosticManager2);
                ElementScanner annotator = new ElementScanner(){

                    @Override
                    public void visitContractAnnotation(ContractAnnotationModel annotation) {
                        if (annotation.isVirtual() && knownTypeNames.contains(annotation.getOwner().getQualifiedName())) {
                            annotation.setWeakVirtual(true);
                        }
                    }
                };
                type.accept(annotator);
                undecoratedTypes.add(type);
            }
            ArrayList<TypeModel> types = new ArrayList<TypeModel>(undecoratedTypes.size());
            for (TypeModel type : undecoratedTypes) {
                ClassContractCreator creator = new ClassContractCreator((DiagnosticManager)diagnosticManager2);
                type.accept(creator);
                TypeModel helper = creator.getHelperType();
                types.add(type);
                if (helper == null) continue;
                types.add(helper);
            }
            ArrayList<TypeModel> arrayList = types;
            if (contractContext.tryEnterContract()) {
                ArrayList<TypeModel> arrayList2;
                arrayList = arrayList2 = arrayList;
                this.com$google$java$contract$Q$createTypes((Set<TypeElement>)roots, (DiagnosticManager)diagnosticManager2, arrayList2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createTypes")
    private /* synthetic */ void com$google$java$contract$P$createTypes(Set<TypeElement> roots, DiagnosticManager diagnosticManager) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$createTypes(roots, diagnosticManager, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="createTypes")
    private /* synthetic */ void com$google$java$contract$Q$createTypes(Set<TypeElement> roots, DiagnosticManager diagnosticManager, List<TypeModel> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$AnnotationProcessor$createTypes(roots, diagnosticManager, result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"roundEnv != null"})
    @Ensures(value={"result != null"})
    protected Set<TypeElement> getContractedRootElements(RoundEnvironment roundEnvironment) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void roundEnv;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$getContractedRootElements(roundEnvironment);
                contractContext.leaveContract();
            }
            Set<? extends Element> allElements = roundEnv.getRootElements();
            HashSet<TypeElement> contractedRootElements = new HashSet<TypeElement>(allElements.size());
            ContractFinder cf = new ContractFinder(this.utils);
            for (Element element : allElements) {
                if (!element.accept(cf, null).booleanValue()) continue;
                contractedRootElements.add(AnnotationProcessor.getRootElement(element));
            }
            HashSet<TypeElement> hashSet = contractedRootElements;
            if (contractContext.tryEnterContract()) {
                HashSet<TypeElement> hashSet2;
                hashSet = hashSet2 = hashSet;
                this.com$google$java$contract$Q$getContractedRootElements((RoundEnvironment)roundEnv, hashSet2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getContractedRootElements")
    private /* synthetic */ void com$google$java$contract$P$getContractedRootElements(RoundEnvironment roundEnv) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$getContractedRootElements(roundEnv, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getContractedRootElements")
    private /* synthetic */ void com$google$java$contract$Q$getContractedRootElements(RoundEnvironment roundEnv, Set<TypeElement> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$AnnotationProcessor$getContractedRootElements(roundEnv, result);
    }

    @Requires(value={"element != null", "element.getKind() != ElementKind.PACKAGE", "element.getKind() != ElementKind.OTHER"})
    @Ensures(value={"element != null"})
    protected static TypeElement getRootElement(Element element) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(AnnotationProcessor.class);
        try {
            TypeElement type;
            Element element2;
            if (contractContext.tryEnterContract()) {
                AnnotationProcessor.com$google$java$contract$P$getRootElement(element);
                contractContext.leaveContract();
            }
            if ((element2.getKind().isClass() || element2.getKind().isInterface()) && !(type = (TypeElement)element2).getNestingKind().isNested()) {
                TypeElement typeElement = type;
                if (contractContext.tryEnterContract()) {
                    TypeElement typeElement2;
                    typeElement = typeElement2 = typeElement;
                    AnnotationProcessor.com$google$java$contract$QH$com$google$java$contract$core$apt$AnnotationProcessor$getRootElement(element2, typeElement2);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(AnnotationProcessor.class);
                }
                return typeElement;
            }
            TypeElement typeElement = AnnotationProcessor.getRootElement(element2.getEnclosingElement());
            if (contractContext.tryEnterContract()) {
                TypeElement typeElement3;
                typeElement = typeElement3 = typeElement;
                AnnotationProcessor.com$google$java$contract$QH$com$google$java$contract$core$apt$AnnotationProcessor$getRootElement(element2, typeElement3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(AnnotationProcessor.class);
            }
            return typeElement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(AnnotationProcessor.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getRootElement")
    private static /* synthetic */ void com$google$java$contract$P$getRootElement(Element element) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = AnnotationProcessor.com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$getRootElement(element, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="printDiagnostic", lines={252L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$printDiagnostic(DiagnosticManager.Report r, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = r != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("r != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="dumpSources", lines={268L, 269L, 270L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$dumpSources(List<TypeModel> types, List<SyntheticJavaFile> sources, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = types != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("types != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = sources != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("sources != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = types.size() == sources.size();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("types.size() == sources.size()", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createTypes", lines={291L, 292L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$createTypes(Set<TypeElement> roots, DiagnosticManager diagnosticManager, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = roots != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("roots != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = diagnosticManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("diagnosticManager != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createTypes", lines={295L, 296L, 297L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$AnnotationProcessor$createTypes(Set<TypeElement> roots, DiagnosticManager diagnosticManager, List<TypeModel> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = result.size() >= roots.size();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("result.size() >= roots.size()", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = result.size() <= 2 * roots.size();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new PostconditionError("result.size() <= 2 * roots.size()", com$google$java$contract$local$exception$5));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getContractedRootElements", lines={371L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$getContractedRootElements(RoundEnvironment roundEnv, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = roundEnv != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("roundEnv != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getContractedRootElements", lines={372L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$AnnotationProcessor$getContractedRootElements(RoundEnvironment roundEnv, Set<TypeElement> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getRootElement", lines={393L, 394L, 395L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$AnnotationProcessor$getRootElement(Element element, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = element != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("element != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = element.getKind() != ElementKind.PACKAGE;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("element.getKind() != ElementKind.PACKAGE", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = element.getKind() != ElementKind.OTHER;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("element.getKind() != ElementKind.OTHER", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getRootElement", lines={397L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$AnnotationProcessor$getRootElement(Element element, TypeElement result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = element != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("element != null", com$google$java$contract$local$exception$1));
        }
    }
}

