/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.ContractCreation;
import com.google.java.contract.core.apt.ContractCreationTrait$com$google$java$contract$H;
import com.google.java.contract.core.apt.ContractExpressionCreationTrait;
import com.google.java.contract.core.apt.ContractExpressionTransformer;
import com.google.java.contract.core.apt.DiagnosticManager;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ContractMethodModel;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.ElementVisitor$com$google$java$contract$H;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.ElementScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

@Invariant(value={"diagnosticManager != null", "transformer != null"})
public class MethodContractCreator
extends ElementScanner {
    protected DiagnosticManager diagnosticManager;
    protected MethodModel method;
    protected ContractMethodModel preMethod;
    protected ContractMethodModel postMethod;
    protected ContractMethodModel postSignalMethod;
    protected ContractExpressionTransformer transformer;

    @Requires(value={"diagnosticManager != null"})
    public MethodContractCreator(DiagnosticManager diagnosticManager) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$MethodContractCreator(diagnosticManager);
                contractContext.leaveContract();
            }
            this.diagnosticManager = diagnosticManager;
            this.method = null;
            this.preMethod = null;
            this.postMethod = null;
            this.postSignalMethod = null;
            this.transformer = new ContractExpressionTransformer(diagnosticManager, true);
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == MethodContractCreator.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == MethodContractCreator.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$MethodContractCreator(DiagnosticManager diagnosticManager) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$MethodContractCreator(diagnosticManager, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$MethodContractCreator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethod(MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void method;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitMethod(methodModel);
                contractContext.leaveContract();
            }
            if (this.method != null) {
                throw new IllegalStateException();
            }
            this.method = method;
            super.visitMethod((MethodModel)method);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitMethod")
    private /* synthetic */ void com$google$java$contract$P$visitMethod(MethodModel method) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ElementVisitor$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$model$ElementVisitor$visitMethod(method, this, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitContractAnnotation(ContractAnnotationModel contractAnnotationModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void annotation;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$visitContractAnnotation(contractAnnotationModel);
                contractContext.leaveContract();
            }
            List<String> code = annotation.getValues();
            if (annotation.getKind().equals((Object)ElementKind.REQUIRES)) {
                PreMethodCreationTrait trait = new PreMethodCreationTrait(this.transformer);
                this.preMethod = ContractCreation.createContractMethods(trait, this.preMethod, (ContractAnnotationModel)annotation);
            } else if (annotation.getKind().equals((Object)ElementKind.ENSURES)) {
                PostMethodCreationTrait trait = new PostMethodCreationTrait(this.transformer);
                this.postMethod = ContractCreation.createContractMethods(trait, this.postMethod, (ContractAnnotationModel)annotation);
            } else if (annotation.getKind().equals((Object)ElementKind.THROW_ENSURES)) {
                PostSignalMethodCreationTrait trait = new PostSignalMethodCreationTrait(this.transformer);
                this.postSignalMethod = ContractCreation.createContractMethods(trait, this.postSignalMethod, (ContractAnnotationModel)annotation);
            } else {
                throw new IllegalArgumentException();
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="visitContractAnnotation")
    private /* synthetic */ void com$google$java$contract$P$visitContractAnnotation(ContractAnnotationModel annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ElementVisitor$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$model$ElementVisitor$visitContractAnnotation(annotation, this, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"type != null"})
    @Ensures(value={"result != null"})
    private static VariableModel getResultVariable(TypeName typeName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(MethodContractCreator.class);
        try {
            TypeName type;
            if (contractContext.tryEnterContract()) {
                MethodContractCreator.com$google$java$contract$P$getResultVariable(typeName);
                contractContext.leaveContract();
            }
            VariableModel var = new VariableModel(ElementKind.PARAMETER, "result", type);
            var.addModifier(ElementModifier.FINAL);
            VariableModel variableModel = var;
            if (contractContext.tryEnterContract()) {
                VariableModel variableModel2;
                variableModel = variableModel2 = variableModel;
                MethodContractCreator.com$google$java$contract$QH$com$google$java$contract$core$apt$MethodContractCreator$getResultVariable(type, variableModel2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            return variableModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getResultVariable")
    private static /* synthetic */ void com$google$java$contract$P$getResultVariable(TypeName type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = MethodContractCreator.com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$getResultVariable(type, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Ensures(value={"result != null"})
    private static VariableModel getSignalVariable() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(MethodContractCreator.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            VariableModel var = new VariableModel(ElementKind.PARAMETER, "signal", new ClassName("java/lang/Exception"));
            var.addModifier(ElementModifier.FINAL);
            VariableModel variableModel = var;
            if (contractContext.tryEnterContract()) {
                VariableModel variableModel2;
                variableModel = variableModel2 = variableModel;
                MethodContractCreator.com$google$java$contract$QH$com$google$java$contract$core$apt$MethodContractCreator$getSignalVariable(variableModel2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            return variableModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "pos >= 0", "id >= 0", "pos <= id", "expr != null", "annotation != null", "kind.isOld()", "lineNumber == null || lineNumber >= 1"})
    private void createOldMethods(ContractKind contractKind, int n, int n2, String string, ContractAnnotationModel contractAnnotationModel, Long l) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void id;
            void pos;
            void annotation;
            void kind;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$createOldMethods(contractKind, n, n2, string, contractAnnotationModel, l);
                contractContext.leaveContract();
            }
            MethodModel helper = ContractCreation.createBlankContractHelper((ContractKind)kind, (ContractAnnotationModel)annotation, "$" + Integer.toString((int)pos));
            helper.setReturnType(new ClassName("java/lang/Object"));
            if (helper.getKind() == ElementKind.CONTRACT_METHOD) {
                void expr;
                void lineNumber;
                ContractMethodModel helperContract = (ContractMethodModel)helper;
                if (lineNumber != null) {
                    helperContract.setLineNumbers(Collections.singletonList(lineNumber));
                }
                String code = expr;
                if (!annotation.isVirtual()) {
                    code = ContractCreation.rebaseLocalCalls((String)expr, "com$google$java$contract$local$that", null);
                }
                helperContract.addStatement("return " + code + ";");
            }
            ContractMethodModel contract2 = ContractCreation.createBlankContractMethod((ContractKind)kind, (ContractAnnotationModel)annotation, "$" + (int)id);
            contract2.setReturnType(new ClassName("java/lang/Object"));
            contract2.setId((int)id);
            contract2.addStatement("return " + ContractCreation.getHelperCallCode(helper, (ContractAnnotationModel)annotation) + ";");
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createOldMethods")
    private /* synthetic */ void com$google$java$contract$P$createOldMethods(ContractKind kind, int pos, int id, String expr, ContractAnnotationModel annotation, Long lineNumber) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$createOldMethods(kind, pos, id, expr, annotation, lineNumber, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(MethodContractCreator methodContractCreator, ContractKind contractKind, int n, int n2, String string, ContractAnnotationModel contractAnnotationModel, Long l) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(MethodContractCreator.class);
        try {
            void x6;
            void x5;
            void x4;
            void x3;
            void x2;
            void x1;
            MethodContractCreator x0;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            x0.createOldMethods((ContractKind)x1, (int)x2, (int)x3, (String)x4, (ContractAnnotationModel)x5, (Long)x6);
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            throw throwable2;
        }
    }

    static /* synthetic */ VariableModel access$100(TypeName typeName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(MethodContractCreator.class);
        try {
            TypeName x0;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            VariableModel variableModel = MethodContractCreator.getResultVariable(x0);
            if (contractContext.tryEnterContract()) {
                VariableModel variableModel2;
                variableModel = variableModel2 = variableModel;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            return variableModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            throw throwable2;
        }
    }

    static /* synthetic */ VariableModel access$200() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(MethodContractCreator.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            VariableModel variableModel = MethodContractCreator.getSignalVariable();
            if (contractContext.tryEnterContract()) {
                VariableModel variableModel2;
                variableModel = variableModel2 = variableModel;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            return variableModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(MethodContractCreator.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={52L, 53L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$MethodContractCreator() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.diagnosticManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("diagnosticManager != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.transformer != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("transformer != null", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={250L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$MethodContractCreator(DiagnosticManager diagnosticManager, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = diagnosticManager != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("diagnosticManager != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getResultVariable", lines={289L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$getResultVariable(TypeName type, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("type != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getResultVariable", lines={290L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$MethodContractCreator$getResultVariable(TypeName type, VariableModel result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getSignalVariable", lines={299L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$MethodContractCreator$getSignalVariable(VariableModel result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createOldMethods", lines={321L, 322L, 323L, 324L, 325L, 326L, 327L, 328L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$createOldMethods(ContractKind kind, int pos, int id, String expr, ContractAnnotationModel annotation, Long lineNumber, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = pos >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("pos >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = id >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("id >= 0", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = pos <= id;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("pos <= id", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = expr != null;
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            return new PreconditionError("expr != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$9);
        }
        boolean com$google$java$contract$local$success$5 = false;
        Throwable com$google$java$contract$local$exception$11 = null;
        try {
            com$google$java$contract$local$success$5 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$10) {
            com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
        }
        if (!com$google$java$contract$local$success$5) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$11);
        }
        boolean com$google$java$contract$local$success$6 = false;
        Throwable com$google$java$contract$local$exception$13 = null;
        try {
            com$google$java$contract$local$success$6 = kind.isOld();
        }
        catch (Throwable com$google$java$contract$local$exception$12) {
            com$google$java$contract$local$exception$13 = com$google$java$contract$local$exception$12;
        }
        if (!com$google$java$contract$local$success$6) {
            return new PreconditionError("kind.isOld()", com$google$java$contract$local$error, com$google$java$contract$local$exception$13);
        }
        boolean com$google$java$contract$local$success$7 = false;
        Throwable com$google$java$contract$local$exception$15 = null;
        try {
            com$google$java$contract$local$success$7 = lineNumber == null || lineNumber >= 1L;
        }
        catch (Throwable com$google$java$contract$local$exception$14) {
            com$google$java$contract$local$exception$15 = com$google$java$contract$local$exception$14;
        }
        if (!com$google$java$contract$local$success$7) {
            return new PreconditionError("lineNumber == null || lineNumber >= 1", com$google$java$contract$local$error, com$google$java$contract$local$exception$15);
        }
        return null;
    }

    protected class PostSignalMethodCreationTrait
    extends CommonPostMethodCreationTrait {
        protected List<String> messages;
        protected List<String> sourceCode;

        @Requires(value={"transformer != null"})
        public PostSignalMethodCreationTrait(ContractExpressionTransformer transformer) {
            super(transformer);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == PostSignalMethodCreationTrait.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == PostSignalMethodCreationTrait.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$ContractExpressionCreationTrait();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean visit(ContractAnnotationModel contractAnnotationModel) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void annotation;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    this.com$google$java$contract$P$visit(contractAnnotationModel);
                    contractContext.leaveContract();
                }
                this.annotation = annotation;
                List<String> assocs = annotation.getValues();
                int n = assocs.size() / 2;
                ArrayList<String> code = new ArrayList<String>(n);
                ArrayList<String> msg = new ArrayList<String>(n);
                ArrayList<String> src = new ArrayList<String>(n);
                ArrayList<Long> lines = new ArrayList<Long>(n);
                Iterator<String> it = assocs.iterator();
                Iterator<Long> itLineNumber = annotation.getLineNumbers().iterator();
                try {
                    while (it.hasNext()) {
                        String exceptionType = it.next();
                        String postcondition = it.next();
                        code.add("!(signal instanceof " + exceptionType + ") || " + postcondition);
                        msg.add(exceptionType + " => " + postcondition);
                        src.add(postcondition);
                        itLineNumber.next();
                        lines.add(itLineNumber.next());
                    }
                }
                catch (NoSuchElementException e) {
                    MethodContractCreator.this.diagnosticManager.warning("extra exception type in 'com.google.java.contract.ThrowEnsures'; ignored", assocs.get(assocs.size() - 1), 0, 0, 0, annotation.getSourceInfo());
                }
                if (!this.transform(code, lines, annotation.getSourceInfo())) {
                    boolean bl2 = false;
                    if (contractContext.tryEnterContract()) {
                        boolean bl3;
                        bl2 = bl3 = bl2;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return bl2;
                }
                this.messages = msg;
                this.sourceCode = src;
                boolean bl4 = true;
                if (contractContext.tryEnterContract()) {
                    boolean bl5;
                    bl4 = bl5 = bl4;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl4;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="visit")
        private /* synthetic */ void com$google$java$contract$P$visit(ContractAnnotationModel annotation) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = ContractCreationTrait$com$google$java$contract$H.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreationTrait$visit(annotation, this, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        @Override
        public List<? extends VariableModel> getInitialParameters() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                List<VariableModel> list = Collections.singletonList(MethodContractCreator.access$200());
                if (contractContext.tryEnterContract()) {
                    List<VariableModel> list2;
                    list = list2 = list;
                    this.com$google$java$contract$Q$getInitialParameters(list2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return list;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.POST, target="getInitialParameters")
        private /* synthetic */ void com$google$java$contract$Q$getInitialParameters(List<? extends VariableModel> result) {
            ContractCreationTrait$com$google$java$contract$H.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreationTrait$getInitialParameters(this, result);
        }

        @Override
        public List<String> getMessages() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                List<String> list = this.messages;
                if (contractContext.tryEnterContract()) {
                    List<String> list2;
                    list = list2 = list;
                    this.com$google$java$contract$Q$getMessages(list2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return list;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.POST, target="getMessages")
        private /* synthetic */ void com$google$java$contract$Q$getMessages(List<String> result) {
            ContractCreationTrait$com$google$java$contract$H.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreationTrait$getMessages(this, result);
        }

        @Override
        public List<String> getSourceExpressions() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                List<String> list = this.sourceCode;
                if (contractContext.tryEnterContract()) {
                    List<String> list2;
                    list = list2 = list;
                    this.com$google$java$contract$Q$getSourceExpressions(list2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return list;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.POST, target="getSourceExpressions")
        private /* synthetic */ void com$google$java$contract$Q$getSourceExpressions(List<String> result) {
            ContractCreationTrait$com$google$java$contract$H.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreationTrait$getSourceExpressions(this, result);
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={168L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$PostSignalMethodCreationTrait$PostSignalMethodCreationTrait(ContractExpressionTransformer transformer, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = transformer != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("transformer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }
    }

    protected class PostMethodCreationTrait
    extends CommonPostMethodCreationTrait {
        @Requires(value={"transformer != null"})
        public PostMethodCreationTrait(ContractExpressionTransformer transformer) {
            super(transformer);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == PostMethodCreationTrait.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == PostMethodCreationTrait.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$ContractExpressionCreationTrait();
        }

        @Override
        public List<? extends VariableModel> getInitialParameters() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (MethodContractCreator.this.method.isConstructor() || MethodContractCreator.this.method.getReturnType().getDeclaredName().equals("void")) {
                    List list = Collections.emptyList();
                    if (contractContext.tryEnterContract()) {
                        List list2;
                        list = list2 = list;
                        this.com$google$java$contract$Q$getInitialParameters(list2);
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return list;
                }
                List<VariableModel> list = Collections.singletonList(MethodContractCreator.access$100(MethodContractCreator.this.method.getReturnType()));
                if (contractContext.tryEnterContract()) {
                    List<VariableModel> list3;
                    list = list3 = list;
                    this.com$google$java$contract$Q$getInitialParameters(list3);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return list;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.POST, target="getInitialParameters")
        private /* synthetic */ void com$google$java$contract$Q$getInitialParameters(List<? extends VariableModel> result) {
            ContractCreationTrait$com$google$java$contract$H.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreationTrait$getInitialParameters(this, result);
        }

        @Override
        public List<? extends VariableModel> getInitialMockParameters() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (MethodContractCreator.this.method.isConstructor() || MethodContractCreator.this.method.getReturnType().getDeclaredName().equals("void")) {
                    List list = Collections.emptyList();
                    if (contractContext.tryEnterContract()) {
                        List list2;
                        list = list2 = list;
                        this.com$google$java$contract$Q$getInitialMockParameters(list2);
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return list;
                }
                List<VariableModel> list = Collections.singletonList(MethodContractCreator.access$100(this.annotation.getReturnType()));
                if (contractContext.tryEnterContract()) {
                    List<VariableModel> list3;
                    list = list3 = list;
                    this.com$google$java$contract$Q$getInitialMockParameters(list3);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return list;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.POST, target="getInitialMockParameters")
        private /* synthetic */ void com$google$java$contract$Q$getInitialMockParameters(List<? extends VariableModel> result) {
            ContractCreationTrait$com$google$java$contract$H.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreationTrait$getInitialMockParameters(this, result);
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={131L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$PostMethodCreationTrait$PostMethodCreationTrait(ContractExpressionTransformer transformer, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = transformer != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("transformer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }
    }

    protected class CommonPostMethodCreationTrait
    extends ContractExpressionCreationTrait {
        @Requires(value={"transformer != null"})
        public CommonPostMethodCreationTrait(ContractExpressionTransformer transformer) {
            super(transformer);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == CommonPostMethodCreationTrait.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == CommonPostMethodCreationTrait.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$ContractExpressionCreationTrait();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean transform(List<String> list, List<Long> list2, Object object) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void sourceInfo;
                void lineNumbers;
                void code;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    this.com$google$java$contract$P$transform(list, list2, object);
                    contractContext.leaveContract();
                }
                int id = this.transformer.getNextOldId();
                this.transformer.setAcceptOld(true);
                boolean success = super.transform((List<String>)code, (List<Long>)lineNumbers, sourceInfo);
                if (success) {
                    ContractKind oldKind = ContractCreation.getContractKind(this.annotation).getOldKind();
                    Iterator<String> iterCode = this.transformer.getOldParametersCode().iterator();
                    Iterator<Long> iterLineNumber = this.transformer.getOldParametersLineNumbers().iterator();
                    int pos = 0;
                    while (iterCode.hasNext()) {
                        MethodContractCreator.access$000(MethodContractCreator.this, oldKind, pos++, id++, iterCode.next(), this.annotation, iterLineNumber.next());
                    }
                }
                boolean bl2 = success;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="transform")
        private /* synthetic */ void com$google$java$contract$P$transform(List<String> code, List<Long> lineNumbers, Object sourceInfo) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionCreationTrait$transform(code, lineNumbers, sourceInfo, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        @Override
        public List<? extends VariableModel> getExtraParameters() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                List<VariableModel> list = this.transformer.getOldParameters();
                if (contractContext.tryEnterContract()) {
                    List<VariableModel> list2;
                    list = list2 = list;
                    this.com$google$java$contract$Q$getExtraParameters(list2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return list;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.POST, target="getExtraParameters")
        private /* synthetic */ void com$google$java$contract$Q$getExtraParameters(List<? extends VariableModel> result) {
            ContractCreationTrait$com$google$java$contract$H.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreationTrait$getExtraParameters(this, result);
        }

        @Override
        public String getExceptionName() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                String string = "com.google.java.contract.PostconditionError";
                if (contractContext.tryEnterContract()) {
                    String string2;
                    string = string2 = string;
                    this.com$google$java$contract$Q$getExceptionName(string2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return string;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.POST, target="getExceptionName")
        private /* synthetic */ void com$google$java$contract$Q$getExceptionName(String result) {
            ContractCreationTrait$com$google$java$contract$H.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreationTrait$getExceptionName(this, result);
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={86L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$CommonPostMethodCreationTrait$CommonPostMethodCreationTrait(ContractExpressionTransformer transformer, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = transformer != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("transformer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }
    }

    protected class PreMethodCreationTrait
    extends ContractExpressionCreationTrait {
        @Requires(value={"transformer != null"})
        public PreMethodCreationTrait(ContractExpressionTransformer transformer) {
            super(transformer);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    if (this.getClass() == PreMethodCreationTrait.class) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (this.getClass() == PreMethodCreationTrait.class) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.INVARIANT)
        private /* synthetic */ void com$google$java$contract$I() {
            this.com$google$java$contract$IH$com$google$java$contract$core$apt$ContractExpressionCreationTrait();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean transform(List<String> list, List<Long> list2, Object object) {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                void sourceInfo;
                void lineNumbers;
                void code;
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    this.com$google$java$contract$P$transform(list, list2, object);
                    contractContext.leaveContract();
                }
                this.transformer.setAcceptOld(false);
                boolean bl2 = super.transform((List<String>)code, (List<Long>)lineNumbers, sourceInfo);
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.PRE, target="transform")
        private /* synthetic */ void com$google$java$contract$P$transform(List<String> code, List<Long> lineNumbers, Object sourceInfo) {
            PreconditionError com$google$java$contract$local$error = null;
            if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractExpressionCreationTrait$transform(code, lineNumbers, sourceInfo, com$google$java$contract$local$error)) == null) {
                return;
            }
            ContractRuntime.raise(com$google$java$contract$local$error);
        }

        @Override
        public String getExceptionName() {
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                String string = "com.google.java.contract.PreconditionError";
                if (contractContext.tryEnterContract()) {
                    String string2;
                    string = string2 = string;
                    this.com$google$java$contract$Q$getExceptionName(string2);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return string;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        @ContractMethodSignature(kind=ContractKind.POST, target="getExceptionName")
        private /* synthetic */ void com$google$java$contract$Q$getExceptionName(String result) {
            ContractCreationTrait$com$google$java$contract$H.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreationTrait$getExceptionName(this, result);
        }

        @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={61L})
        protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$MethodContractCreator$PreMethodCreationTrait$PreMethodCreationTrait(ContractExpressionTransformer transformer, PreconditionError com$google$java$contract$local$error) {
            boolean com$google$java$contract$local$success$0 = false;
            Throwable com$google$java$contract$local$exception$1 = null;
            try {
                com$google$java$contract$local$success$0 = transformer != null;
            }
            catch (Throwable com$google$java$contract$local$exception$0) {
                com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
            }
            if (!com$google$java$contract$local$success$0) {
                return new PreconditionError("transformer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
            }
            return null;
        }
    }
}

