/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.util.Iterables;
import com.google.java.contract.util.Predicates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Invariant(value={"!isWeakVirtual() || isVirtual()", "getValues() != null", "!getValues().contains(null)", "Iterables.all(getLineNumbers(), Predicates.or(Predicates.isNull(), Predicates.between(1L, null)))", "getValues().size() == getLineNumbers().size()", "getOwner() != null"})
public class ContractAnnotationModel
extends ElementModel {
    protected boolean primary;
    protected boolean virtual;
    protected boolean weakVirtual;
    protected ClassName owner;
    protected TypeName returnType;
    protected List<String> values;
    protected List<Long> lineNumbers;

    @Requires(value={"kind != null", "owner != null", "kind.isSourceAnnotation()"})
    public ContractAnnotationModel(ElementKind kind, boolean primary, boolean virtual, ClassName owner, TypeName returnType) {
        super(kind, "<@" + kind.name() + ">");
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ContractAnnotationModel(kind, primary, virtual, owner, returnType);
                contractContext.leaveContract();
            }
            this.primary = primary;
            this.virtual = virtual;
            this.weakVirtual = false;
            this.owner = owner;
            this.returnType = returnType;
            this.values = new ArrayList<String>();
            this.lineNumbers = new ArrayList<Long>();
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ContractAnnotationModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractAnnotationModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ContractAnnotationModel(ElementKind kind, boolean primary, boolean virtual, ClassName owner, TypeName returnType) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ContractAnnotationModel$ContractAnnotationModel(kind, primary, virtual, owner, returnType, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$model$ContractAnnotationModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$ElementModel();
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public ContractAnnotationModel(ContractAnnotationModel that) {
        super(that);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$ContractAnnotationModel(that);
                contractContext.leaveContract();
            }
            this.primary = that.primary;
            this.virtual = that.virtual;
            this.weakVirtual = that.weakVirtual;
            this.owner = that.owner;
            this.returnType = that.returnType;
            this.values = new ArrayList<String>(that.values);
            this.lineNumbers = new ArrayList<Long>(that.lineNumbers);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$ContractAnnotationModel(that);
                if (this.getClass() == ContractAnnotationModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ContractAnnotationModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$ContractAnnotationModel(ContractAnnotationModel that) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ContractAnnotationModel$ContractAnnotationModel(that, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$ContractAnnotationModel(ContractAnnotationModel that) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractAnnotationModel$ContractAnnotationModel(that);
    }

    @Override
    public ContractAnnotationModel clone() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ContractAnnotationModel contractAnnotationModel = new ContractAnnotationModel(this);
            if (contractContext.tryEnterContract()) {
                ContractAnnotationModel contractAnnotationModel2;
                contractAnnotationModel = contractAnnotationModel2 = contractAnnotationModel;
                this.com$google$java$contract$Q$clone(contractAnnotationModel2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return contractAnnotationModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clone")
    private /* synthetic */ void com$google$java$contract$Q$clone(ContractAnnotationModel result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ElementModel$clone(result);
    }

    public boolean isPrimary() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.primary;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public boolean isVirtual() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.virtual;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public boolean isWeakVirtual() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.weakVirtual;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setWeakVirtual(boolean bl) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void weakVirtual;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.weakVirtual = weakVirtual;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public ClassName getOwner() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ClassName className = this.owner;
            if (contractContext.tryEnterContract()) {
                ClassName className2;
                className = className2 = className;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return className;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public TypeName getReturnType() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            TypeName typeName = this.returnType;
            if (contractContext.tryEnterContract()) {
                TypeName typeName2;
                typeName = typeName2 = typeName;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return typeName;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public List<String> getValues() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<String> list = Collections.unmodifiableList(this.values);
            if (contractContext.tryEnterContract()) {
                List<String> list2;
                list = list2 = list;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public List<Long> getLineNumbers() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<Long> list = Collections.unmodifiableList(this.lineNumbers);
            if (contractContext.tryEnterContract()) {
                List<Long> list2;
                list = list2 = list;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"getValues().isEmpty()", "getLineNumbers().isEmpty()"})
    public void clearValues() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.values.clear();
            this.lineNumbers.clear();
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$clearValues();
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clearValues")
    private /* synthetic */ void com$google$java$contract$Q$clearValues() {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractAnnotationModel$clearValues();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"value != null"})
    @Ensures(value={"getValues().size() == old(getValues().size()) + 1", "getValues().contains(value.replace('\\r', ' ').replace('\\n', ' '))", "getLineNumbers().size() == old(getLineNumbers().size()) + 1", "getLineNumbers().contains(lineNumber)"})
    public void addValue(String string, Long l) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        Object object = null;
        Object object2 = null;
        try {
            void lineNumber;
            void value;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addValue(string, l);
                object = this.com$google$java$contract$QO$addValue$0(string, l);
                object2 = this.com$google$java$contract$QO$addValue$1(string, l);
                contractContext.leaveContract();
            }
            this.values.add(value.replace('\r', ' ').replace('\n', ' '));
            this.lineNumbers.add((Long)lineNumber);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addValue((String)value, (Long)lineNumber, object, object2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addValue")
    private /* synthetic */ void com$google$java$contract$P$addValue(String value, Long lineNumber) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ContractAnnotationModel$addValue(value, lineNumber, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.OLD, id=0, target="addValue")
    private /* synthetic */ Object com$google$java$contract$QO$addValue$0(String value, Long lineNumber) {
        return this.com$google$java$contract$QOH$com$google$java$contract$core$model$ContractAnnotationModel$addValue$0(value, lineNumber);
    }

    @ContractMethodSignature(kind=ContractKind.OLD, id=1, target="addValue")
    private /* synthetic */ Object com$google$java$contract$QO$addValue$1(String value, Long lineNumber) {
        return this.com$google$java$contract$QOH$com$google$java$contract$core$model$ContractAnnotationModel$addValue$1(value, lineNumber);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addValue")
    private /* synthetic */ void com$google$java$contract$Q$addValue(String value, Long lineNumber, Object com$google$java$contract$local$old0, Object com$google$java$contract$local$old1) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ContractAnnotationModel$addValue(value, lineNumber, com$google$java$contract$local$old0, com$google$java$contract$local$old1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void obj;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (obj == this) {
                boolean bl2 = true;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            if (!(obj instanceof ContractAnnotationModel)) {
                boolean bl4 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl5;
                    bl4 = bl5 = bl4;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl4;
            }
            ContractAnnotationModel annotation = (ContractAnnotationModel)obj;
            boolean bl6 = annotation.getKind() == this.getKind() && ((Object)annotation.getValues()).equals(this.getValues());
            if (contractContext.tryEnterContract()) {
                boolean bl7;
                bl6 = bl7 = bl6;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(ElementVisitor elementVisitor) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void visitor;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$accept(elementVisitor);
                contractContext.leaveContract();
            }
            visitor.visitContractAnnotation(this);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="accept")
    private /* synthetic */ void com$google$java$contract$P$accept(ElementVisitor visitor) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ElementModel$accept(visitor, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={39L, 40L, 41L, 42L, 44L, 45L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$model$ContractAnnotationModel() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.isWeakVirtual() || this.isVirtual();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("!isWeakVirtual() || isVirtual()", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getValues() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("getValues() != null", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = !this.getValues().contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("!getValues().contains(null)", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = Iterables.all(this.getLineNumbers(), Predicates.or(Predicates.isNull(), Predicates.between(1L, null)));
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("Iterables.all(getLineNumbers(), Predicates.or(Predicates.isNull(), Predicates.between(1L, null)))", com$google$java$contract$local$exception$7));
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = this.getValues().size() == this.getLineNumbers().size();
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            ContractRuntime.raise(new InvariantError("getValues().size() == getLineNumbers().size()", com$google$java$contract$local$exception$9));
        }
        boolean com$google$java$contract$local$success$5 = false;
        Throwable com$google$java$contract$local$exception$11 = null;
        try {
            com$google$java$contract$local$success$5 = this.getOwner() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$10) {
            com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
        }
        if (!com$google$java$contract$local$success$5) {
            ContractRuntime.raise(new InvariantError("getOwner() != null", com$google$java$contract$local$exception$11));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={108L, 109L, 110L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ContractAnnotationModel$ContractAnnotationModel(ElementKind kind, boolean primary, boolean virtual, ClassName owner, TypeName returnType, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = owner != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("owner != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = kind.isSourceAnnotation();
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("kind.isSourceAnnotation()", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={129L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ContractAnnotationModel$ContractAnnotationModel(ContractAnnotationModel that, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = that != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("that != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={130L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractAnnotationModel$ContractAnnotationModel(ContractAnnotationModel that) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosingElement() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getEnclosingElement() == null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="clearValues", lines={180L, 181L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractAnnotationModel$clearValues() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getValues().isEmpty();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getValues().isEmpty()", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getLineNumbers().isEmpty();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("getLineNumbers().isEmpty()", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addValue", lines={188L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$ContractAnnotationModel$addValue(String value, Long lineNumber, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = value != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("value != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addValue", lines={190L})
    protected /* synthetic */ Object com$google$java$contract$QOH$com$google$java$contract$core$model$ContractAnnotationModel$addValue$0(String value, Long lineNumber) {
        return this.getValues().size();
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addValue", lines={192L})
    protected /* synthetic */ Object com$google$java$contract$QOH$com$google$java$contract$core$model$ContractAnnotationModel$addValue$1(String value, Long lineNumber) {
        return this.getLineNumbers().size();
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addValue", lines={190L, 191L, 192L, 193L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$ContractAnnotationModel$addValue(String value, Long lineNumber, Object com$google$java$contract$local$old0, Object com$google$java$contract$local$old1) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getValues().size() == ContractRuntime.magicCast(com$google$java$contract$local$old0, null) + 1;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getValues().size() == old(getValues().size()) + 1", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getValues().contains(value.replace('\r', ' ').replace('\n', ' '));
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("getValues().contains(value.replace('\\r', ' ').replace('\\n', ' '))", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.getLineNumbers().size() == ContractRuntime.magicCast(com$google$java$contract$local$old1, null) + 1;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new PostconditionError("getLineNumbers().size() == old(getLineNumbers().size()) + 1", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = this.getLineNumbers().contains(lineNumber);
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new PostconditionError("getLineNumbers().contains(lineNumber)", com$google$java$contract$local$exception$7));
        }
    }
}

