/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.QualifiedElementModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Invariant(value={"getTypeParameters() != null", "!getTypeParameters().contains(null)"})
public abstract class GenericElementModel
extends QualifiedElementModel {
    protected List<TypeName> typeParameters;

    @Requires(value={"kind != null", "name != null"})
    protected GenericElementModel(ElementKind kind, String name) {
        super(kind, name);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$GenericElementModel(kind, name);
                contractContext.leaveContract();
            }
            this.typeParameters = new ArrayList<TypeName>();
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == GenericElementModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == GenericElementModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$GenericElementModel(ElementKind kind, String name) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$GenericElementModel$GenericElementModel(kind, name, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$model$GenericElementModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$QualifiedElementModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$ElementModel();
    }

    @Requires(value={"that != null"})
    protected GenericElementModel(GenericElementModel that) {
        super(that);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$GenericElementModel(that);
                contractContext.leaveContract();
            }
            this.typeParameters = new ArrayList<TypeName>(that.typeParameters);
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == GenericElementModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == GenericElementModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$GenericElementModel(GenericElementModel that) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$GenericElementModel$GenericElementModel(that, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Override
    protected GenericElementModel clone() throws CloneNotSupportedException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            throw new CloneNotSupportedException();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public List<? extends TypeName> getTypeParameters() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<TypeName> list = Collections.unmodifiableList(this.typeParameters);
            if (contractContext.tryEnterContract()) {
                List<TypeName> list2;
                list = list2 = list;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"getTypeParameters().isEmpty()"})
    public void clearTypeParameters() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.typeParameters.clear();
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$clearTypeParameters();
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clearTypeParameters")
    private /* synthetic */ void com$google$java$contract$Q$clearTypeParameters() {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$GenericElementModel$clearTypeParameters();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"typeName != null"})
    @Ensures(value={"getTypeParameters().size() == old(getTypeParameters().size()) + 1", "getTypeParameters().contains(typeName)"})
    public void addTypeParameter(TypeName typeName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        Object object = null;
        try {
            void typeName2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addTypeParameter(typeName);
                object = this.com$google$java$contract$QO$addTypeParameter$0(typeName);
                contractContext.leaveContract();
            }
            this.typeParameters.add((TypeName)typeName2);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addTypeParameter((TypeName)typeName2, object);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addTypeParameter")
    private /* synthetic */ void com$google$java$contract$P$addTypeParameter(TypeName typeName) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$GenericElementModel$addTypeParameter(typeName, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.OLD, id=0, target="addTypeParameter")
    private /* synthetic */ Object com$google$java$contract$QO$addTypeParameter$0(TypeName typeName) {
        return this.com$google$java$contract$QOH$com$google$java$contract$core$model$GenericElementModel$addTypeParameter$0(typeName);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addTypeParameter")
    private /* synthetic */ void com$google$java$contract$Q$addTypeParameter(TypeName typeName, Object com$google$java$contract$local$old0) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$GenericElementModel$addTypeParameter(typeName, com$google$java$contract$local$old0);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clone")
    private /* synthetic */ void com$google$java$contract$Q$clone(GenericElementModel result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ElementModel$clone(result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={35L, 36L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$model$GenericElementModel() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getTypeParameters() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("getTypeParameters() != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !this.getTypeParameters().contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("!getTypeParameters().contains(null)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={50L, 51L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$GenericElementModel$GenericElementModel(ElementKind kind, String name, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={62L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$GenericElementModel$GenericElementModel(GenericElementModel that, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = that != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("that != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="clearTypeParameters", lines={77L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$GenericElementModel$clearTypeParameters() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getTypeParameters().isEmpty();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getTypeParameters().isEmpty()", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addTypeParameter", lines={82L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$GenericElementModel$addTypeParameter(TypeName typeName, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = typeName != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("typeName != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addTypeParameter", lines={84L})
    protected /* synthetic */ Object com$google$java$contract$QOH$com$google$java$contract$core$model$GenericElementModel$addTypeParameter$0(TypeName typeName) {
        return this.getTypeParameters().size();
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addTypeParameter", lines={84L, 85L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$GenericElementModel$addTypeParameter(TypeName typeName, Object com$google$java$contract$local$old0) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getTypeParameters().size() == ContractRuntime.magicCast(com$google$java$contract$local$old0, null) + 1;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getTypeParameters().size() == old(getTypeParameters().size()) + 1", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getTypeParameters().contains(typeName);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("getTypeParameters().contains(typeName)", com$google$java$contract$local$exception$3));
        }
    }
}

