/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.JavaTokenizer;
import com.google.java.contract.core.util.LineNumberingTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;

@Invariant(value={"stack != null", "!stack.contains(null)"})
public class BalancedTokenizer
extends LineNumberingTokenizer {
    protected Deque<Character> stack;

    @Requires(value={"reader != null"})
    public BalancedTokenizer(Reader reader) {
        super(reader);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$BalancedTokenizer(reader);
                contractContext.leaveContract();
            }
            this.stack = new ArrayDeque<Character>();
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == BalancedTokenizer.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == BalancedTokenizer.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$BalancedTokenizer(Reader reader) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$BalancedTokenizer$BalancedTokenizer(reader, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$util$BalancedTokenizer();
        this.com$google$java$contract$IH$com$google$java$contract$core$util$LineNumberingTokenizer();
        this.com$google$java$contract$IH$com$google$java$contract$core$util$JavaTokenizer();
    }

    @Ensures(value={"result != null", "result.size() == getCurrentLevel()"})
    public Collection<Character> getStack() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Collection<Character> collection = Collections.unmodifiableCollection(this.stack);
            if (contractContext.tryEnterContract()) {
                Collection<Character> collection2;
                collection = collection2 = collection;
                this.com$google$java$contract$Q$getStack(collection2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return collection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getStack")
    private /* synthetic */ void com$google$java$contract$Q$getStack(Collection<Character> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$util$BalancedTokenizer$getStack(result);
    }

    @Ensures(value={"result >= 0", "result == getStack().size()"})
    public int getCurrentLevel() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            int n = this.stack.size();
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                this.com$google$java$contract$Q$getCurrentLevel(n2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getCurrentLevel")
    private /* synthetic */ void com$google$java$contract$Q$getCurrentLevel(int result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$util$BalancedTokenizer$getCurrentLevel(result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"\"()[]{}\".indexOf(c) != -1"})
    protected char getMatchingDelimiter(char c) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void c2;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getMatchingDelimiter(c);
                contractContext.leaveContract();
            }
            switch (c2) {
                case 40: {
                    char c3 = ')';
                    if (contractContext.tryEnterContract()) {
                        char c4;
                        c3 = c4 = c3;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return c3;
                }
                case 91: {
                    char c5 = ']';
                    if (contractContext.tryEnterContract()) {
                        char c6;
                        c5 = c6 = c5;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return c5;
                }
                case 123: {
                    char c7 = '}';
                    if (contractContext.tryEnterContract()) {
                        char c8;
                        c7 = c8 = c7;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return c7;
                }
                case 41: {
                    char c9 = '(';
                    if (contractContext.tryEnterContract()) {
                        char c10;
                        c9 = c10 = c9;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return c9;
                }
                case 93: {
                    char c11 = '[';
                    if (contractContext.tryEnterContract()) {
                        char c12;
                        c11 = c12 = c11;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return c11;
                }
                case 125: {
                    char c13 = '{';
                    if (contractContext.tryEnterContract()) {
                        char c14;
                        c13 = c14 = c13;
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return c13;
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getMatchingDelimiter")
    private /* synthetic */ void com$google$java$contract$P$getMatchingDelimiter(char c) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$BalancedTokenizer$getMatchingDelimiter(c, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Override
    protected boolean lex() throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$lex();
                contractContext.leaveContract();
            }
            if (!super.lex()) {
                if (!this.stack.isEmpty()) {
                    char d = this.getMatchingDelimiter(this.stack.pop().charValue());
                    this.errorMessage = "'" + d + "' expected";
                    this.hasErrors_ = true;
                    boolean bl2 = false;
                    if (contractContext.tryEnterContract()) {
                        boolean bl3;
                        bl2 = bl3 = bl2;
                        this.com$google$java$contract$Q$lex(bl3);
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return bl2;
                }
                boolean bl4 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl5;
                    bl4 = bl5 = bl4;
                    this.com$google$java$contract$Q$lex(bl5);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl4;
            }
            if (this.nextToken.kind == JavaTokenizer.TokenKind.SYMBOL) {
                char c = this.nextToken.text.charAt(0);
                switch (c) {
                    case '(': 
                    case '[': 
                    case '{': {
                        this.stack.push(Character.valueOf(c));
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        String error = null;
                        if (this.stack.isEmpty()) {
                            error = "unexpected '" + c + "'";
                        } else {
                            char d = this.getMatchingDelimiter(this.stack.pop().charValue());
                            if (d != c) {
                                error = "'" + d + "' expected";
                            }
                        }
                        if (error == null) break;
                        this.unreadChar(c);
                        this.nextToken = null;
                        this.errorMessage = error;
                        this.hasErrors_ = true;
                        boolean bl6 = false;
                        if (contractContext.tryEnterContract()) {
                            boolean bl7;
                            bl6 = bl7 = bl6;
                            this.com$google$java$contract$Q$lex(bl7);
                            if (bl) {
                                this.com$google$java$contract$I();
                            }
                            contractContext.leaveContract();
                        }
                        if (bl) {
                            contractContext.leave(this);
                        }
                        return bl6;
                    }
                }
            }
            boolean bl8 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl9;
                bl8 = bl9 = bl8;
                this.com$google$java$contract$Q$lex(bl9);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl8;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="lex")
    private /* synthetic */ void com$google$java$contract$P$lex() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$JavaTokenizer$lex(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="lex")
    private /* synthetic */ void com$google$java$contract$Q$lex(boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$util$JavaTokenizer$lex(result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={44L, 45L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$util$BalancedTokenizer() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.stack != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("stack != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !this.stack.contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("!stack.contains(null)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={58L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$BalancedTokenizer$BalancedTokenizer(Reader reader, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = reader != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("reader != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getStack", lines={65L, 66L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$BalancedTokenizer$getStack(Collection<Character> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = result.size() == this.getCurrentLevel();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("result.size() == getCurrentLevel()", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getCurrentLevel", lines={73L, 74L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$BalancedTokenizer$getCurrentLevel(int result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result >= 0;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result >= 0", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = result == this.getStack().size();
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("result == getStack().size()", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getMatchingDelimiter", lines={80L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$BalancedTokenizer$getMatchingDelimiter(char c, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = "()[]{}".indexOf(c) != -1;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("\"()[]{}\".indexOf(c) != -1", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }
}

