/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.JavaTokenizer;
import com.google.java.contract.core.util.PushbackTokenizer;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.regex.Pattern;
import javax.tools.JavaFileObject;

public class JavaUtils {
    public static final String CONTRACTS_EXTENSION = ".contracts";
    public static final String CONTRACTED_EXTENSION = ".class.contracted";
    public static final String SOURCE_DEPENDENCY_EXTENSION = ".java.d";
    public static final String BEGIN_GENERATED_CODE = "/*[*/";
    public static final String END_GENERATED_CODE = "/*]*/";
    public static final String BEGIN_LOCATION_COMMENT = "/*[";
    public static final String END_LOCATION_COMMENT = "]*/";
    public static final String RESULT_VARIABLE = "result";
    public static final String SIGNAL_VARIABLE = "signal";
    public static final String HELPER_CLASS_SUFFIX = "$com$google$java$contract$H";
    public static final String SYNTHETIC_MEMBER_PREFIX = "com$google$java$contract$S";
    public static final String OLD_VARIABLE_PREFIX = "com$google$java$contract$local$old";
    public static final String SUCCESS_VARIABLE_PREFIX = "com$google$java$contract$local$success";
    public static final String EXCEPTION_VARIABLE_PREFIX = "com$google$java$contract$local$exception";
    public static final String ERROR_VARIABLE = "com$google$java$contract$local$error";
    public static final String THAT_VARIABLE = "com$google$java$contract$local$that";

    public JavaUtils() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"obj != null", "className != null"})
    public static boolean objectIsCastableTo(Object object, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            boolean bl2;
            block10: {
                boolean bl3;
                if (contractContext.tryEnterContract()) {
                    JavaUtils.com$google$java$contract$P$objectIsCastableTo(object, string);
                    contractContext.leaveContract();
                }
                try {
                    Object obj;
                    void className;
                    Class<?> clazz = Class.forName((String)className);
                    bl2 = clazz.isAssignableFrom(obj.getClass());
                    if (!contractContext.tryEnterContract()) break block10;
                }
                catch (Exception e) {
                    boolean bl4 = false;
                    if (contractContext.tryEnterContract()) {
                        boolean bl5;
                        bl4 = bl5 = bl4;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(JavaUtils.class);
                    }
                    return bl4;
                }
                bl2 = bl3 = bl2;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="objectIsCastableTo")
    private static /* synthetic */ void com$google$java$contract$P$objectIsCastableTo(Object obj, String className) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$objectIsCastableTo(obj, className, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"className != null"})
    public static boolean classExists(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            boolean bl2;
            block10: {
                boolean bl3;
                if (contractContext.tryEnterContract()) {
                    JavaUtils.com$google$java$contract$P$classExists(string);
                    contractContext.leaveContract();
                }
                try {
                    String className;
                    Class.forName(className);
                    bl2 = true;
                    if (!contractContext.tryEnterContract()) break block10;
                }
                catch (Exception e) {
                    boolean bl4 = false;
                    if (contractContext.tryEnterContract()) {
                        boolean bl5;
                        bl4 = bl5 = bl4;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(JavaUtils.class);
                    }
                    return bl4;
                }
                bl2 = bl3 = bl2;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="classExists")
    private static /* synthetic */ void com$google$java$contract$P$classExists(String className) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$classExists(className, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"str != null"})
    @Ensures(value={"result != null"})
    public static String quoteComment(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            String str;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$quoteComment(string);
                contractContext.leaveContract();
            }
            String string2 = str.replace("/*", "/\\*").replace("*/", "*\\/");
            if (contractContext.tryEnterContract()) {
                String string3;
                string2 = string3 = string2;
                JavaUtils.com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$quoteComment(str, string3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="quoteComment")
    private static /* synthetic */ void com$google$java$contract$P$quoteComment(String str) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$quoteComment(str, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"code != null"})
    @Ensures(value={"result != null"})
    public static String deleteComments(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            String code;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$deleteComments(string);
                contractContext.leaveContract();
            }
            StringBuilder buffer = new StringBuilder();
            JavaTokenizer tokenizer = new JavaTokenizer(new StringReader(code));
            while (tokenizer.hasNext()) {
                JavaTokenizer.Token token = tokenizer.next();
                if (token.kind == JavaTokenizer.TokenKind.COMMENT) continue;
                buffer.append(token.text);
            }
            String string2 = buffer.toString();
            if (contractContext.tryEnterContract()) {
                String string3;
                string2 = string3 = string2;
                JavaUtils.com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$deleteComments(code, string3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="deleteComments")
    private static /* synthetic */ void com$google$java$contract$P$deleteComments(String code) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$deleteComments(code, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"code != null"})
    @Ensures(value={"result != null", "code.length() == result.length() + generatedCodeLength(code)"})
    public static String deleteGeneratedCode(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            String code;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$deleteGeneratedCode(string);
                contractContext.leaveContract();
            }
            StringBuilder buffer = new StringBuilder();
            JavaTokenizer tokenizer = new JavaTokenizer(new StringReader(code));
            boolean ignore = false;
            while (tokenizer.hasNext()) {
                JavaTokenizer.Token token = tokenizer.next();
                if (!ignore) {
                    if (token.kind == JavaTokenizer.TokenKind.COMMENT && token.text.equals(BEGIN_GENERATED_CODE)) {
                        ignore = true;
                        continue;
                    }
                    buffer.append(token.text);
                    continue;
                }
                if (token.kind != JavaTokenizer.TokenKind.COMMENT || !token.text.equals(END_GENERATED_CODE)) continue;
                ignore = false;
            }
            String string2 = buffer.toString();
            if (contractContext.tryEnterContract()) {
                String string3;
                string2 = string3 = string2;
                JavaUtils.com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$deleteGeneratedCode(code, string3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="deleteGeneratedCode")
    private static /* synthetic */ void com$google$java$contract$P$deleteGeneratedCode(String code) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$deleteGeneratedCode(code, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"code != null"})
    @Ensures(value={"result == code.length() - deleteGeneratedCode(code).length()"})
    public static int generatedCodeLength(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            String code;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$generatedCodeLength(string);
                contractContext.leaveContract();
            }
            int length = 0;
            JavaTokenizer tokenizer = new JavaTokenizer(new StringReader(code));
            boolean ignore = false;
            while (tokenizer.hasNext()) {
                JavaTokenizer.Token token = tokenizer.next();
                if (!ignore) {
                    if (token.kind != JavaTokenizer.TokenKind.COMMENT || !token.text.equals(BEGIN_GENERATED_CODE)) continue;
                    ignore = true;
                    length += token.text.length();
                    continue;
                }
                if (token.kind == JavaTokenizer.TokenKind.COMMENT && token.text.equals(END_GENERATED_CODE)) {
                    ignore = false;
                }
                length += token.text.length();
            }
            int n = length;
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                JavaUtils.com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$generatedCodeLength(code, n2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="generatedCodeLength")
    private static /* synthetic */ void com$google$java$contract$P$generatedCodeLength(String code) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$generatedCodeLength(code, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"code != null", "map != null"})
    @Ensures(value={"result != null"})
    public static String renameLocalVariables(String string, Map<String, String> map) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            void map2;
            String code;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$renameLocalVariables(string, map);
                contractContext.leaveContract();
            }
            StringBuilder buffer = new StringBuilder();
            JavaTokenizer tokenizer = new JavaTokenizer(new StringReader(code));
            boolean qualified = false;
            while (tokenizer.hasNext()) {
                JavaTokenizer.Token token = tokenizer.next();
                if (!qualified && token.kind == JavaTokenizer.TokenKind.WORD) {
                    String replacement = (String)map2.get(token.text);
                    if (replacement != null) {
                        buffer.append(replacement);
                    } else {
                        buffer.append(token.text);
                    }
                } else {
                    buffer.append(token.text);
                }
                qualified = token.text.equals(".");
            }
            String string2 = buffer.toString();
            if (contractContext.tryEnterContract()) {
                String string3;
                string2 = string3 = string2;
                JavaUtils.com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$renameLocalVariables(code, (Map<String, String>)map2, string3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="renameLocalVariables")
    private static /* synthetic */ void com$google$java$contract$P$renameLocalVariables(String code, Map<String, String> map) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$renameLocalVariables(code, map, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"tokenizer != null", "text != null"})
    public static boolean lookingAt(PushbackTokenizer pushbackTokenizer, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            void text;
            PushbackTokenizer tokenizer;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$lookingAt(pushbackTokenizer, string);
                contractContext.leaveContract();
            }
            JavaTokenizer.Token token1 = tokenizer.peek(0);
            JavaTokenizer.Token token2 = tokenizer.peek(1);
            if (token1 == null) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(JavaUtils.class);
                }
                return bl2;
            }
            if (!token1.text.equals(text)) {
                if (token1.kind != JavaTokenizer.TokenKind.SPACE) {
                    boolean bl4 = false;
                    if (contractContext.tryEnterContract()) {
                        boolean bl5;
                        bl4 = bl5 = bl4;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(JavaUtils.class);
                    }
                    return bl4;
                }
                if (token2 == null) {
                    boolean bl6 = false;
                    if (contractContext.tryEnterContract()) {
                        boolean bl7;
                        bl6 = bl7 = bl6;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(JavaUtils.class);
                    }
                    return bl6;
                }
                if (!token2.text.equals(text)) {
                    boolean bl8 = false;
                    if (contractContext.tryEnterContract()) {
                        boolean bl9;
                        bl8 = bl9 = bl8;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(JavaUtils.class);
                    }
                    return bl8;
                }
            }
            boolean bl10 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl11;
                bl10 = bl11 = bl10;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return bl10;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="lookingAt")
    private static /* synthetic */ void com$google$java$contract$P$lookingAt(PushbackTokenizer tokenizer, String text) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$lookingAt(tokenizer, text, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"tokenizer != null", "text != null"})
    public static void skipPast(JavaTokenizer javaTokenizer, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            void text;
            JavaTokenizer tokenizer;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$skipPast(javaTokenizer, string);
                contractContext.leaveContract();
            }
            while (tokenizer.hasNext() && !tokenizer.next().text.equals(text)) {
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="skipPast")
    private static /* synthetic */ void com$google$java$contract$P$skipPast(JavaTokenizer tokenizer, String text) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$skipPast(tokenizer, text, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"tokenizer != null"})
    @Ensures(value={"!acceptStar ? ClassName.isQualifiedName(result): ClassName.isQualifiedName(result)|| ClassName.isQualifiedName(result.substring(0, result.length() - 2))"})
    public static String parseQualifiedName(JavaTokenizer javaTokenizer, boolean bl) throws ParseException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(JavaUtils.class);
        try {
            void acceptStar;
            JavaTokenizer tokenizer;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$parseQualifiedName(javaTokenizer, bl);
                contractContext.leaveContract();
            }
            StringBuilder buffer = new StringBuilder();
            boolean expectWord = true;
            block11: while (tokenizer.hasNext()) {
                JavaTokenizer.Token token = tokenizer.getNextToken();
                block1 : switch (token.kind) {
                    case WORD: {
                        if (!expectWord) break block11;
                        buffer.append(token.text);
                        expectWord = false;
                        break;
                    }
                    case SYMBOL: {
                        switch (token.text.charAt(0)) {
                            case '.': {
                                if (expectWord) break block11;
                                buffer.append(".");
                                expectWord = true;
                                break block1;
                            }
                            case '*': {
                                if (acceptStar == false || !expectWord) break block11;
                                buffer.append("*");
                                tokenizer.next();
                                break;
                            }
                        }
                        break block11;
                    }
                    case SPACE: {
                        break;
                    }
                    default: {
                        break block11;
                    }
                }
                tokenizer.next();
            }
            if (buffer.length() == 0) {
                throw new ParseException("next token is not part of an identifier");
            }
            String string = buffer.toString();
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                JavaUtils.com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$parseQualifiedName(tokenizer, (boolean)acceptStar, string2);
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(JavaUtils.class);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="parseQualifiedName")
    private static /* synthetic */ void com$google$java$contract$P$parseQualifiedName(JavaTokenizer tokenizer, boolean acceptStar) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$parseQualifiedName(tokenizer, acceptStar, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    public static String parseQualifiedName(JavaTokenizer javaTokenizer) throws ParseException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            JavaTokenizer tokenizer;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            String string = JavaUtils.parseQualifiedName(tokenizer, false);
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"path != null"})
    public static URLClassLoader getLoaderForPath(String string, ClassLoader classLoader) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            void parent;
            String path;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$getLoaderForPath(string, classLoader);
                contractContext.leaveContract();
            }
            String[] parts = path.split(Pattern.quote(File.pathSeparator));
            URL[] urls = new URL[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                try {
                    urls[i] = new File(parts[i]).toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (parent == null) {
                URLClassLoader uRLClassLoader = new URLClassLoader(urls);
                if (contractContext.tryEnterContract()) {
                    URLClassLoader uRLClassLoader2;
                    uRLClassLoader = uRLClassLoader2 = uRLClassLoader;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(JavaUtils.class);
                }
                return uRLClassLoader;
            }
            URLClassLoader uRLClassLoader = new URLClassLoader(urls, (ClassLoader)parent);
            if (contractContext.tryEnterContract()) {
                URLClassLoader uRLClassLoader3;
                uRLClassLoader = uRLClassLoader3 = uRLClassLoader;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return uRLClassLoader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getLoaderForPath")
    private static /* synthetic */ void com$google$java$contract$P$getLoaderForPath(String path, ClassLoader parent) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$getLoaderForPath(path, parent, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"path != null"})
    public static URLClassLoader getLoaderForPath(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            String path;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$getLoaderForPath(string);
                contractContext.leaveContract();
            }
            URLClassLoader uRLClassLoader = JavaUtils.getLoaderForPath(path, null);
            if (contractContext.tryEnterContract()) {
                URLClassLoader uRLClassLoader2;
                uRLClassLoader = uRLClassLoader2 = uRLClassLoader;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return uRLClassLoader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getLoaderForPath")
    private static /* synthetic */ void com$google$java$contract$P$getLoaderForPath(String path) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$getLoaderForPath(path, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"ClassName.isBinaryName(className)"})
    public static InputStream getClassInputStream(ClassLoader classLoader, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            ClassLoader loader;
            void className;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$getClassInputStream(classLoader, string);
                contractContext.leaveContract();
            }
            String fileName = (String)className + JavaFileObject.Kind.CLASS.extension;
            if (loader != null) {
                URL url = loader.getResource(fileName);
                if (url == null) {
                    InputStream inputStream = null;
                    if (contractContext.tryEnterContract()) {
                        InputStream inputStream2;
                        inputStream = inputStream2 = inputStream;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(JavaUtils.class);
                    }
                    return inputStream;
                }
                DebugUtils.info("loader", "found " + url);
                InputStream inputStream = loader.getResourceAsStream(fileName);
                if (contractContext.tryEnterContract()) {
                    InputStream inputStream3;
                    inputStream = inputStream3 = inputStream;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(JavaUtils.class);
                }
                return inputStream;
            }
            URL url = ClassLoader.getSystemResource(fileName);
            if (url == null) {
                InputStream inputStream = null;
                if (contractContext.tryEnterContract()) {
                    InputStream inputStream4;
                    inputStream = inputStream4 = inputStream;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(JavaUtils.class);
                }
                return inputStream;
            }
            DebugUtils.info("loader", "found " + url);
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(fileName);
            if (contractContext.tryEnterContract()) {
                InputStream inputStream5;
                inputStream = inputStream5 = inputStream;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getClassInputStream")
    private static /* synthetic */ void com$google$java$contract$P$getClassInputStream(ClassLoader loader, String className) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$getClassInputStream(loader, className, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"ClassName.isBinaryName(className)"})
    public static InputStream getContractClassInputStream(ClassLoader classLoader, String string, boolean bl) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(JavaUtils.class);
        try {
            void loadHelper;
            ClassLoader loader;
            void className;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$getContractClassInputStream(classLoader, string, bl);
                contractContext.leaveContract();
            }
            String fileName = (String)className + CONTRACTS_EXTENSION;
            String helperFileName = (String)className + HELPER_CLASS_SUFFIX + JavaFileObject.Kind.CLASS.extension;
            if (loader != null) {
                URL url = loader.getResource(helperFileName);
                if (url != null && loadHelper != false) {
                    DebugUtils.info("loader", "found " + url);
                    InputStream inputStream = loader.getResourceAsStream(helperFileName);
                    if (contractContext.tryEnterContract()) {
                        InputStream inputStream2;
                        inputStream = inputStream2 = inputStream;
                        contractContext.leaveContract();
                    }
                    if (bl2) {
                        contractContext.leave(JavaUtils.class);
                    }
                    return inputStream;
                }
                url = loader.getResource(fileName);
                if (url != null) {
                    DebugUtils.info("loader", "found " + url);
                    InputStream inputStream = loader.getResourceAsStream(fileName);
                    if (contractContext.tryEnterContract()) {
                        InputStream inputStream3;
                        inputStream = inputStream3 = inputStream;
                        contractContext.leaveContract();
                    }
                    if (bl2) {
                        contractContext.leave(JavaUtils.class);
                    }
                    return inputStream;
                }
                InputStream inputStream = null;
                if (contractContext.tryEnterContract()) {
                    InputStream inputStream4;
                    inputStream = inputStream4 = inputStream;
                    contractContext.leaveContract();
                }
                if (bl2) {
                    contractContext.leave(JavaUtils.class);
                }
                return inputStream;
            }
            URL url = ClassLoader.getSystemResource(helperFileName);
            if (url != null && loadHelper != false) {
                DebugUtils.info("loader", "found " + url);
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(helperFileName);
                if (contractContext.tryEnterContract()) {
                    InputStream inputStream5;
                    inputStream = inputStream5 = inputStream;
                    contractContext.leaveContract();
                }
                if (bl2) {
                    contractContext.leave(JavaUtils.class);
                }
                return inputStream;
            }
            url = ClassLoader.getSystemResource(fileName);
            if (url != null) {
                DebugUtils.info("loader", "found " + url);
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(fileName);
                if (contractContext.tryEnterContract()) {
                    InputStream inputStream6;
                    inputStream = inputStream6 = inputStream;
                    contractContext.leaveContract();
                }
                if (bl2) {
                    contractContext.leave(JavaUtils.class);
                }
                return inputStream;
            }
            InputStream inputStream = null;
            if (contractContext.tryEnterContract()) {
                InputStream inputStream7;
                inputStream = inputStream7 = inputStream;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(JavaUtils.class);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getContractClassInputStream")
    private static /* synthetic */ void com$google$java$contract$P$getContractClassInputStream(ClassLoader loader, String className, boolean loadHelper) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$getContractClassInputStream(loader, className, loadHelper, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getContractClassInputStream(ClassLoader classLoader, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            void className;
            ClassLoader loader;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            InputStream inputStream = JavaUtils.getContractClassInputStream(loader, (String)className, false);
            if (contractContext.tryEnterContract()) {
                InputStream inputStream2;
                inputStream = inputStream2 = inputStream;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"className != null"})
    public static boolean resourceExists(ClassLoader classLoader, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(JavaUtils.class);
        try {
            void className;
            ClassLoader loader;
            if (contractContext.tryEnterContract()) {
                JavaUtils.com$google$java$contract$P$resourceExists(classLoader, string);
                contractContext.leaveContract();
            }
            if (loader != null) {
                boolean bl2 = loader.getResource((String)className) != null;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(JavaUtils.class);
                }
                return bl2;
            }
            boolean bl4 = ClassLoader.getSystemResource((String)className) != null;
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(JavaUtils.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="resourceExists")
    private static /* synthetic */ void com$google$java$contract$P$resourceExists(ClassLoader loader, String className) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = JavaUtils.com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$resourceExists(loader, className, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="objectIsCastableTo", lines={162L, 163L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$objectIsCastableTo(Object obj, String className, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = obj != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("obj != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = className != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("className != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="classExists", lines={174L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$classExists(String className, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = className != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("className != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="quoteComment", lines={188L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$quoteComment(String str, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = str != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("str != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="quoteComment", lines={189L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$quoteComment(String str, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="deleteComments", lines={198L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$deleteComments(String code, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = code != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("code != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="deleteComments", lines={199L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$deleteComments(String code, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="deleteGeneratedCode", lines={218L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$deleteGeneratedCode(String code, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = code != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("code != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="deleteGeneratedCode", lines={220L, 221L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$deleteGeneratedCode(String code, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = code.length() == result.length() + JavaUtils.generatedCodeLength(code);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("code.length() == result.length() + generatedCodeLength(code)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="generatedCodeLength", lines={252L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$generatedCodeLength(String code, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = code != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("code != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="generatedCodeLength", lines={253L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$generatedCodeLength(String code, int result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result == code.length() - JavaUtils.deleteGeneratedCode(code).length();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result == code.length() - deleteGeneratedCode(code).length()", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="renameLocalVariables", lines={282L, 283L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$renameLocalVariables(String code, Map<String, String> map, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = code != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("code != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = map != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("map != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="renameLocalVariables", lines={285L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$renameLocalVariables(String code, Map<String, String> map, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="lookingAt", lines={313L, 314L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$lookingAt(PushbackTokenizer tokenizer, String text, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = tokenizer != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("tokenizer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = text != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("text != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="skipPast", lines={341L, 342L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$skipPast(JavaTokenizer tokenizer, String text, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = tokenizer != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("tokenizer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = text != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("text != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="parseQualifiedName", lines={359L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$parseQualifiedName(JavaTokenizer tokenizer, boolean acceptStar, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = tokenizer != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("tokenizer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="parseQualifiedName", lines={361L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$JavaUtils$parseQualifiedName(JavaTokenizer tokenizer, boolean acceptStar, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !acceptStar ? ClassName.isQualifiedName(result) : ClassName.isQualifiedName(result) || ClassName.isQualifiedName(result.substring(0, result.length() - 2));
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!acceptStar ? ClassName.isQualifiedName(result): ClassName.isQualifiedName(result)|| ClassName.isQualifiedName(result.substring(0, result.length() - 2))", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLoaderForPath", lines={424L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$getLoaderForPath(String path, ClassLoader parent, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = path != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("path != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLoaderForPath", lines={443L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$getLoaderForPath(String path, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = path != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("path != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getClassInputStream", lines={462L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$getClassInputStream(ClassLoader loader, String className, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = ClassName.isBinaryName(className);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("ClassName.isBinaryName(className)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getContractClassInputStream", lines={502L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$getContractClassInputStream(ClassLoader loader, String className, boolean loadHelper, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = ClassName.isBinaryName(className);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("ClassName.isBinaryName(className)", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="resourceExists", lines={548L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$JavaUtils$resourceExists(ClassLoader loader, String className, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = className != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("className != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    public static class ParseException
    extends Exception {
        public ParseException(String msg) {
            super(msg);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        public ParseException(Throwable cause) {
            super(cause);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }

        public ParseException(String msg, Throwable cause) {
            super(msg, cause);
            ContractContext contractContext = ContractRuntime.getContext();
            boolean bl = contractContext.tryEnter(this);
            try {
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (contractContext.tryEnterContract()) {
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                    Exception exception = (Exception)throwable2;
                    throwable2 = exception;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                throw throwable2;
            }
        }
    }
}

