/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.util;

import com.google.java.contract.util.Predicate;

public final class Iterables {
    private Iterables() {
    }

    public static <T> boolean all(Iterable<T> it, Predicate<? super T> p) {
        if (it == null) {
            return false;
        }
        for (T elem : it) {
            if (p.apply(elem)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean any(Iterable<T> it, Predicate<? super T> p) {
        if (it == null) {
            return false;
        }
        for (T elem : it) {
            if (!p.apply(elem)) continue;
            return true;
        }
        return false;
    }
}

