/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.page;

import java.io.IOException;
import parquet.Preconditions;
import parquet.bytes.BytesInput;
import parquet.column.Encoding;

public class DictionaryPage {
    private final BytesInput bytes;
    private final int uncompressedSize;
    private final int dictionarySize;
    private final Encoding encoding;

    public DictionaryPage(BytesInput bytes, int dictionarySize, Encoding encoding) {
        this(bytes, (int)bytes.size(), dictionarySize, encoding);
    }

    public DictionaryPage(BytesInput bytes, int uncompressedSize, int dictionarySize, Encoding encoding) {
        this.bytes = (BytesInput)Preconditions.checkNotNull((Object)bytes, (String)"bytes");
        this.uncompressedSize = uncompressedSize;
        this.dictionarySize = dictionarySize;
        this.encoding = (Encoding)((Object)Preconditions.checkNotNull((Object)((Object)encoding), (String)"encoding"));
    }

    public BytesInput getBytes() {
        return this.bytes;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public DictionaryPage copy() throws IOException {
        return new DictionaryPage(BytesInput.copy((BytesInput)this.bytes), this.uncompressedSize, this.dictionarySize, this.encoding);
    }

    public String toString() {
        return "Page [bytes.size=" + this.bytes.size() + ", entryCount=" + this.dictionarySize + ", uncompressedSize=" + this.uncompressedSize + ", encoding=" + (Object)((Object)this.encoding) + "]";
    }
}

