/*
 * Decompiled with CFR 0.152.
 */
package parquet.io;

import java.util.ArrayList;
import java.util.List;
import parquet.io.GroupColumnIO;
import parquet.io.MessageColumnIO;
import parquet.io.ParquetDecodingException;
import parquet.io.PrimitiveColumnIO;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.TypeVisitor;

public class ColumnIOFactory {
    private final boolean validating;

    public ColumnIOFactory() {
        this(false);
    }

    public ColumnIOFactory(boolean validating) {
        this.validating = validating;
    }

    public MessageColumnIO getColumnIO(MessageType requestedSchema, MessageType fileSchema) {
        return this.getColumnIO(requestedSchema, fileSchema, true);
    }

    public MessageColumnIO getColumnIO(MessageType requestedSchema, MessageType fileSchema, boolean strict) {
        ColumnIOCreatorVisitor visitor = new ColumnIOCreatorVisitor(this.validating, requestedSchema, strict);
        fileSchema.accept(visitor);
        return visitor.getColumnIO();
    }

    public MessageColumnIO getColumnIO(MessageType schema) {
        return this.getColumnIO(schema, schema);
    }

    public class ColumnIOCreatorVisitor
    implements TypeVisitor {
        private MessageColumnIO columnIO;
        private GroupColumnIO current;
        private List<PrimitiveColumnIO> leaves = new ArrayList<PrimitiveColumnIO>();
        private final boolean validating;
        private final MessageType requestedSchema;
        private int currentRequestedIndex;
        private Type currentRequestedType;
        private boolean strictTypeChecking;

        public ColumnIOCreatorVisitor(boolean validating, MessageType requestedSchema) {
            this(validating, requestedSchema, true);
        }

        public ColumnIOCreatorVisitor(boolean validating, MessageType requestedSchema, boolean strictTypeChecking) {
            this.validating = validating;
            this.requestedSchema = requestedSchema;
            this.strictTypeChecking = strictTypeChecking;
        }

        @Override
        public void visit(MessageType messageType) {
            this.columnIO = new MessageColumnIO(this.requestedSchema, this.validating);
            this.visitChildren(this.columnIO, messageType, this.requestedSchema);
            this.columnIO.setLevels();
            this.columnIO.setLeaves(this.leaves);
        }

        @Override
        public void visit(GroupType groupType) {
            if (this.currentRequestedType.isPrimitive()) {
                this.incompatibleSchema(groupType, this.currentRequestedType);
            }
            GroupColumnIO newIO = new GroupColumnIO(groupType, this.current, this.currentRequestedIndex);
            this.current.add(newIO);
            this.visitChildren(newIO, groupType, this.currentRequestedType.asGroupType());
        }

        private void visitChildren(GroupColumnIO newIO, GroupType groupType, GroupType requestedGroupType) {
            GroupColumnIO oldIO = this.current;
            this.current = newIO;
            for (Type type : groupType.getFields()) {
                if (!requestedGroupType.containsField(type.getName())) continue;
                this.currentRequestedIndex = requestedGroupType.getFieldIndex(type.getName());
                this.currentRequestedType = requestedGroupType.getType(this.currentRequestedIndex);
                if (this.currentRequestedType.getRepetition().isMoreRestrictiveThan(type.getRepetition())) {
                    this.incompatibleSchema(type, this.currentRequestedType);
                }
                type.accept(this);
            }
            this.current = oldIO;
        }

        @Override
        public void visit(PrimitiveType primitiveType) {
            if (!this.currentRequestedType.isPrimitive() || this.strictTypeChecking && this.currentRequestedType.asPrimitiveType().getPrimitiveTypeName() != primitiveType.getPrimitiveTypeName()) {
                this.incompatibleSchema(primitiveType, this.currentRequestedType);
            }
            PrimitiveColumnIO newIO = new PrimitiveColumnIO(primitiveType, this.current, this.currentRequestedIndex, this.leaves.size());
            this.current.add(newIO);
            this.leaves.add(newIO);
        }

        private void incompatibleSchema(Type fileType, Type requestedType) {
            throw new ParquetDecodingException("The requested schema is not compatible with the file schema. incompatible types: " + requestedType + " != " + fileType);
        }

        public MessageColumnIO getColumnIO() {
            return this.columnIO;
        }
    }
}

