/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import org.testng.Assert;

public class SAMTestUtil {
    public void assertPairValid(SAMRecord firstEnd, SAMRecord secondEnd) {
        Assert.assertEquals((String)firstEnd.getReadName(), (String)secondEnd.getReadName());
        Assert.assertTrue((boolean)firstEnd.getFirstOfPairFlag());
        Assert.assertTrue((boolean)secondEnd.getSecondOfPairFlag());
        Assert.assertFalse((boolean)secondEnd.getFirstOfPairFlag());
        Assert.assertFalse((boolean)firstEnd.getSecondOfPairFlag());
        if (!firstEnd.getReadUnmappedFlag() && !secondEnd.getReadUnmappedFlag()) {
            Assert.assertNotSame((Object)firstEnd.getReadNegativeStrandFlag(), (Object)secondEnd.getReadNegativeStrandFlag());
        }
    }

    public void assertReadValid(SAMRecord read) {
        Assert.assertEquals((int)read.getReadBases().length, (int)read.getBaseQualities().length);
        if (read.getReferenceName().equals("*")) {
            Assert.assertEquals((int)read.getAlignmentStart(), (int)0);
            Assert.assertTrue((boolean)read.getReadUnmappedFlag());
        } else {
            Assert.assertNotSame((Object)read.getAlignmentStart(), (Object)0);
        }
        if (read.getReadUnmappedFlag()) {
            Assert.assertEquals((int)read.getMappingQuality(), (int)0);
            Assert.assertEquals((int)read.getCigar().getCigarElements().size(), (int)0);
        } else {
            Assert.assertNotSame(read.getCigar().getCigarElements(), (Object)0);
        }
        if (read.getReadPairedFlag()) {
            if (read.getMateReferenceName().equals("*")) {
                Assert.assertEquals((int)read.getMateAlignmentStart(), (int)0);
                Assert.assertTrue((boolean)read.getMateUnmappedFlag());
            } else {
                Assert.assertNotSame((Object)read.getMateAlignmentStart(), (Object)0);
            }
            if (read.getReadUnmappedFlag() || read.getMateUnmappedFlag() || !read.getReferenceName().equals(read.getMateReferenceName())) {
                Assert.assertEquals((int)read.getInferredInsertSize(), (int)0);
            } else {
                Assert.assertNotSame((Object)read.getInferredInsertSize(), (Object)0);
            }
            if (!read.getReadUnmappedFlag() && !read.getMateUnmappedFlag()) {
                Assert.assertNotSame((Object)read.getReadNegativeStrandFlag(), (Object)read.getMateNegativeStrandFlag(), (String)read.getReadName());
            }
        } else {
            Assert.assertEquals((int)read.getInferredInsertSize(), (int)0);
        }
    }
}

