/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BinaryCodec
implements Closeable {
    private OutputStream outputStream;
    private String outputFileName;
    private InputStream inputStream;
    private String inputFileName;
    private boolean isWriting;
    private ByteBuffer byteBuffer;
    private final byte[] scratchBuffer = new byte[16];
    private static final ByteOrder LITTLE_ENDIAN = ByteOrder.LITTLE_ENDIAN;
    private static final byte[] NULL_BYTE = new byte[]{0};
    private static final long MAX_UBYTE = 255L;
    private static final long MAX_USHORT = 65535L;
    private static final long MAX_UINT = 0xFFFFFFFFL;
    private static final int MAX_BYTE_BUFFER = 8;

    public BinaryCodec(File file, boolean writing) {
        this();
        try {
            this.isWriting = writing;
            if (this.isWriting) {
                this.outputStream = new FileOutputStream(file);
                this.outputFileName = file.getName();
            } else {
                this.inputStream = new FileInputStream(file);
                this.inputFileName = file.getName();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException("File not found: " + file, e);
        }
    }

    public BinaryCodec(String fileName, boolean writing) {
        this(new File(fileName), writing);
    }

    public BinaryCodec(OutputStream outputStream) {
        this();
        this.setOutputStream(outputStream);
    }

    public BinaryCodec(InputStream inputStream) {
        this();
        this.setInputStream(inputStream);
    }

    public BinaryCodec() {
        this.initByteBuffer();
    }

    private void initByteBuffer() {
        this.byteBuffer = ByteBuffer.allocate(8);
        this.byteBuffer.order(LITTLE_ENDIAN);
    }

    private void writeByteBuffer(int numBytes) {
        assert (numBytes <= this.byteBuffer.limit());
        this.writeBytes(this.byteBuffer.array(), 0, numBytes);
    }

    public void writeByte(byte bite) {
        this.byteBuffer.clear();
        this.byteBuffer.put(bite);
        this.writeByteBuffer(1);
    }

    public void writeByte(int b) {
        this.writeByte((byte)b);
    }

    public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBytes(byte[] bytes, int startOffset, int numBytes) {
        if (!this.isWriting) {
            throw new IllegalStateException("Calling write method on BinaryCodec open for read.");
        }
        try {
            this.outputStream.write(bytes, startOffset, numBytes);
        }
        catch (IOException e) {
            throw new RuntimeIOException(this.constructErrorMessage("Write error"), e);
        }
    }

    public void writeInt(int value) {
        this.byteBuffer.clear();
        this.byteBuffer.putInt(value);
        this.writeByteBuffer(4);
    }

    public void writeDouble(double value) {
        this.byteBuffer.clear();
        this.byteBuffer.putDouble(value);
        this.writeByteBuffer(8);
    }

    public void writeLong(long value) {
        this.byteBuffer.clear();
        this.byteBuffer.putLong(value);
        this.writeByteBuffer(8);
    }

    public void writeShort(short value) {
        this.byteBuffer.clear();
        this.byteBuffer.putShort(value);
        this.writeByteBuffer(2);
    }

    public void writeFloat(float value) {
        this.byteBuffer.clear();
        this.byteBuffer.putFloat(value);
        this.writeByteBuffer(4);
    }

    public void writeBoolean(boolean value) {
        this.byteBuffer.clear();
        this.byteBuffer.put(value ? (byte)1 : 0);
        this.writeByteBuffer(1);
    }

    public void writeString(String value, boolean writeLength, boolean appendNull) {
        if (writeLength) {
            int lengthToWrite = value.length();
            if (appendNull) {
                ++lengthToWrite;
            }
            this.writeInt(lengthToWrite);
        }
        this.writeString(value);
        if (appendNull) {
            this.writeBytes(NULL_BYTE);
        }
    }

    private void writeString(String value) {
        this.writeBytes(StringUtil.stringToBytes(value));
    }

    public void writeUByte(short val) {
        if (val < 0) {
            throw new IllegalArgumentException("Negative value (" + val + ") passed to unsigned writing method.");
        }
        if ((long)val > 255L) {
            throw new IllegalArgumentException("Value (" + val + ") to large to be written as ubyte.");
        }
        this.byteBuffer.clear();
        this.byteBuffer.putShort(val);
        this.writeByteBuffer(1);
    }

    public void writeUShort(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("Negative value (" + val + ") passed to unsigned writing method.");
        }
        if ((long)val > 65535L) {
            throw new IllegalArgumentException("Value (" + val + ") to large to be written as ushort.");
        }
        this.byteBuffer.clear();
        this.byteBuffer.putInt(val);
        this.writeByteBuffer(2);
    }

    public void writeUInt(long val) {
        if (val < 0L) {
            throw new IllegalArgumentException("Negative value (" + val + ") passed to unsigned writing method.");
        }
        if (val > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value (" + val + ") to large to be written as uint.");
        }
        this.byteBuffer.clear();
        this.byteBuffer.putLong(val);
        this.writeByteBuffer(4);
    }

    public void readBytes(byte[] buffer) {
        this.readBytes(buffer, 0, buffer.length);
    }

    public void readBytes(byte[] buffer, int offset, int length) {
        int numRead;
        int totalNumRead = 0;
        do {
            if ((numRead = this.readBytesOrFewer(buffer, offset + totalNumRead, length - totalNumRead)) >= 0) continue;
            String msg = String.format("Premature EOF. Expected %d but only received %d", length, totalNumRead);
            throw new RuntimeEOFException(this.constructErrorMessage(msg));
        } while ((totalNumRead += numRead) < length);
    }

    public int readBytesOrFewer(byte[] buffer, int offset, int length) {
        if (this.isWriting) {
            throw new IllegalStateException("Calling read method on BinaryCodec open for write.");
        }
        try {
            return this.inputStream.read(buffer, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeIOException(this.constructErrorMessage("Read error"), e);
        }
    }

    public byte readByte() {
        if (this.isWriting) {
            throw new IllegalStateException("Calling read method on BinaryCodec open for write.");
        }
        try {
            int ret = this.inputStream.read();
            if (ret == -1) {
                throw new RuntimeEOFException(this.constructErrorMessage("Premature EOF"));
            }
            return (byte)ret;
        }
        catch (IOException e) {
            throw new RuntimeIOException(this.constructErrorMessage("Read error"), e);
        }
    }

    public boolean knownAtEof() {
        if (this.isWriting) {
            throw new IllegalStateException("Calling knownAtEof method on BinaryCodec open for write.");
        }
        try {
            return this.inputStream instanceof ByteArrayInputStream && this.inputStream.available() == 0;
        }
        catch (IOException e) {
            throw new RuntimeIOException(this.constructErrorMessage("available() error"), e);
        }
    }

    public String readString(int length) {
        byte[] buffer = length <= this.scratchBuffer.length ? this.scratchBuffer : new byte[length];
        this.readBytes(buffer, 0, length);
        return StringUtil.bytesToString(buffer, 0, length);
    }

    public String readNullTerminatedString() {
        return StringUtil.readNullTerminatedString(this);
    }

    public String readLengthAndString(boolean devourNull) {
        int length = this.readInt();
        if (devourNull) {
            --length;
        }
        String ret = this.readString(length);
        if (devourNull) {
            this.readByte();
        }
        return ret;
    }

    private void readByteBuffer(int numBytes) {
        assert (numBytes <= this.byteBuffer.capacity());
        this.readBytes(this.byteBuffer.array(), 0, numBytes);
        this.byteBuffer.limit(this.byteBuffer.capacity());
        this.byteBuffer.position(numBytes);
    }

    public int readInt() {
        this.readByteBuffer(4);
        this.byteBuffer.flip();
        return this.byteBuffer.getInt();
    }

    public double readDouble() {
        this.readByteBuffer(8);
        this.byteBuffer.flip();
        return this.byteBuffer.getDouble();
    }

    public long readLong() {
        this.readByteBuffer(8);
        this.byteBuffer.flip();
        return this.byteBuffer.getLong();
    }

    public short readShort() {
        this.readByteBuffer(2);
        this.byteBuffer.flip();
        return this.byteBuffer.getShort();
    }

    public float readFloat() {
        this.readByteBuffer(4);
        this.byteBuffer.flip();
        return this.byteBuffer.getFloat();
    }

    public boolean readBoolean() {
        return this.readByte() == 1;
    }

    public short readUByte() {
        this.readByteBuffer(1);
        this.byteBuffer.put((byte)0);
        this.byteBuffer.flip();
        return this.byteBuffer.getShort();
    }

    public int readUShort() {
        this.readByteBuffer(2);
        this.byteBuffer.putShort((short)0);
        this.byteBuffer.flip();
        return this.byteBuffer.getInt();
    }

    public long readUInt() {
        this.readByteBuffer(4);
        this.byteBuffer.putInt(0);
        this.byteBuffer.flip();
        return this.byteBuffer.getLong();
    }

    @Override
    public void close() {
        block6: {
            try {
                if (this.isWriting) {
                    if (this.outputStream instanceof FileOutputStream) {
                        this.outputStream.flush();
                        FileOutputStream fos = (FileOutputStream)this.outputStream;
                        try {
                            fos.getFD().sync();
                        }
                        catch (SyncFailedException syncFailedException) {
                            // empty catch block
                        }
                    }
                    this.outputStream.close();
                    break block6;
                }
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e.getMessage(), e);
            }
        }
    }

    private String constructErrorMessage(String msg) {
        String filename;
        StringBuilder sb = new StringBuilder(msg);
        sb.append("; BinaryCodec in ");
        sb.append(this.isWriting ? "write" : "read");
        sb.append("mode; ");
        String string = filename = this.isWriting ? this.outputFileName : this.inputFileName;
        if (filename != null) {
            sb.append("file: ");
            sb.append(filename);
        } else {
            sb.append("streamed file (filename not available)");
        }
        return sb.toString();
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public boolean isWriting() {
        return this.isWriting;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream is) {
        this.isWriting = false;
        this.inputStream = is;
    }

    public void setOutputStream(OutputStream os) {
        this.isWriting = true;
        this.outputStream = os;
    }
}

