/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.readers;

import htsjdk.samtools.util.AbstractIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.Tuple;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.LineIterator;
import java.io.Closeable;
import java.io.IOException;

public class AsciiLineReaderIterator
implements LocationAware,
LineIterator,
Closeable {
    private final AsciiLineReader asciiLineReader;
    private final TupleIterator i;
    private Tuple<String, Long> current = null;

    public AsciiLineReaderIterator(AsciiLineReader asciiLineReader) {
        this.asciiLineReader = asciiLineReader;
        this.i = new TupleIterator();
    }

    @Override
    public void close() throws IOException {
        CloserUtil.close(this.asciiLineReader);
    }

    @Override
    public boolean hasNext() {
        return this.i.hasNext();
    }

    @Override
    public String next() {
        this.current = (Tuple)this.i.next();
        return (String)this.current.a;
    }

    @Override
    public void remove() {
        this.i.remove();
    }

    @Override
    public long getPosition() {
        return this.i.getPosition();
    }

    @Override
    public String peek() {
        return (String)((Tuple)this.i.peek()).a;
    }

    private class TupleIterator
    extends AbstractIterator<Tuple<String, Long>>
    implements LocationAware {
        public TupleIterator() {
            this.hasNext();
        }

        @Override
        protected Tuple<String, Long> advance() {
            String line;
            long position = AsciiLineReaderIterator.this.asciiLineReader.getPosition();
            try {
                line = AsciiLineReaderIterator.this.asciiLineReader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return line == null ? null : new Tuple<String, Long>(line, position);
        }

        @Override
        public long getPosition() {
            Tuple peek = (Tuple)this.peek();
            return peek != null ? ((Long)peek.b).longValue() : AsciiLineReaderIterator.this.asciiLineReader.getPosition();
        }
    }
}

