/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.LocationAware;
import htsjdk.tribble.index.DynamicIndexCreator;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.IndexFactory;
import htsjdk.tribble.index.TribbleIndexCreator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.PositionalOutputStream;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

abstract class IndexingVariantContextWriter
implements VariantContextWriter {
    private final String name;
    private final File location;
    private final SAMSequenceDictionary refDict;
    private OutputStream outputStream;
    private LocationAware locationSource = null;
    private IndexCreator indexer = null;
    private static final String SequenceDictionaryPropertyPredicate = "DICT:";

    private IndexingVariantContextWriter(String name, File location, OutputStream output, SAMSequenceDictionary refDict) {
        this.name = name;
        this.location = location;
        this.outputStream = output;
        this.refDict = refDict;
    }

    @Requires(value={"name != null", "! ( location == null && output == null )", "! ( enableOnTheFlyIndexing && location == null )"})
    protected IndexingVariantContextWriter(String name, File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing) {
        this(name, location, output, refDict);
        if (enableOnTheFlyIndexing) {
            this.initIndexingWriter(new DynamicIndexCreator(location, IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME));
        }
    }

    @Requires(value={"name != null", "! ( location == null && output == null )", "! ( enableOnTheFlyIndexing && location == null )", "idxCreator != null"})
    protected IndexingVariantContextWriter(String name, File location, OutputStream output, SAMSequenceDictionary refDict, boolean enableOnTheFlyIndexing, IndexCreator idxCreator) {
        this(name, location, output, refDict);
        if (enableOnTheFlyIndexing) {
            this.initIndexingWriter(idxCreator);
        }
    }

    @Requires(value={"idxCreator != null"})
    private void initIndexingWriter(IndexCreator idxCreator) {
        this.indexer = idxCreator;
        if (this.outputStream instanceof LocationAware) {
            this.locationSource = (LocationAware)((Object)this.outputStream);
        } else {
            PositionalOutputStream positionalOutputStream = new PositionalOutputStream(this.outputStream);
            this.locationSource = positionalOutputStream;
            this.outputStream = positionalOutputStream;
        }
    }

    @Ensures(value={"result != null"})
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Ensures(value={"result != null"})
    public String getStreamName() {
        return this.name;
    }

    @Override
    public abstract void writeHeader(VCFHeader var1);

    @Override
    public void close() {
        try {
            this.outputStream.close();
            if (this.indexer != null) {
                if (this.indexer instanceof TribbleIndexCreator) {
                    IndexingVariantContextWriter.setIndexSequenceDictionary((TribbleIndexCreator)this.indexer, this.refDict);
                }
                Index index = this.indexer.finalizeIndex(this.locationSource.getPosition());
                index.writeBasedOnFeatureFile(this.location);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close index for " + this.getStreamName(), e);
        }
    }

    public SAMSequenceDictionary getRefDict() {
        return this.refDict;
    }

    @Override
    public void add(VariantContext vc) {
        if (this.indexer != null) {
            this.indexer.addFeature(vc, this.locationSource.getPosition());
        }
    }

    protected static final String writerName(File location, OutputStream stream) {
        return location == null ? stream.toString() : location.getAbsolutePath();
    }

    private static void setIndexSequenceDictionary(TribbleIndexCreator indexCreator, SAMSequenceDictionary dict) {
        for (SAMSequenceRecord seq : dict.getSequences()) {
            String contig = SequenceDictionaryPropertyPredicate + seq.getSequenceName();
            String length = String.valueOf(seq.getSequenceLength());
            indexCreator.addProperty(contig, length);
        }
    }
}

