/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.AtomicUtils;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Pollers;
import com.netflix.servo.monitor.ResettableMonitor;
import java.util.concurrent.atomic.AtomicLongArray;

public class ResettableCounter
extends AbstractMonitor<Number>
implements Counter,
ResettableMonitor<Number> {
    private final long[] estPollingInterval;
    private final AtomicLongArray count;
    private final AtomicLongArray lastResetTime;

    ResettableCounter(MonitorConfig config, long[] pollingIntervals) {
        super(config.withAdditionalTag(DataSourceType.RATE));
        this.count = new AtomicLongArray(pollingIntervals.length);
        this.lastResetTime = new AtomicLongArray(pollingIntervals.length);
        this.estPollingInterval = new long[pollingIntervals.length];
        long now = System.currentTimeMillis();
        for (int i = 0; i < pollingIntervals.length; ++i) {
            this.estPollingInterval[i] = pollingIntervals[i];
            if (this.estPollingInterval[i] > 0L) {
                this.lastResetTime.set(i, -1L);
                continue;
            }
            this.lastResetTime.set(i, now);
        }
    }

    public ResettableCounter(MonitorConfig config) {
        this(config, Pollers.POLLING_INTERVALS);
    }

    @Deprecated
    public ResettableCounter(MonitorConfig config, long estPollingInterval) {
        this(config, Pollers.POLLING_INTERVALS);
    }

    @Override
    public void increment() {
        for (int i = 0; i < this.count.length(); ++i) {
            this.count.getAndIncrement(i);
        }
    }

    @Override
    public void increment(long amount) {
        for (int i = 0; i < this.count.length(); ++i) {
            this.count.getAndAdd(i, amount);
        }
    }

    @Override
    public Number getValue() {
        long now = System.currentTimeMillis();
        return this.computeRate(now, this.lastResetTime.get(0), this.count.get(0), this.estPollingInterval[0]);
    }

    @Override
    public Number getAndResetValue() {
        return this.getAndResetValue(0);
    }

    @Override
    public Number getAndResetValue(int pollerIdx) {
        long now = System.currentTimeMillis();
        long lastReset = this.lastResetTime.getAndSet(pollerIdx, now);
        long currentCount = this.count.getAndSet(pollerIdx, 0L);
        return this.computeRate(now, lastReset, currentCount, this.estPollingInterval[pollerIdx]);
    }

    public long getCount() {
        return this.count.get(0);
    }

    private double computeRate(long now, long lastReset, long currentCount, long pollingInterval) {
        double delta = (double)(lastReset >= 0L ? now - lastReset : pollingInterval) / 1000.0;
        return currentCount < 0L || delta <= 0.0 ? 0.0 : (double)currentCount / delta;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ResettableCounter)) {
            return false;
        }
        ResettableCounter m = (ResettableCounter)obj;
        return this.config.equals(m.getConfig()) && AtomicUtils.equals(this.count, m.count);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, AtomicUtils.hashCode(this.count)});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("config", (Object)this.config).add("count", (Object)this.count).add("resets", (Object)this.lastResetTime).toString();
    }
}

