/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.bdgenomics.adam.cli.ADAMSparkCommand;
import org.bdgenomics.adam.cli.Args4jBase;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.utils.instrumentation.DurationFormatting$;
import org.bdgenomics.utils.instrumentation.Metrics$;
import org.bdgenomics.utils.instrumentation.MetricsListener;
import org.bdgenomics.utils.instrumentation.RecordedMetrics;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class ADAMSparkCommand$class {
    public static void run(ADAMSparkCommand $this) {
        long start = System.nanoTime();
        SparkConf conf = new SparkConf().setAppName(new StringBuilder().append((Object)"adam: ").append((Object)$this.companion().commandName()).toString());
        Object object = conf.getOption("spark.master").isEmpty() ? conf.setMaster(new StringOps(Predef$.MODULE$.augmentString("local[%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Runtime.getRuntime().availableProcessors())}))) : BoxedUnit.UNIT;
        SparkContext sc = new SparkContext(conf);
        Job job = HadoopUtil$.MODULE$.newJob();
        Option<MetricsListener> metricsListener = $this.initializeMetrics(sc);
        $this.run(sc, job);
        long totalTime = System.nanoTime() - start;
        $this.printMetrics(totalTime, metricsListener);
    }

    public static Option initializeMetrics(ADAMSparkCommand $this, SparkContext sc) {
        None$ none$;
        if (((Args4jBase)$this.args()).printMetrics()) {
            MetricsListener metricsListener = new MetricsListener(new RecordedMetrics());
            sc.addSparkListener((SparkListener)metricsListener);
            Metrics$.MODULE$.initialize(sc);
            none$ = new Some((Object)metricsListener);
        } else {
            Metrics$.MODULE$.stopRecording();
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void printMetrics(ADAMSparkCommand $this, long totalTime, Option metricsListener) {
        $this.logInfo((Function0)new Serializable($this, totalTime){
            public static final long serialVersionUID = 0L;
            private final long totalTime$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Overall Duration: ").append((Object)DurationFormatting$.MODULE$.formatNanosecondDuration((Number)Predef$.MODULE$.long2Long(this.totalTime$1))).toString();
            }
            {
                this.totalTime$1 = totalTime$1;
            }
        });
        if (((Args4jBase)$this.args()).printMetrics() && metricsListener.isDefined()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter out = new PrintWriter(stringWriter);
            out.println("Metrics:");
            out.println();
            Metrics$.MODULE$.print(out, (Option)new Some((Object)((MetricsListener)metricsListener.get()).metrics().sparkMetrics().stageTimes()));
            out.println();
            ((MetricsListener)metricsListener.get()).metrics().sparkMetrics().print(out);
            out.flush();
            $this.logInfo((Function0)new Serializable($this, stringWriter){
                public static final long serialVersionUID = 0L;
                private final StringWriter stringWriter$1;

                public final String apply() {
                    return this.stringWriter$1.getBuffer().toString();
                }
                {
                    this.stringWriter$1 = stringWriter$1;
                }
            });
        }
    }

    public static void $init$(ADAMSparkCommand $this) {
    }
}

