/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.io.File;

public class Defaults {
    public static final boolean CREATE_INDEX = Defaults.getBooleanProperty("create_index", false);
    public static final boolean CREATE_MD5 = Defaults.getBooleanProperty("create_md5", false);
    public static final boolean USE_ASYNC_IO = Defaults.getBooleanProperty("use_async_io", false);
    public static final int COMPRESSION_LEVEL = Defaults.getIntProperty("compression_level", 5);
    public static final int BUFFER_SIZE = Defaults.getIntProperty("buffer_size", 131072);
    public static final int NON_ZERO_BUFFER_SIZE;
    public static final boolean TRY_USE_INTEL_DEFLATER;
    public static final String INTEL_DEFLATER_SHARED_LIBRARY_PATH;
    public static final File REFERENCE_FASTA;

    private static String getStringProperty(String name, String def) {
        return System.getProperty("samjdk." + name, def);
    }

    private static boolean getBooleanProperty(String name, boolean def) {
        String value = Defaults.getStringProperty(name, new Boolean(def).toString());
        return Boolean.parseBoolean(value);
    }

    private static int getIntProperty(String name, int def) {
        String value = Defaults.getStringProperty(name, new Integer(def).toString());
        return Integer.parseInt(value);
    }

    private static File getFileProperty(String name, String def) {
        String value = Defaults.getStringProperty(name, def);
        return null == value ? null : new File(value);
    }

    static {
        TRY_USE_INTEL_DEFLATER = Defaults.getBooleanProperty("try_use_intel_deflater", true);
        INTEL_DEFLATER_SHARED_LIBRARY_PATH = Defaults.getStringProperty("intel_deflater_so_path", null);
        NON_ZERO_BUFFER_SIZE = BUFFER_SIZE == 0 ? 131072 : BUFFER_SIZE;
        REFERENCE_FASTA = Defaults.getFileProperty("reference_fasta", null);
    }
}

