/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.bcf2.BCF2Utils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.BCF2Encoder;
import htsjdk.variant.variantcontext.writer.BCF2FieldEncoder;
import htsjdk.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BCF2FieldWriter {
    private final VCFHeader header;
    private final BCF2FieldEncoder fieldEncoder;

    @Requires(value={"header != null", "fieldEncoder != null"})
    protected BCF2FieldWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
        this.header = header;
        this.fieldEncoder = fieldEncoder;
    }

    @Ensures(value={"result != null"})
    protected VCFHeader getHeader() {
        return this.header;
    }

    @Ensures(value={"result != null"})
    protected BCF2FieldEncoder getFieldEncoder() {
        return this.fieldEncoder;
    }

    @Ensures(value={"result != null"})
    protected String getField() {
        return this.getFieldEncoder().getField();
    }

    @Requires(value={"vc != null"})
    public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
        this.fieldEncoder.writeFieldKey(encoder);
    }

    public void done(BCF2Encoder encoder, VariantContext vc) throws IOException {
    }

    public String toString() {
        return "BCF2FieldWriter " + this.getClass().getSimpleName() + " with encoder " + this.getFieldEncoder();
    }

    public static class GTWriter
    extends GenotypesWriter {
        final Map<Allele, Integer> alleleMapForTriPlus = new HashMap<Allele, Integer>(5);
        Allele ref;
        Allele alt1;

        public GTWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        @Override
        public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
            if (vc.getNAlleles() > 127) {
                throw new IllegalStateException("Current BCF2 encoder cannot handle sites with > 127 alleles, but you have " + vc.getNAlleles() + " at " + vc.getChr() + ":" + vc.getStart());
            }
            this.encodingType = BCF2Type.INT8;
            this.buildAlleleMap(vc);
            this.nValuesPerGenotype = vc.getMaxPloidy(2);
            super.start(encoder, vc);
        }

        @Override
        public void addGenotype(BCF2Encoder encoder, VariantContext vc, Genotype g) throws IOException {
            int samplePloidy = g.getPloidy();
            for (int i = 0; i < this.nValuesPerGenotype; ++i) {
                if (i < samplePloidy) {
                    Allele a = g.getAllele(i);
                    int offset = this.getAlleleOffset(a);
                    int encoded = offset + 1 << 1 | (g.isPhased() ? 1 : 0);
                    encoder.encodeRawBytes(encoded, this.encodingType);
                    continue;
                }
                encoder.encodeRawBytes(this.encodingType.getMissingBytes(), this.encodingType);
            }
        }

        @Requires(value={"a != null"})
        private final int getAlleleOffset(Allele a) {
            if (a == this.ref) {
                return 0;
            }
            if (a == this.alt1) {
                return 1;
            }
            if (a == Allele.NO_CALL) {
                return -1;
            }
            Integer o = this.alleleMapForTriPlus.get(a);
            if (o == null) {
                throw new IllegalStateException("BUG: Couldn't find allele offset for allele " + a);
            }
            return o;
        }

        private final void buildAlleleMap(VariantContext vc) {
            int nAlleles = vc.getNAlleles();
            this.ref = vc.getReference();
            Allele allele = this.alt1 = nAlleles > 1 ? vc.getAlternateAllele(0) : null;
            if (nAlleles > 2) {
                this.alleleMapForTriPlus.clear();
                List<Allele> alleles = vc.getAlleles();
                for (int i = 2; i < alleles.size(); ++i) {
                    this.alleleMapForTriPlus.put(alleles.get(i), i);
                }
            }
        }
    }

    public static class FTGenotypesWriter
    extends StaticallyTypeGenotypesWriter {
        public FTGenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        @Override
        public void addGenotype(BCF2Encoder encoder, VariantContext vc, Genotype g) throws IOException {
            String fieldValue = g.getFilters();
            this.getFieldEncoder().encodeValue(encoder, fieldValue, this.encodingType, this.nValuesPerGenotype);
        }

        @Override
        protected int numElements(VariantContext vc, Genotype g) {
            return this.getFieldEncoder().numElements(vc, g.getFilters());
        }
    }

    public static class IGFGenotypesWriter
    extends GenotypesWriter {
        final IntGenotypeFieldAccessors.Accessor ige;

        public IGFGenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder, IntGenotypeFieldAccessors.Accessor ige) {
            super(header, fieldEncoder);
            this.ige = ige;
            if (!(fieldEncoder instanceof BCF2FieldEncoder.IntArray)) {
                throw new IllegalArgumentException("BUG: IntGenotypesWriter requires IntArray encoder for field " + this.getField());
            }
        }

        @Override
        public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
            this.encodingType = BCF2Type.INT8;
            for (Genotype g : vc.getGenotypes()) {
                int[] pls = this.ige.getValues(g);
                BCF2Type plsType = this.getFieldEncoder().getType(pls);
                this.encodingType = BCF2Utils.maxIntegerType(this.encodingType, plsType);
                if (this.encodingType != BCF2Type.INT32) continue;
                break;
            }
            super.start(encoder, vc);
        }

        @Override
        public void addGenotype(BCF2Encoder encoder, VariantContext vc, Genotype g) throws IOException {
            this.getFieldEncoder().encodeValue(encoder, this.ige.getValues(g), this.encodingType, this.nValuesPerGenotype);
        }

        @Override
        protected int numElements(VariantContext vc, Genotype g) {
            return this.ige.getSize(g);
        }
    }

    public static class IntegerTypeGenotypesWriter
    extends GenotypesWriter {
        public IntegerTypeGenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        @Override
        public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
            ArrayList<Integer> values = new ArrayList<Integer>(vc.getNSamples());
            for (Genotype g : vc.getGenotypes()) {
                for (Object i : BCF2Utils.toList(g.getExtendedAttribute(this.getField(), null))) {
                    if (i == null) continue;
                    values.add((Integer)i);
                }
            }
            this.encodingType = BCF2Utils.determineIntegerType(values);
            super.start(encoder, vc);
        }
    }

    public static class StaticallyTypeGenotypesWriter
    extends GenotypesWriter {
        public StaticallyTypeGenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
            this.encodingType = this.getFieldEncoder().getStaticType();
        }
    }

    public static abstract class GenotypesWriter
    extends BCF2FieldWriter {
        int nValuesPerGenotype = -1;
        BCF2Type encodingType = null;

        protected GenotypesWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
            if (fieldEncoder.hasConstantNumElements()) {
                this.nValuesPerGenotype = this.getFieldEncoder().numElements();
            }
        }

        @Override
        @Requires(value={"encodingType != null", "nValuesPerGenotype >= 0 || ! getFieldEncoder().hasConstantNumElements()"})
        @Ensures(value={"nValuesPerGenotype >= 0"})
        public void start(BCF2Encoder encoder, VariantContext vc) throws IOException {
            super.start(encoder, vc);
            if (!this.getFieldEncoder().hasConstantNumElements()) {
                this.nValuesPerGenotype = this.getFieldEncoder().hasContextDeterminedNumElements() ? this.getFieldEncoder().numElements(vc) : this.computeMaxSizeOfGenotypeFieldFromValues(vc);
            }
            encoder.encodeType(this.nValuesPerGenotype, this.encodingType);
        }

        @Requires(value={"encodingType != null", "nValuesPerGenotype >= 0"})
        public void addGenotype(BCF2Encoder encoder, VariantContext vc, Genotype g) throws IOException {
            Object fieldValue = g.getExtendedAttribute(this.getField(), null);
            this.getFieldEncoder().encodeValue(encoder, fieldValue, this.encodingType, this.nValuesPerGenotype);
        }

        @Ensures(value={"result >= 0"})
        protected int numElements(VariantContext vc, Genotype g) {
            return this.getFieldEncoder().numElements(vc, g.getExtendedAttribute(this.getField()));
        }

        @Ensures(value={"result >= 0"})
        private final int computeMaxSizeOfGenotypeFieldFromValues(VariantContext vc) {
            int size = -1;
            for (Genotype g : vc.getGenotypes()) {
                size = Math.max(size, this.numElements(vc, g));
            }
            return size;
        }
    }

    public static class GenericSiteWriter
    extends SiteWriter {
        public GenericSiteWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        @Override
        public void site(BCF2Encoder encoder, VariantContext vc) throws IOException {
            Object rawValue = vc.getAttribute(this.getField(), null);
            BCF2Type type = this.getFieldEncoder().getType(rawValue);
            if (rawValue == null) {
                encoder.encodeType(0, type);
            } else {
                int valueCount = this.getFieldEncoder().numElements(vc, rawValue);
                encoder.encodeType(valueCount, type);
                this.getFieldEncoder().encodeValue(encoder, rawValue, type, valueCount);
            }
        }
    }

    public static abstract class SiteWriter
    extends BCF2FieldWriter {
        protected SiteWriter(VCFHeader header, BCF2FieldEncoder fieldEncoder) {
            super(header, fieldEncoder);
        }

        public abstract void site(BCF2Encoder var1, VariantContext var2) throws IOException;
    }
}

