/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import java.util.HashMap;
import java.util.Map;

public class VCFContigHeaderLine
extends VCFSimpleHeaderLine {
    final Integer contigIndex;

    public VCFContigHeaderLine(String line, VCFHeaderVersion version, String key, int contigIndex) {
        super(line, version, key, null);
        if (contigIndex < 0) {
            throw new TribbleException("The contig index is less than zero.");
        }
        this.contigIndex = contigIndex;
    }

    public VCFContigHeaderLine(Map<String, String> mapping, int contigIndex) {
        super("contig", mapping);
        if (contigIndex < 0) {
            throw new TribbleException("The contig index is less than zero.");
        }
        this.contigIndex = contigIndex;
    }

    VCFContigHeaderLine(final SAMSequenceRecord sequenceRecord, final String assembly) {
        super("contig", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("ID", sequenceRecord.getSequenceName());
                this.put("length", Integer.toString(sequenceRecord.getSequenceLength()));
                if (assembly != null) {
                    this.put("assembly", assembly);
                }
            }
        });
        this.contigIndex = sequenceRecord.getSequenceIndex();
    }

    public Integer getContigIndex() {
        return this.contigIndex;
    }

    public SAMSequenceRecord getSAMSequenceRecord() {
        String lengthString = this.getGenericFieldValue("length");
        if (lengthString == null) {
            throw new TribbleException("Contig " + this.getID() + " does not have a length field.");
        }
        SAMSequenceRecord record = new SAMSequenceRecord(this.getID(), Integer.valueOf(lengthString));
        record.setSequenceIndex(this.contigIndex);
        return record;
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof VCFContigHeaderLine) {
            return this.contigIndex.compareTo(((VCFContigHeaderLine)other).contigIndex);
        }
        return super.compareTo(other);
    }
}

