/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.DebugUtils;
import com.google.java.contract.core.util.PatternMap;

@Invariant(value={"assertPre != null", "assertPost != null", "assertInvariant != null"})
public class ActivationRuleManager {
    protected static ActivationRuleManager instance;
    protected PatternMap<Boolean> assertPre;
    protected PatternMap<Boolean> assertPost;
    protected PatternMap<Boolean> assertInvariant;

    protected ActivationRuleManager() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.assertPre = new PatternMap();
            this.assertPost = new PatternMap();
            this.assertInvariant = new PatternMap();
            this.assertPre = new PatternMap();
            this.assertPost = new PatternMap();
            this.assertInvariant = new PatternMap();
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == ActivationRuleManager.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == ActivationRuleManager.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$agent$ActivationRuleManager();
    }

    public static ActivationRuleManager getInstance() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ActivationRuleManager.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (instance == null) {
                instance = new ActivationRuleManager();
            }
            ActivationRuleManager activationRuleManager = instance;
            if (contractContext.tryEnterContract()) {
                ActivationRuleManager activationRuleManager2;
                activationRuleManager = activationRuleManager2 = activationRuleManager;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ActivationRuleManager.class);
            }
            return activationRuleManager;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ActivationRuleManager.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    @Ensures(value={"hasPreconditionsEnabled(pattern)"})
    public synchronized void enablePreconditions(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$enablePreconditions(string);
                contractContext.leaveContract();
            }
            DebugUtils.info("activation", (String)pattern + " +requires");
            this.assertPre.put((String)pattern, true);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$enablePreconditions((String)pattern);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="enablePreconditions")
    private synchronized /* synthetic */ void com$google$java$contract$P$enablePreconditions(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$enablePreconditions(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="enablePreconditions")
    private synchronized /* synthetic */ void com$google$java$contract$Q$enablePreconditions(String pattern) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$enablePreconditions(pattern);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    @Ensures(value={"!hasPreconditionsEnabled(pattern)"})
    public synchronized void disablePreconditions(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$disablePreconditions(string);
                contractContext.leaveContract();
            }
            DebugUtils.info("activation", (String)pattern + " -requires");
            this.assertPre.put((String)pattern, false);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$disablePreconditions((String)pattern);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="disablePreconditions")
    private synchronized /* synthetic */ void com$google$java$contract$P$disablePreconditions(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$disablePreconditions(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="disablePreconditions")
    private synchronized /* synthetic */ void com$google$java$contract$Q$disablePreconditions(String pattern) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$disablePreconditions(pattern);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    @Ensures(value={"hasPostconditionsEnabled(pattern)"})
    public synchronized void enablePostconditions(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$enablePostconditions(string);
                contractContext.leaveContract();
            }
            DebugUtils.info("activation", (String)pattern + " +ensures");
            this.assertPost.put((String)pattern, true);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$enablePostconditions((String)pattern);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="enablePostconditions")
    private synchronized /* synthetic */ void com$google$java$contract$P$enablePostconditions(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$enablePostconditions(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="enablePostconditions")
    private synchronized /* synthetic */ void com$google$java$contract$Q$enablePostconditions(String pattern) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$enablePostconditions(pattern);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    @Ensures(value={"!hasPostconditionsEnabled(pattern)"})
    public synchronized void disablePostconditions(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$disablePostconditions(string);
                contractContext.leaveContract();
            }
            DebugUtils.info("activation", (String)pattern + " -ensures");
            this.assertPost.put((String)pattern, false);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$disablePostconditions((String)pattern);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="disablePostconditions")
    private synchronized /* synthetic */ void com$google$java$contract$P$disablePostconditions(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$disablePostconditions(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="disablePostconditions")
    private synchronized /* synthetic */ void com$google$java$contract$Q$disablePostconditions(String pattern) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$disablePostconditions(pattern);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    @Ensures(value={"hasInvariantsEnabled(pattern)"})
    public synchronized void enableInvariants(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$enableInvariants(string);
                contractContext.leaveContract();
            }
            DebugUtils.info("activation", (String)pattern + " +invariant");
            this.assertInvariant.put((String)pattern, true);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$enableInvariants((String)pattern);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="enableInvariants")
    private synchronized /* synthetic */ void com$google$java$contract$P$enableInvariants(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$enableInvariants(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="enableInvariants")
    private synchronized /* synthetic */ void com$google$java$contract$Q$enableInvariants(String pattern) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$enableInvariants(pattern);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    @Ensures(value={"!hasInvariantsEnabled(pattern)"})
    public synchronized void disableInvariants(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$disableInvariants(string);
                contractContext.leaveContract();
            }
            DebugUtils.info("activation", (String)pattern + " -invariant");
            this.assertInvariant.put((String)pattern, false);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$disableInvariants((String)pattern);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="disableInvariants")
    private synchronized /* synthetic */ void com$google$java$contract$P$disableInvariants(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$disableInvariants(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="disableInvariants")
    private synchronized /* synthetic */ void com$google$java$contract$Q$disableInvariants(String pattern) {
        this.com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$disableInvariants(pattern);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    public synchronized boolean hasPreconditionsEnabled(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$hasPreconditionsEnabled(string);
                contractContext.leaveContract();
            }
            if (pattern.endsWith(".*") && this.assertPre.isOverriden((String)pattern)) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            Boolean rule = this.assertPre.get((String)pattern);
            boolean bl4 = rule == null || rule != false;
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="hasPreconditionsEnabled")
    private synchronized /* synthetic */ void com$google$java$contract$P$hasPreconditionsEnabled(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$hasPreconditionsEnabled(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    public synchronized boolean hasPostconditionsEnabled(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$hasPostconditionsEnabled(string);
                contractContext.leaveContract();
            }
            if (pattern.endsWith(".*") && this.assertPost.isOverriden((String)pattern)) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            Boolean rule = this.assertPost.get((String)pattern);
            boolean bl4 = rule == null || rule != false;
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="hasPostconditionsEnabled")
    private synchronized /* synthetic */ void com$google$java$contract$P$hasPostconditionsEnabled(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$hasPostconditionsEnabled(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"pattern != null"})
    public synchronized boolean hasInvariantsEnabled(String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void pattern;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$hasInvariantsEnabled(string);
                contractContext.leaveContract();
            }
            if (pattern.endsWith(".*") && this.assertInvariant.isOverriden((String)pattern)) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            Boolean rule = this.assertInvariant.get((String)pattern);
            boolean bl4 = rule == null || rule != false;
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="hasInvariantsEnabled")
    private synchronized /* synthetic */ void com$google$java$contract$P$hasInvariantsEnabled(String pattern) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$hasInvariantsEnabled(pattern, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ActivationRuleManager.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            instance = null;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ActivationRuleManager.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ActivationRuleManager.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={32L, 33L, 34L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$agent$ActivationRuleManager() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.assertPre != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("assertPre != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.assertPost != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("assertPost != null", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.assertInvariant != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("assertInvariant != null", com$google$java$contract$local$exception$5));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="enablePreconditions", lines={56L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$enablePreconditions(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="enablePreconditions", lines={57L})
    protected synchronized /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$enablePreconditions(String pattern) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.hasPreconditionsEnabled(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("hasPreconditionsEnabled(pattern)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="disablePreconditions", lines={63L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$disablePreconditions(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="disablePreconditions", lines={64L})
    protected synchronized /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$disablePreconditions(String pattern) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.hasPreconditionsEnabled(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!hasPreconditionsEnabled(pattern)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="enablePostconditions", lines={70L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$enablePostconditions(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="enablePostconditions", lines={71L})
    protected synchronized /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$enablePostconditions(String pattern) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.hasPostconditionsEnabled(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("hasPostconditionsEnabled(pattern)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="disablePostconditions", lines={77L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$disablePostconditions(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="disablePostconditions", lines={78L})
    protected synchronized /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$disablePostconditions(String pattern) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.hasPostconditionsEnabled(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!hasPostconditionsEnabled(pattern)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="enableInvariants", lines={84L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$enableInvariants(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="enableInvariants", lines={85L})
    protected synchronized /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$enableInvariants(String pattern) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.hasInvariantsEnabled(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("hasInvariantsEnabled(pattern)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="disableInvariants", lines={91L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$disableInvariants(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="disableInvariants", lines={92L})
    protected synchronized /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ActivationRuleManager$disableInvariants(String pattern) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.hasInvariantsEnabled(pattern);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!hasInvariantsEnabled(pattern)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="hasPreconditionsEnabled", lines={98L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$hasPreconditionsEnabled(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="hasPostconditionsEnabled", lines={107L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$hasPostconditionsEnabled(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="hasInvariantsEnabled", lines={116L})
    protected synchronized /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ActivationRuleManager$hasInvariantsEnabled(String pattern, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = pattern != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("pattern != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }
}

