/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Ensures;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;

class ContractMethodSignatures {
    static final String CONTRACT_METHOD_SIGNATURE_DESC;

    ContractMethodSignatures() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Requires(value={"contractMethod != null"})
    static String getTarget(MethodNode methodNode) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractMethodSignatures.class);
        try {
            MethodNode contractMethod;
            if (contractContext.tryEnterContract()) {
                ContractMethodSignatures.com$google$java$contract$P$getTarget(methodNode);
                contractContext.leaveContract();
            }
            String string = ContractMethodSignatures.getMetaData(contractMethod, "target", String.class);
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getTarget")
    private static /* synthetic */ void com$google$java$contract$P$getTarget(MethodNode contractMethod) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractMethodSignatures.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getTarget(contractMethod, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"contractMethod != null"})
    static ContractKind getKind(MethodNode methodNode) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractMethodSignatures.class);
        try {
            MethodNode contractMethod;
            String[] pair;
            if (contractContext.tryEnterContract()) {
                ContractMethodSignatures.com$google$java$contract$P$getKind(methodNode);
                contractContext.leaveContract();
            }
            if ((pair = ContractMethodSignatures.getMetaData(contractMethod, "kind", String[].class)) != null) {
                ContractKind contractKind = Enum.valueOf(ContractKind.class, pair[1]);
                if (contractContext.tryEnterContract()) {
                    ContractKind contractKind2;
                    contractKind = contractKind2 = contractKind;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractMethodSignatures.class);
                }
                return contractKind;
            }
            if (contractMethod.name.startsWith("access$")) {
                ContractKind contractKind = ContractKind.ACCESS;
                if (contractContext.tryEnterContract()) {
                    ContractKind contractKind3;
                    contractKind = contractKind3 = contractKind;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractMethodSignatures.class);
                }
                return contractKind;
            }
            ContractKind contractKind = null;
            if (contractContext.tryEnterContract()) {
                ContractKind contractKind4;
                contractKind = contractKind4 = contractKind;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            return contractKind;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getKind")
    private static /* synthetic */ void com$google$java$contract$P$getKind(MethodNode contractMethod) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractMethodSignatures.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getKind(contractMethod, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"contractMethod != null"})
    @Ensures(value={"result >= -1"})
    static int getId(MethodNode methodNode) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractMethodSignatures.class);
        try {
            MethodNode contractMethod;
            Integer id;
            if (contractContext.tryEnterContract()) {
                ContractMethodSignatures.com$google$java$contract$P$getId(methodNode);
                contractContext.leaveContract();
            }
            int n = (id = ContractMethodSignatures.getMetaData(contractMethod, "id", Integer.class)) == null || id < 0 ? -1 : id;
            if (contractContext.tryEnterContract()) {
                int n2;
                n = n2 = n;
                ContractMethodSignatures.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractMethodSignatures$getId(contractMethod, n2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            return n;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getId")
    private static /* synthetic */ void com$google$java$contract$P$getId(MethodNode contractMethod) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractMethodSignatures.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getId(contractMethod, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"contractMethod != null"})
    @Ensures(value={"result == null || isLineNumberList(result)"})
    static List<Long> getLineNumbers(MethodNode methodNode) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractMethodSignatures.class);
        try {
            MethodNode contractMethod;
            if (contractContext.tryEnterContract()) {
                ContractMethodSignatures.com$google$java$contract$P$getLineNumbers(methodNode);
                contractContext.leaveContract();
            }
            Object lines = ContractMethodSignatures.getMetaData(contractMethod, "lines", Object.class);
            List<Long> list = ContractMethodSignatures.getLineNumbers(lines);
            if (contractContext.tryEnterContract()) {
                List<Long> list2;
                list = list2 = list;
                ContractMethodSignatures.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractMethodSignatures$getLineNumbers(contractMethod, list2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getLineNumbers")
    private static /* synthetic */ void com$google$java$contract$P$getLineNumbers(MethodNode contractMethod) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractMethodSignatures.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getLineNumbers(contractMethod, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Ensures(value={"lines == null ? result == null : isLineNumberList(result)"})
    static List<Long> getLineNumbers(Object object) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractMethodSignatures.class);
        try {
            Object lines;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (lines == null) {
                List<Long> list = null;
                if (contractContext.tryEnterContract()) {
                    List<Long> list2;
                    list = list2 = list;
                    ContractMethodSignatures.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractMethodSignatures$getLineNumbers(lines, list2);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractMethodSignatures.class);
                }
                return list;
            }
            ArrayList<Long> lineNumbers = new ArrayList<Long>();
            if (lines.getClass().isArray()) {
                for (long line : (long[])lines) {
                    lineNumbers.add(line < 1L ? null : Long.valueOf(line));
                }
            } else {
                for (Long line : (List)lines) {
                    lineNumbers.add(line < 1L ? null : line);
                }
            }
            ArrayList<Long> arrayList = lineNumbers;
            if (contractContext.tryEnterContract()) {
                ArrayList<Long> arrayList2;
                arrayList = arrayList2 = arrayList;
                ContractMethodSignatures.com$google$java$contract$QH$com$google$java$contract$core$agent$ContractMethodSignatures$getLineNumbers(lines, arrayList2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            throw throwable2;
        }
    }

    static boolean isLineNumberList(List<Long> list) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractMethodSignatures.class);
        try {
            List<Long> list2;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (list2 == null) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractMethodSignatures.class);
                }
                return bl2;
            }
            for (Long line : list2) {
                if (line == null || line >= 1L) continue;
                boolean bl4 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl5;
                    bl4 = bl5 = bl4;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractMethodSignatures.class);
                }
                return bl4;
            }
            boolean bl6 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl7;
                bl6 = bl7 = bl6;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            return bl6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"contractMethod != null", "field != null", "clazz != null"})
    static <T> T getMetaData(MethodNode methodNode, String string, Class<T> clazz) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractMethodSignatures.class);
        try {
            MethodNode contractMethod;
            List annotations;
            if (contractContext.tryEnterContract()) {
                ContractMethodSignatures.com$google$java$contract$P$getMetaData(methodNode, string, clazz);
                contractContext.leaveContract();
            }
            if ((annotations = contractMethod.invisibleAnnotations) == null) {
                T t = null;
                if (contractContext.tryEnterContract()) {
                    T t2;
                    t = t2 = t;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractMethodSignatures.class);
                }
                return t;
            }
            for (AnnotationNode annotation : annotations) {
                if (!annotation.desc.equals(CONTRACT_METHOD_SIGNATURE_DESC)) continue;
                if (annotation.values == null) {
                    T t = null;
                    if (contractContext.tryEnterContract()) {
                        T t3;
                        t = t3 = t;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(ContractMethodSignatures.class);
                    }
                    return t;
                }
                Iterator it = annotation.values.iterator();
                while (it.hasNext()) {
                    void field;
                    String name = (String)it.next();
                    Object value = it.next();
                    if (!name.equals(field)) continue;
                    Object e = value;
                    if (contractContext.tryEnterContract()) {
                        Object e2;
                        e = e2 = e;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(ContractMethodSignatures.class);
                    }
                    return (T)e;
                }
            }
            T t = null;
            if (contractContext.tryEnterContract()) {
                T t4;
                t = t4 = t;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            return t;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getMetaData")
    private static /* synthetic */ <T> void com$google$java$contract$P$getMetaData(MethodNode contractMethod, String field, Class<T> clazz) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractMethodSignatures.com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getMetaData(contractMethod, field, clazz, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractMethodSignatures.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            CONTRACT_METHOD_SIGNATURE_DESC = Type.getObjectType("com/google/java/contract/core/agent/ContractMethodSignature").getDescriptor();
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractMethodSignatures.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getTarget", lines={42L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getTarget(MethodNode contractMethod, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = contractMethod != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contractMethod != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getKind", lines={47L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getKind(MethodNode contractMethod, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = contractMethod != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contractMethod != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getId", lines={59L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getId(MethodNode contractMethod, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = contractMethod != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contractMethod != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getId", lines={60L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractMethodSignatures$getId(MethodNode contractMethod, int result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result >= -1;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result >= -1", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLineNumbers", lines={66L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getLineNumbers(MethodNode contractMethod, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = contractMethod != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contractMethod != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLineNumbers", lines={67L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractMethodSignatures$getLineNumbers(MethodNode contractMethod, List<Long> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result == null || ContractMethodSignatures.isLineNumberList(result);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result == null || isLineNumberList(result)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getLineNumbers", lines={84L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$agent$ContractMethodSignatures$getLineNumbers(Object lines, List<Long> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = lines == null ? result == null : ContractMethodSignatures.isLineNumberList(result);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("lines == null ? result == null : isLineNumberList(result)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getMetaData", lines={133L, 134L, 135L})
    protected static /* synthetic */ <T> PreconditionError com$google$java$contract$PH$com$google$java$contract$core$agent$ContractMethodSignatures$getMetaData(MethodNode contractMethod, String field, Class<T> clazz, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = contractMethod != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contractMethod != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = field != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("field != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = clazz != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("clazz != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }
}

