/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.agent;

import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.core.agent.ClassContractHandle;
import com.google.java.contract.core.agent.ContractAnalyzer;
import com.google.java.contract.core.agent.ContractFixingClassAdapter;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.agent.LineNumberingClassAdapter;
import com.google.java.contract.core.agent.SpecificationMethodAdapter;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.DebugUtils;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

@Invariant(value={"getClassName() == null || ClassName.isBinaryName(getClassName())", "getContracts() != null", "getParent() != null"})
class SpecificationClassAdapter
extends ClassVisitor {
    protected String className;
    protected ContractAnalyzer contracts;

    public SpecificationClassAdapter(ClassVisitor cv, ContractAnalyzer contracts) {
        super(262144, cv);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.contracts = contracts;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == SpecificationClassAdapter.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == SpecificationClassAdapter.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$agent$SpecificationClassAdapter();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void interfaces;
            void superName;
            void signature;
            void name;
            void access;
            void version;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            super.visit((int)version, (int)access, (String)name, (String)signature, (String)superName, (String[])interfaces);
            this.className = name;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void exceptions;
            void signature;
            void desc;
            void name;
            void access;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            MethodVisitor mv = this.cv.visitMethod((int)access, (String)name, (String)desc, (String)signature, (String[])exceptions);
            if ((access & 0x500) != 0) {
                MethodVisitor methodVisitor = mv;
                if (contractContext.tryEnterContract()) {
                    MethodVisitor methodVisitor2;
                    methodVisitor = methodVisitor2 = methodVisitor;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return methodVisitor;
            }
            SpecificationMethodAdapter specificationMethodAdapter = new SpecificationMethodAdapter(this, mv, (int)access, (String)name, (String)desc);
            if (contractContext.tryEnterContract()) {
                SpecificationMethodAdapter specificationMethodAdapter2;
                specificationMethodAdapter = specificationMethodAdapter2 = specificationMethodAdapter;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return specificationMethodAdapter;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Override
    public void visitEnd() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (this.contracts != null) {
                List<ClassContractHandle> accesses = this.contracts.getClassHandles(ContractKind.ACCESS);
                for (ClassContractHandle h : accesses) {
                    h.getContractMethod().accept(this.cv);
                }
                List<ClassContractHandle> helpers = this.contracts.getClassHandles(ContractKind.HELPER);
                for (ClassContractHandle h : helpers) {
                    MethodNode methodNode = h.getContractMethod();
                    DebugUtils.info("instrument", "helper method " + this.className + "." + methodNode.name + methodNode.desc);
                    ClassVisitor visitor = this.cv;
                    List<Long> lineNumbers = h.getLineNumbers();
                    if (lineNumbers != null) {
                        visitor = new LineNumberingClassAdapter(visitor, lineNumbers);
                    }
                    methodNode.accept(new ContractFixingClassAdapter(visitor));
                    h.setInjected(true);
                }
            }
            super.visitEnd();
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    String getClassName() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            String string = this.className;
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    ClassVisitor getParent() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ClassVisitor classVisitor = this.cv;
            if (contractContext.tryEnterContract()) {
                ClassVisitor classVisitor2;
                classVisitor = classVisitor2 = classVisitor;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return classVisitor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    ContractAnalyzer getContracts() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            ContractAnalyzer contractAnalyzer = this.contracts;
            if (contractContext.tryEnterContract()) {
                ContractAnalyzer contractAnalyzer2;
                contractAnalyzer = contractAnalyzer2 = contractAnalyzer;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return contractAnalyzer;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={42L, 43L, 44L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$agent$SpecificationClassAdapter() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getClassName() == null || ClassName.isBinaryName(this.getClassName());
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("getClassName() == null || ClassName.isBinaryName(getClassName())", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getContracts() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("getContracts() != null", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = this.getParent() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("getParent() != null", com$google$java$contract$local$exception$5));
        }
    }
}

