/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.apt.ContractCreationTrait;
import com.google.java.contract.core.apt.ContractWriter;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractAnnotationModel;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ContractMethodModel;
import com.google.java.contract.core.model.ContractVariance;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementModifier;
import com.google.java.contract.core.model.MethodModel;
import com.google.java.contract.core.model.TypeModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.Elements;
import com.google.java.contract.core.util.JavaTokenizer;
import com.google.java.contract.core.util.JavaUtils;
import com.google.java.contract.core.util.PushbackTokenizer;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ContractCreation {
    static final String RAISE_METHOD = "com.google.java.contract.core.runtime.ContractRuntime.raise";

    public ContractCreation() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"code != null", "that != null"})
    @Ensures(value={"result != null"})
    static String rebaseLocalCalls(String string, String string2, Set<String> set) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            void that;
            void whitelist;
            String code;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$rebaseLocalCalls(string, string2, set);
                contractContext.leaveContract();
            }
            StringBuilder buffer = new StringBuilder();
            PushbackTokenizer tokenizer = new PushbackTokenizer(new StringReader(code));
            boolean qualified = false;
            while (tokenizer.hasNext()) {
                JavaTokenizer.Token token = tokenizer.next();
                if (!(qualified || token.kind != JavaTokenizer.TokenKind.WORD || whitelist != null && whitelist.contains(token.text))) {
                    if (token.text.equals("this")) {
                        buffer.append("( ");
                        buffer.append("/*[*/");
                        buffer.append((String)that);
                        buffer.append("/*]*/");
                        buffer.append(" )");
                    } else if (JavaUtils.lookingAt(tokenizer, "(")) {
                        buffer.append("/*[*/");
                        buffer.append((String)that);
                        buffer.append(".");
                        buffer.append("/*]*/");
                        buffer.append(token.text);
                    } else {
                        buffer.append(token.text);
                    }
                } else {
                    buffer.append(token.text);
                }
                qualified = token.text.equals(".");
            }
            String string3 = buffer.toString();
            if (contractContext.tryEnterContract()) {
                String string4;
                string3 = string4 = string3;
                ContractCreation.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$rebaseLocalCalls(code, (String)that, (Set<String>)whitelist, string4);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="rebaseLocalCalls")
    private static /* synthetic */ void com$google$java$contract$P$rebaseLocalCalls(String code, String that, Set<String> whitelist) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$rebaseLocalCalls(code, that, whitelist, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"contract != null", "trait != null", "annotation != null"})
    static void addContractClauses(ContractMethodModel contractMethodModel, ContractCreationTrait contractCreationTrait, ContractAnnotationModel contractAnnotationModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            void trait;
            void annotation;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$addContractClauses(contractMethodModel, contractCreationTrait, contractAnnotationModel);
                contractContext.leaveContract();
            }
            ContractKind kind = ContractCreation.getContractKind((ContractAnnotationModel)annotation);
            Iterator<String> itCode = trait.getExpressions().iterator();
            Iterator<String> itMsg = trait.getMessages().iterator();
            Iterator<String> itComment = trait.getSourceExpressions().iterator();
            int successVariableCount = 0;
            int exceptionVariableCount = 0;
            while (itCode.hasNext()) {
                ContractMethodModel contract2;
                StringBuilder buffer = new StringBuilder();
                String expr = itCode.next();
                String exprMsg = itMsg.next();
                String exprComment = itComment.next();
                String successVariableName = "com$google$java$contract$local$success$" + successVariableCount++;
                String exceptionTempVariableName = "com$google$java$contract$local$exception$" + exceptionVariableCount++;
                String exceptionVariableName = "com$google$java$contract$local$exception$" + exceptionVariableCount++;
                buffer.append("boolean ");
                buffer.append(successVariableName);
                buffer.append(" = false; ");
                buffer.append("Throwable ");
                buffer.append(exceptionVariableName);
                buffer.append(" = null; ");
                buffer.append("try { ");
                buffer.append(successVariableName);
                buffer.append(" = ");
                buffer.append("/*[");
                buffer.append(JavaUtils.quoteComment(exprComment));
                buffer.append("]*/");
                if (!annotation.isVirtual()) {
                    buffer.append(ContractCreation.rebaseLocalCalls(expr, "com$google$java$contract$local$that", null));
                } else {
                    buffer.append(expr);
                }
                buffer.append("; ");
                buffer.append("} catch(Throwable ");
                buffer.append(exceptionTempVariableName);
                buffer.append(") {");
                buffer.append(exceptionVariableName);
                buffer.append(" = ");
                buffer.append(exceptionTempVariableName);
                buffer.append("; } ");
                buffer.append("if (!(");
                buffer.append(successVariableName);
                buffer.append(")) { ");
                if (kind.getVariance() == ContractVariance.CONTRAVARIANT) {
                    buffer.append("return new ");
                    buffer.append(trait.getExceptionName());
                    buffer.append("(\"");
                    buffer.append(ContractWriter.quoteString(exprMsg));
                    buffer.append("\", ");
                    buffer.append("com$google$java$contract$local$error");
                    buffer.append(", ");
                    buffer.append(exceptionVariableName);
                    buffer.append("); ");
                } else {
                    buffer.append(RAISE_METHOD);
                    buffer.append("(new ");
                    buffer.append(trait.getExceptionName());
                    buffer.append("(\"");
                    buffer.append(ContractWriter.quoteString(exprMsg));
                    buffer.append("\", ");
                    buffer.append(exceptionVariableName);
                    buffer.append("));");
                }
                buffer.append("} ");
                contract2.addStatement(buffer.toString());
            }
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addContractClauses")
    private static /* synthetic */ void com$google$java$contract$P$addContractClauses(ContractMethodModel contract2, ContractCreationTrait trait, ContractAnnotationModel annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$addContractClauses(contract2, trait, annotation, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"helper != null", "annotation != null"})
    static String getHelperCallCode(MethodModel methodModel, ContractAnnotationModel contractAnnotationModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            MethodModel helper;
            void annotation;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$getHelperCallCode(methodModel, contractAnnotationModel);
                contractContext.leaveContract();
            }
            StringBuilder buffer = new StringBuilder();
            if (!annotation.isPrimary() && !annotation.isVirtual()) {
                buffer.append(annotation.getOwner().getQualifiedName() + "$com$google$java$contract$H");
                buffer.append(".");
            }
            buffer.append(helper.getSimpleName());
            buffer.append("(");
            List<? extends VariableModel> parameters = helper.getParameters();
            if (!parameters.isEmpty()) {
                Iterator<? extends VariableModel> it = parameters.iterator();
                while (true) {
                    String name;
                    if ((name = it.next().getSimpleName()).equals("com$google$java$contract$local$that")) {
                        buffer.append("this");
                    } else {
                        buffer.append(name);
                    }
                    if (!it.hasNext()) break;
                    buffer.append(", ");
                }
            }
            buffer.append(")");
            String string = buffer.toString();
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getHelperCallCode")
    private static /* synthetic */ void com$google$java$contract$P$getHelperCallCode(MethodModel helper, ContractAnnotationModel annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$getHelperCallCode(helper, annotation, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    static ContractKind getContractKind(ContractAnnotationModel contractAnnotationModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            ContractAnnotationModel annotation;
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            switch (annotation.getKind()) {
                case INVARIANT: {
                    ContractKind contractKind = ContractKind.INVARIANT;
                    if (contractContext.tryEnterContract()) {
                        ContractKind contractKind2;
                        contractKind = contractKind2 = contractKind;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(ContractCreation.class);
                    }
                    return contractKind;
                }
                case REQUIRES: {
                    ContractKind contractKind = ContractKind.PRE;
                    if (contractContext.tryEnterContract()) {
                        ContractKind contractKind3;
                        contractKind = contractKind3 = contractKind;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(ContractCreation.class);
                    }
                    return contractKind;
                }
                case ENSURES: {
                    ContractKind contractKind = ContractKind.POST;
                    if (contractContext.tryEnterContract()) {
                        ContractKind contractKind4;
                        contractKind = contractKind4 = contractKind;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(ContractCreation.class);
                    }
                    return contractKind;
                }
                case THROW_ENSURES: {
                    ContractKind contractKind = ContractKind.SIGNAL;
                    if (contractContext.tryEnterContract()) {
                        ContractKind contractKind5;
                        contractKind = contractKind5 = contractKind;
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(ContractCreation.class);
                    }
                    return contractKind;
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"trait != null", "annotation != null"})
    static ContractMethodModel createContractMethods(ContractCreationTrait contractCreationTrait, ContractMethodModel contractMethodModel, ContractAnnotationModel contractAnnotationModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            void contract2;
            void annotation;
            ContractCreationTrait trait;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$createContractMethods(contractCreationTrait, contractMethodModel, contractAnnotationModel);
                contractContext.leaveContract();
            }
            if (!trait.visit((ContractAnnotationModel)annotation)) {
                ContractMethodModel contractMethodModel2 = null;
                if (contractContext.tryEnterContract()) {
                    ContractMethodModel contractMethodModel3;
                    contractMethodModel2 = contractMethodModel3 = contractMethodModel2;
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractCreation.class);
                }
                return contractMethodModel2;
            }
            MethodModel helper = ContractCreation.createContractHelper(trait, (ContractAnnotationModel)annotation);
            ContractMethodModel contractMethodModel4 = ContractCreation.createContractMethod(trait, (ContractMethodModel)contract2, (ContractAnnotationModel)annotation, helper);
            if (contractContext.tryEnterContract()) {
                ContractMethodModel contractMethodModel5;
                contractMethodModel4 = contractMethodModel5 = contractMethodModel4;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return contractMethodModel4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createContractMethods")
    private static /* synthetic */ void com$google$java$contract$P$createContractMethods(ContractCreationTrait trait, ContractMethodModel contract2, ContractAnnotationModel annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createContractMethods(trait, contract2, annotation, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "annotation != null"})
    @Ensures(value={"result != null"})
    static ContractMethodModel createBlankContractMethod(ContractKind contractKind, ContractAnnotationModel contractAnnotationModel, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            void nameSuffix;
            ContractKind kind;
            void annotation;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$createBlankContractMethod(contractKind, contractAnnotationModel, string);
                contractContext.leaveContract();
            }
            TypeModel type = Elements.getTypeOf((ElementModel)annotation);
            MethodModel contracted = null;
            if (kind.isMethodContract()) {
                contracted = (MethodModel)annotation.getEnclosingElement();
            }
            String name = kind.getNameSpace() + ContractCreation.getContractName(kind, contracted);
            if (nameSuffix != null) {
                name = name + (String)nameSuffix;
            }
            ContractMethodModel contract2 = new ContractMethodModel(kind, name, new TypeName("void"), contracted);
            contract2.addModifier(ElementModifier.PRIVATE);
            type.addMember(contract2);
            ContractMethodModel contractMethodModel = contract2;
            if (contractContext.tryEnterContract()) {
                ContractMethodModel contractMethodModel2;
                contractMethodModel = contractMethodModel2 = contractMethodModel;
                ContractCreation.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$createBlankContractMethod(kind, (ContractAnnotationModel)annotation, (String)nameSuffix, contractMethodModel2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return contractMethodModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createBlankContractMethod")
    private static /* synthetic */ void com$google$java$contract$P$createBlankContractMethod(ContractKind kind, ContractAnnotationModel annotation, String nameSuffix) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createBlankContractMethod(kind, annotation, nameSuffix, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"trait != null", "annotation != null", "helper != null"})
    @Ensures(value={"result != null"})
    static ContractMethodModel createContractMethod(ContractCreationTrait contractCreationTrait, ContractMethodModel contractMethodModel, ContractAnnotationModel contractAnnotationModel, MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            void helper;
            ContractCreationTrait trait;
            ContractMethodModel contract2;
            void annotation;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$createContractMethod(contractCreationTrait, contractMethodModel, contractAnnotationModel, methodModel);
                contractContext.leaveContract();
            }
            ContractKind kind = ContractCreation.getContractKind((ContractAnnotationModel)annotation);
            if (contract2 == null) {
                contract2 = ContractCreation.createBlankContractMethod(kind, (ContractAnnotationModel)annotation, "");
                Elements.copyParameters(contract2, trait.getInitialParameters());
                if (kind.getVariance() == ContractVariance.CONTRAVARIANT) {
                    contract2.setPrologue(trait.getExceptionName() + " " + "com$google$java$contract$local$error" + " = null;");
                    contract2.setEpilogue("com.google.java.contract.core.runtime.ContractRuntime.raise(com$google$java$contract$local$error);");
                }
            }
            Elements.copyParameters(contract2, trait.getExtraParameters());
            if (annotation.isPrimary()) {
                contract2.setSourceInfo(annotation.getSourceInfo());
            }
            String code = ContractCreation.getHelperCallCode((MethodModel)helper, (ContractAnnotationModel)annotation) + ";";
            if (kind.getVariance() == ContractVariance.CONTRAVARIANT) {
                code = "com$google$java$contract$local$error = " + code + "if (" + "com$google$java$contract$local$error" + " == null) { return; }";
            }
            contract2.addStatement(code);
            ContractMethodModel contractMethodModel2 = contract2;
            if (contractContext.tryEnterContract()) {
                ContractMethodModel contractMethodModel3;
                contractMethodModel2 = contractMethodModel3 = contractMethodModel2;
                ContractCreation.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$createContractMethod(trait, contract2, (ContractAnnotationModel)annotation, (MethodModel)helper, contractMethodModel3);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return contractMethodModel2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createContractMethod")
    private static /* synthetic */ void com$google$java$contract$P$createContractMethod(ContractCreationTrait trait, ContractMethodModel contract2, ContractAnnotationModel annotation, MethodModel helper) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createContractMethod(trait, contract2, annotation, helper, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "annotation != null"})
    @Ensures(value={"result != null"})
    static MethodModel createBlankContractHelper(ContractKind contractKind, ContractAnnotationModel contractAnnotationModel, String string) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            void nameSuffix;
            ContractKind kind;
            void annotation;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$createBlankContractHelper(contractKind, contractAnnotationModel, string);
                contractContext.leaveContract();
            }
            TypeModel type = Elements.getTypeOf((ElementModel)annotation);
            MethodModel method = null;
            ContractMethodModel contract2 = null;
            MethodModel contracted = null;
            if (kind.isMethodContract()) {
                contracted = (MethodModel)annotation.getEnclosingElement();
            }
            TypeName returnType = new TypeName("void");
            String name = ContractCreation.getHelperName(kind, annotation.getOwner(), contracted);
            if (nameSuffix != null) {
                name = name + (String)nameSuffix;
            }
            if (annotation.isPrimary()) {
                contract2 = new ContractMethodModel(ContractKind.HELPER, name, returnType, contracted);
                contract2.setSourceInfo(annotation.getSourceInfo());
                if (!annotation.isVirtual()) {
                    for (TypeName typeName : type.getTypeParameters()) {
                        contract2.addTypeParameter(typeName);
                    }
                }
                method = contract2;
            } else {
                method = new MethodModel(ElementKind.CONTRACT_MOCK, name, returnType);
                if (contracted != null) {
                    Elements.copyParameters(method, contracted.getParameters());
                }
            }
            if (!annotation.isVirtual()) {
                method.addParameter(new VariableModel(ElementKind.PARAMETER, "com$google$java$contract$local$that", annotation.getOwner()));
            }
            if (!annotation.isVirtual()) {
                method.addModifier(ElementModifier.PUBLIC);
                method.addModifier(ElementModifier.STATIC);
            } else {
                method.addModifier(ElementModifier.PROTECTED);
            }
            if (annotation.isPrimary() || annotation.isVirtual() && !annotation.isWeakVirtual()) {
                type.addMember(method);
            }
            MethodModel methodModel = method;
            if (contractContext.tryEnterContract()) {
                MethodModel methodModel2;
                methodModel = methodModel2 = methodModel;
                ContractCreation.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$createBlankContractHelper(kind, (ContractAnnotationModel)annotation, (String)nameSuffix, methodModel2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return methodModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createBlankContractHelper")
    private static /* synthetic */ void com$google$java$contract$P$createBlankContractHelper(ContractKind kind, ContractAnnotationModel annotation, String nameSuffix) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createBlankContractHelper(kind, annotation, nameSuffix, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"trait != null", "annotation != null"})
    @Ensures(value={"result != null"})
    static MethodModel createContractHelper(ContractCreationTrait contractCreationTrait, ContractAnnotationModel contractAnnotationModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            ContractCreationTrait trait;
            void annotation;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$createContractHelper(contractCreationTrait, contractAnnotationModel);
                contractContext.leaveContract();
            }
            ContractKind kind = ContractCreation.getContractKind((ContractAnnotationModel)annotation);
            MethodModel method = ContractCreation.createBlankContractHelper(kind, (ContractAnnotationModel)annotation, null);
            TypeName returnType = new TypeName(kind.getVariance() == ContractVariance.CONTRAVARIANT ? trait.getExceptionName() : "void");
            method.setReturnType(returnType);
            if (kind.getVariance() == ContractVariance.CONTRAVARIANT) {
                method.addParameter(new VariableModel(ElementKind.PARAMETER, "com$google$java$contract$local$error", returnType));
            }
            if (annotation.isPrimary()) {
                method.setSourceInfo(annotation.getSourceInfo());
            }
            if (method.getKind() == ElementKind.CONTRACT_METHOD) {
                ContractMethodModel contract2 = (ContractMethodModel)method;
                Elements.copyParameters(contract2, trait.getInitialParameters());
                Elements.copyParameters(contract2, trait.getExtraParameters());
                ContractCreation.addContractClauses(contract2, trait, (ContractAnnotationModel)annotation);
                if (kind.getVariance() == ContractVariance.CONTRAVARIANT) {
                    contract2.setEpilogue("return null;");
                }
                if (annotation.isPrimary()) {
                    contract2.setLineNumbers(annotation.getLineNumbers());
                }
            } else {
                Elements.copyParameters(method, trait.getInitialMockParameters());
                Elements.copyParameters(method, trait.getExtraMockParameters());
            }
            MethodModel methodModel = method;
            if (contractContext.tryEnterContract()) {
                MethodModel methodModel2;
                methodModel = methodModel2 = methodModel;
                ContractCreation.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$createContractHelper(trait, (ContractAnnotationModel)annotation, methodModel2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return methodModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="createContractHelper")
    private static /* synthetic */ void com$google$java$contract$P$createContractHelper(ContractCreationTrait trait, ContractAnnotationModel annotation) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createContractHelper(trait, annotation, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "owner != null"})
    @Ensures(value={"ClassName.isSimpleName(result)"})
    static String getHelperName(ContractKind contractKind, ClassName className, MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            void contracted;
            void owner;
            ContractKind kind;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$getHelperName(contractKind, className, methodModel);
                contractContext.leaveContract();
            }
            String string = kind.getHelperNameSpace() + "$" + owner.getBinaryName().replace('/', '$') + ContractCreation.getContractName(kind, (MethodModel)contracted);
            if (contractContext.tryEnterContract()) {
                String string2;
                string = string2 = string;
                ContractCreation.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$getHelperName(kind, (ClassName)owner, (MethodModel)contracted, string2);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getHelperName")
    private static /* synthetic */ void com$google$java$contract$P$getHelperName(ContractKind kind, ClassName owner, MethodModel contracted) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$getHelperName(kind, owner, contracted, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"kind != null", "!kind.isClassContract() || contracted == null"})
    @Ensures(value={"result.isEmpty() || ClassName.isSimpleName(result) && result.startsWith(\"$\")"})
    static String getContractName(ContractKind contractKind, MethodModel methodModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(ContractCreation.class);
        try {
            ContractKind kind;
            void contracted;
            if (contractContext.tryEnterContract()) {
                ContractCreation.com$google$java$contract$P$getContractName(contractKind, methodModel);
                contractContext.leaveContract();
            }
            if (contracted == null) {
                String string = "";
                if (contractContext.tryEnterContract()) {
                    String string2;
                    string = string2 = string;
                    ContractCreation.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$getContractName(kind, (MethodModel)contracted, string2);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractCreation.class);
                }
                return string;
            }
            if (contracted.isConstructor()) {
                String string = "$" + contracted.getEnclosingElement().getSimpleName();
                if (contractContext.tryEnterContract()) {
                    String string3;
                    string = string3 = string;
                    ContractCreation.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$getContractName(kind, (MethodModel)contracted, string3);
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(ContractCreation.class);
                }
                return string;
            }
            String string = "$" + contracted.getSimpleName();
            if (contractContext.tryEnterContract()) {
                String string4;
                string = string4 = string;
                ContractCreation.com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$getContractName(kind, (MethodModel)contracted, string4);
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(ContractCreation.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getContractName")
    private static /* synthetic */ void com$google$java$contract$P$getContractName(ContractKind kind, MethodModel contracted) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = ContractCreation.com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$getContractName(kind, contracted, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="rebaseLocalCalls", lines={61L, 62L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$rebaseLocalCalls(String code, String that, Set<String> whitelist, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = code != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("code != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = that != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("that != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="rebaseLocalCalls", lines={64L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$rebaseLocalCalls(String code, String that, Set<String> whitelist, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addContractClauses", lines={107L, 108L, 109L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$addContractClauses(ContractMethodModel contract2, ContractCreationTrait trait, ContractAnnotationModel annotation, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = contract2 != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("contract != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = trait != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("trait != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getHelperCallCode", lines={199L, 200L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$getHelperCallCode(MethodModel helper, ContractAnnotationModel annotation, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = helper != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("helper != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createContractMethods", lines={255L, 256L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createContractMethods(ContractCreationTrait trait, ContractMethodModel contract2, ContractAnnotationModel annotation, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = trait != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("trait != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createBlankContractMethod", lines={280L, 281L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createBlankContractMethod(ContractKind kind, ContractAnnotationModel annotation, String nameSuffix, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createBlankContractMethod", lines={283L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$createBlankContractMethod(ContractKind kind, ContractAnnotationModel annotation, String nameSuffix, ContractMethodModel result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createContractMethod", lines={322L, 323L, 324L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createContractMethod(ContractCreationTrait trait, ContractMethodModel contract2, ContractAnnotationModel annotation, MethodModel helper, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = trait != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("trait != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = helper != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("helper != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createContractMethod", lines={326L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$createContractMethod(ContractCreationTrait trait, ContractMethodModel contract2, ContractAnnotationModel annotation, MethodModel helper, ContractMethodModel result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createBlankContractHelper", lines={371L, 372L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createBlankContractHelper(ContractKind kind, ContractAnnotationModel annotation, String nameSuffix, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createBlankContractHelper", lines={374L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$createBlankContractHelper(ContractKind kind, ContractAnnotationModel annotation, String nameSuffix, MethodModel result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createContractHelper", lines={444L, 445L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$createContractHelper(ContractCreationTrait trait, ContractAnnotationModel annotation, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = trait != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("trait != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = annotation != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("annotation != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="createContractHelper", lines={447L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$createContractHelper(ContractCreationTrait trait, ContractAnnotationModel annotation, MethodModel result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getHelperName", lines={495L, 496L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$getHelperName(ContractKind kind, ClassName owner, MethodModel contracted, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = owner != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("owner != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getHelperName", lines={498L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$getHelperName(ContractKind kind, ClassName owner, MethodModel contracted, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = ClassName.isSimpleName(result);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("ClassName.isSimpleName(result)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getContractName", lines={510L, 511L})
    protected static /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$ContractCreation$getContractName(ContractKind kind, MethodModel contracted, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !kind.isClassContract() || contracted == null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("!kind.isClassContract() || contracted == null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getContractName", lines={514L})
    protected static /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$ContractCreation$getContractName(ContractKind kind, MethodModel contracted, String result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result.isEmpty() || ClassName.isSimpleName(result) && result.startsWith("$");
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result.isEmpty() || ClassName.isSimpleName(result) && result.startsWith(\"$\")", com$google$java$contract$local$exception$1));
        }
    }
}

