/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.BalancedTokenizer;
import com.google.java.contract.core.util.JavaTokenizer;
import com.google.java.contract.core.util.JavaUtils;
import com.google.java.contract.util.Iterables;
import com.google.java.contract.util.Predicates;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

@Invariant(value={"!canQueryResults() || getImportNames() != null", "!canQueryResults() || !getImportNames().contains(null)", "!canQueryResults() || getContractLineNumbers() != null", "!canQueryResults() || !getContractLineNumbers().entrySet().contains(null)", "!canQueryResults() || Iterables.all(getContractLineNumbers().values(),     Predicates.<Long>all(Predicates.between(1L, null)))", "source != null"})
public class SourceDependencyParser {
    protected Reader source;
    protected Set<String> importNames;
    protected Map<ClassName, List<Long>> contractLineNumbers;
    protected boolean parsed;
    private static final List<String> TYPE_KEYWORDS;
    private static final List<String> CONTRACT_TYPES;

    public SourceDependencyParser(Reader source) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.source = source;
            this.importNames = new HashSet<String>();
            this.contractLineNumbers = new HashMap<ClassName, List<Long>>();
            this.parsed = false;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == SourceDependencyParser.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == SourceDependencyParser.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$apt$SourceDependencyParser();
    }

    @Ensures(value={"canQueryResults()"})
    public void parse() throws JavaUtils.ParseException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (this.parsed) {
                if (contractContext.tryEnterContract()) {
                    this.com$google$java$contract$Q$parse();
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return;
            }
            try {
                BalancedTokenizer tokenizer = new BalancedTokenizer(this.source);
                String packageName = null;
                ClassName className = null;
                ArrayList<Long> orphanLineNumbers = new ArrayList<Long>();
                block8: while (tokenizer.hasNext()) {
                    JavaTokenizer.Token token = tokenizer.next();
                    switch (token.kind) {
                        case WORD: {
                            String name;
                            if (tokenizer.getCurrentLevel() != 0) break;
                            if (token.text.equals("package")) {
                                packageName = JavaUtils.parseQualifiedName(tokenizer);
                                break;
                            }
                            if (token.text.equals("import")) {
                                name = JavaUtils.parseQualifiedName(tokenizer, true);
                                if (name.equals("static")) {
                                    name = name + " " + JavaUtils.parseQualifiedName(tokenizer, true);
                                }
                                this.importNames.add(name);
                                break;
                            }
                            if (!TYPE_KEYWORDS.contains(token.text)) break;
                            name = JavaUtils.parseQualifiedName(tokenizer);
                            if (packageName != null) {
                                name = packageName + "." + name;
                            }
                            className = new ClassName(name.replace('.', '/'));
                            this.contractLineNumbers.put(className, new ArrayList<Long>(orphanLineNumbers));
                            orphanLineNumbers.clear();
                            JavaUtils.skipPast(tokenizer, "{");
                            break;
                        }
                        case SYMBOL: {
                            if (tokenizer.getCurrentLevel() == 0 && token.text.equals("}")) {
                                className = null;
                                break;
                            }
                            if (!token.text.equals("@")) break;
                            String annotationType = JavaUtils.parseQualifiedName(tokenizer);
                            if (!annotationType.startsWith("com.google.java.contract.") && (!CONTRACT_TYPES.contains(annotationType) || (packageName == null || !packageName.equals("com.google.java.contract")) && !this.importNames.contains("com.google.java.contract." + annotationType) && !this.importNames.contains("com.google.java.contract.*"))) continue block8;
                            List<Long> lineNumbers = className != null ? this.contractLineNumbers.get(className) : orphanLineNumbers;
                            this.parseContractClauses(tokenizer, lineNumbers);
                            break;
                        }
                    }
                }
                this.parsed = true;
            }
            catch (NoSuchElementException e) {
                throw new JavaUtils.ParseException(e);
            }
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$parse();
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="parse")
    private /* synthetic */ void com$google$java$contract$Q$parse() {
        this.com$google$java$contract$QH$com$google$java$contract$core$apt$SourceDependencyParser$parse();
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"tokenizer != null", "lineNumbers != null"})
    private void parseContractClauses(BalancedTokenizer balancedTokenizer, List<Long> list) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void tokenizer;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$parseContractClauses(balancedTokenizer, list);
                contractContext.leaveContract();
            }
            boolean expectClause = true;
            while (tokenizer.hasNext()) {
                long lineNumber = tokenizer.getCurrentLineNumber();
                JavaTokenizer.Token token = tokenizer.next();
                if (token.text.equals(")")) {
                    if (contractContext.tryEnterContract()) {
                        if (bl) {
                            this.com$google$java$contract$I();
                        }
                        contractContext.leaveContract();
                    }
                    if (bl) {
                        contractContext.leave(this);
                    }
                    return;
                }
                if (expectClause && token.kind == JavaTokenizer.TokenKind.QUOTE) {
                    void lineNumbers;
                    lineNumbers.add(lineNumber);
                    expectClause = false;
                    continue;
                }
                if (!token.text.equals(",")) continue;
                expectClause = true;
            }
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="parseContractClauses")
    private /* synthetic */ void com$google$java$contract$P$parseContractClauses(BalancedTokenizer tokenizer, List<Long> lineNumbers) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$SourceDependencyParser$parseContractClauses(tokenizer, lineNumbers, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    public boolean canQueryResults() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.parsed;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Requires(value={"canQueryResults()"})
    public Set<String> getImportNames() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getImportNames();
                contractContext.leaveContract();
            }
            Set<String> set = Collections.unmodifiableSet(this.importNames);
            if (contractContext.tryEnterContract()) {
                Set<String> set2;
                set = set2 = set;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return set;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getImportNames")
    private /* synthetic */ void com$google$java$contract$P$getImportNames() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$SourceDependencyParser$getImportNames(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Requires(value={"canQueryResults()"})
    public Map<ClassName, List<Long>> getContractLineNumbers() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getContractLineNumbers();
                contractContext.leaveContract();
            }
            Map<ClassName, List<Long>> map = Collections.unmodifiableMap(this.contractLineNumbers);
            if (contractContext.tryEnterContract()) {
                Map<ClassName, List<Long>> map2;
                map = map2 = map;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return map;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getContractLineNumbers")
    private /* synthetic */ void com$google$java$contract$P$getContractLineNumbers() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$apt$SourceDependencyParser$getContractLineNumbers(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    static {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(SourceDependencyParser.class);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            TYPE_KEYWORDS = Arrays.asList("class", "enum", "interface");
            CONTRACT_TYPES = Arrays.asList("Requires", "Ensures", "ThrowEnsures", "Invariant");
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(SourceDependencyParser.class);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(SourceDependencyParser.class);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={51L, 52L, 53L, 54L, 55L, 58L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$apt$SourceDependencyParser() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.canQueryResults() || this.getImportNames() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("!canQueryResults() || getImportNames() != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !this.canQueryResults() || !this.getImportNames().contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("!canQueryResults() || !getImportNames().contains(null)", com$google$java$contract$local$exception$3));
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = !this.canQueryResults() || this.getContractLineNumbers() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            ContractRuntime.raise(new InvariantError("!canQueryResults() || getContractLineNumbers() != null", com$google$java$contract$local$exception$5));
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = !this.canQueryResults() || !this.getContractLineNumbers().entrySet().contains(null);
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            ContractRuntime.raise(new InvariantError("!canQueryResults() || !getContractLineNumbers().entrySet().contains(null)", com$google$java$contract$local$exception$7));
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = !this.canQueryResults() || Iterables.all(this.getContractLineNumbers().values(), Predicates.all(Predicates.between(1L, null)));
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            ContractRuntime.raise(new InvariantError("!canQueryResults() || Iterables.all(getContractLineNumbers().values(),     Predicates.<Long>all(Predicates.between(1L, null)))", com$google$java$contract$local$exception$9));
        }
        boolean com$google$java$contract$local$success$5 = false;
        Throwable com$google$java$contract$local$exception$11 = null;
        try {
            com$google$java$contract$local$success$5 = this.source != null;
        }
        catch (Throwable com$google$java$contract$local$exception$10) {
            com$google$java$contract$local$exception$11 = com$google$java$contract$local$exception$10;
        }
        if (!com$google$java$contract$local$success$5) {
            ContractRuntime.raise(new InvariantError("source != null", com$google$java$contract$local$exception$11));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="parse", lines={105L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$apt$SourceDependencyParser$parse() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.canQueryResults();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("canQueryResults()", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="parseContractClauses", lines={179L, 180L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$SourceDependencyParser$parseContractClauses(BalancedTokenizer tokenizer, List<Long> lineNumbers, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = tokenizer != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("tokenizer != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = lineNumbers != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("lineNumbers != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getImportNames", lines={203L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$SourceDependencyParser$getImportNames(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.canQueryResults();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("canQueryResults()", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getContractLineNumbers", lines={208L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$apt$SourceDependencyParser$getContractLineNumbers(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.canQueryResults();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("canQueryResults()", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }
}

