/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.apt;

import com.google.java.contract.core.apt.SourceDependencyParser;
import com.google.java.contract.core.model.ClassName;
import com.google.java.contract.core.util.JavaUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public class SourcePreprocessor {
    public static void main(String[] args) throws IOException, JavaUtils.ParseException {
        String depout = System.getProperty("com.google.java.contract.depsoutput");
        for (String arg : args) {
            File fileName;
            String dir;
            if (arg.startsWith("-")) continue;
            String baseName = arg;
            if (arg.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
                baseName = baseName.substring(0, baseName.length() - JavaFileObject.Kind.SOURCE.extension.length());
            }
            dir = (dir = (fileName = new File(baseName + JavaFileObject.Kind.SOURCE.extension)).getParent()) == null ? "" : dir + "/";
            FileInputStream in = new FileInputStream(arg);
            SourceDependencyParser parser = new SourceDependencyParser(new InputStreamReader(in));
            try {
                parser.parse();
            }
            catch (JavaUtils.ParseException e) {
                throw new JavaUtils.ParseException(fileName + " is malformed; " + "you should not compile contracts before compiling " + "the actual source files; " + "if this file is valid Java, you found a bug in Contracts for Java; " + "please email 'davidmorgan@google.com'", e);
            }
            Set<String> importNames = parser.getImportNames();
            Map<ClassName, List<Long>> contractLineNumbers = parser.getContractLineNumbers();
            if (contractLineNumbers.isEmpty()) continue;
            for (Map.Entry<ClassName, List<Long>> entry : contractLineNumbers.entrySet()) {
                ClassName className = entry.getKey();
                File outputFileName = depout == null ? new File(dir + className.getSimpleName() + ".java.d") : new File(depout + "/" + className.getBinaryName() + ".java.d");
                outputFileName.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(outputFileName);
                ObjectOutputStream oout = new ObjectOutputStream(out);
                oout.writeObject(importNames);
                oout.writeObject(entry.getValue());
                oout.close();
            }
            in.close();
        }
    }
}

