/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.model;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.model.ElementKind;
import com.google.java.contract.core.model.ElementModel;
import com.google.java.contract.core.model.ElementVisitor;
import com.google.java.contract.core.model.GenericElementModel;
import com.google.java.contract.core.model.TypeName;
import com.google.java.contract.core.model.VariableModel;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.Elements;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Invariant(value={"getExceptions() != null", "isConstructor() == (returnType == null)"})
public class MethodModel
extends GenericElementModel {
    protected Set<TypeName> exceptions;
    protected TypeName returnType;
    protected boolean variadic;

    @Requires(value={"kind != null", "kind.isMember() && kind != ElementKind.FIELD", "kind != ElementKind.CONSTRUCTOR", "name != null", "returnType != null"})
    public MethodModel(ElementKind kind, String name, TypeName returnType) {
        super(kind, name);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$MethodModel(kind, name, returnType);
                contractContext.leaveContract();
            }
            this.exceptions = new HashSet<TypeName>();
            this.returnType = returnType;
            this.variadic = false;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == MethodModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == MethodModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$MethodModel(ElementKind kind, String name, TypeName returnType) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$MethodModel(kind, name, returnType, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$model$MethodModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$GenericElementModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$QualifiedElementModel();
        this.com$google$java$contract$IH$com$google$java$contract$core$model$ElementModel();
    }

    @Requires(value={"that != null"})
    @Ensures(value={"getEnclosingElement() == null"})
    public MethodModel(MethodModel that) {
        super(that);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$MethodModel(that);
                contractContext.leaveContract();
            }
            this.exceptions = new HashSet<TypeName>(that.exceptions);
            this.returnType = that.returnType;
            this.variadic = false;
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$MethodModel(that);
                if (this.getClass() == MethodModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == MethodModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$MethodModel(MethodModel that) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$MethodModel(that, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="<init>")
    private /* synthetic */ void com$google$java$contract$Q$MethodModel(MethodModel that) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$MethodModel(that);
    }

    @Override
    public MethodModel clone() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            MethodModel methodModel = new MethodModel(this);
            if (contractContext.tryEnterContract()) {
                MethodModel methodModel2;
                methodModel = methodModel2 = methodModel;
                this.com$google$java$contract$Q$clone(methodModel2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return methodModel;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="clone")
    private /* synthetic */ void com$google$java$contract$Q$clone(MethodModel result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ElementModel$clone(result);
    }

    public MethodModel() {
        super(ElementKind.CONSTRUCTOR, "<init>");
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                contractContext.leaveContract();
            }
            this.exceptions = new HashSet<TypeName>();
            this.returnType = null;
            this.variadic = false;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == MethodModel.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == MethodModel.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public Set<? extends TypeName> getExceptions() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            Set<TypeName> set = Collections.unmodifiableSet(this.exceptions);
            if (contractContext.tryEnterContract()) {
                Set<TypeName> set2;
                set = set2 = set;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return set;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"exception != null"})
    @Ensures(value={"getExceptions().contains(exception)"})
    public void addException(TypeName typeName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void exception;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addException(typeName);
                contractContext.leaveContract();
            }
            this.exceptions.add((TypeName)exception);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addException((TypeName)exception);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addException")
    private /* synthetic */ void com$google$java$contract$P$addException(TypeName exception) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$addException(exception, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addException")
    private /* synthetic */ void com$google$java$contract$Q$addException(TypeName exception) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$addException(exception);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"exception != null"})
    @Ensures(value={"!getExceptions().contains(exception)"})
    public void removeException(TypeName typeName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void exception;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$removeException(typeName);
                contractContext.leaveContract();
            }
            this.exceptions.remove(exception);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$removeException((TypeName)exception);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="removeException")
    private /* synthetic */ void com$google$java$contract$P$removeException(TypeName exception) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$removeException(exception, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="removeException")
    private /* synthetic */ void com$google$java$contract$Q$removeException(TypeName exception) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$removeException(exception);
    }

    @Requires(value={"!isConstructor()"})
    @Ensures(value={"result != null"})
    public TypeName getReturnType() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$getReturnType();
                contractContext.leaveContract();
            }
            TypeName typeName = this.returnType;
            if (contractContext.tryEnterContract()) {
                TypeName typeName2;
                typeName = typeName2 = typeName;
                this.com$google$java$contract$Q$getReturnType(typeName2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return typeName;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="getReturnType")
    private /* synthetic */ void com$google$java$contract$P$getReturnType() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$getReturnType(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getReturnType")
    private /* synthetic */ void com$google$java$contract$Q$getReturnType(TypeName result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$getReturnType(result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"!isConstructor()", "type != null"})
    public void setReturnType(TypeName typeName) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void type;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$setReturnType(typeName);
                contractContext.leaveContract();
            }
            this.returnType = type;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="setReturnType")
    private /* synthetic */ void com$google$java$contract$P$setReturnType(TypeName type) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$setReturnType(type, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    public boolean isVariadic() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.variadic;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setVariadic(boolean bl) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl2 = contractContext.tryEnter(this);
        try {
            void variadic;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            this.variadic = variadic;
            if (contractContext.tryEnterContract()) {
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl2) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl2) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    public boolean isConstructor() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            boolean bl2 = this.kind == ElementKind.CONSTRUCTOR;
            if (contractContext.tryEnterContract()) {
                boolean bl3;
                bl2 = bl3 = bl2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @Ensures(value={"result != null"})
    public List<? extends VariableModel> getParameters() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            List<VariableModel> list = Elements.filter(this.getEnclosedElements(), VariableModel.class, ElementKind.PARAMETER);
            if (contractContext.tryEnterContract()) {
                List<VariableModel> list2;
                list = list2 = list;
                this.com$google$java$contract$Q$getParameters(list2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return list;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getParameters")
    private /* synthetic */ void com$google$java$contract$Q$getParameters(List<? extends VariableModel> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$getParameters(result);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"param != null", "param.getKind() == ElementKind.PARAMETER"})
    @Ensures(value={"getEnclosedElements().contains(param)", "getParameters().contains(param)"})
    public void addParameter(VariableModel variableModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void param;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$addParameter(variableModel);
                contractContext.leaveContract();
            }
            this.addEnclosedElement((ElementModel)param);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$addParameter((VariableModel)param);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="addParameter")
    private /* synthetic */ void com$google$java$contract$P$addParameter(VariableModel param) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$addParameter(param, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="addParameter")
    private /* synthetic */ void com$google$java$contract$Q$addParameter(VariableModel param) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$addParameter(param);
    }

    /*
     * WARNING - void declaration
     */
    @Requires(value={"param != null", "param.getKind() == ElementKind.PARAMETER"})
    @Ensures(value={"!getEnclosedElements().contains(param)", "!getParameters().contains(param)"})
    public void removeParameter(VariableModel variableModel) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void param;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$removeParameter(variableModel);
                contractContext.leaveContract();
            }
            this.removeEnclosedElement((ElementModel)param);
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$Q$removeParameter((VariableModel)param);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="removeParameter")
    private /* synthetic */ void com$google$java$contract$P$removeParameter(VariableModel param) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$removeParameter(param, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="removeParameter")
    private /* synthetic */ void com$google$java$contract$Q$removeParameter(VariableModel param) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$removeParameter(param);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(ElementVisitor elementVisitor) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void visitor;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$accept(elementVisitor);
                contractContext.leaveContract();
            }
            visitor.visitMethod(this);
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="accept")
    private /* synthetic */ void com$google$java$contract$P$accept(ElementVisitor visitor) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$model$ElementModel$accept(visitor, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @Override
    public EnumSet<ElementKind> getAllowedEnclosedKinds() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            EnumSet<ElementKind> allowed = EnumSet.of(ElementKind.PARAMETER, ElementKind.REQUIRES, ElementKind.ENSURES, ElementKind.THROW_ENSURES);
            allowed.addAll(super.getAllowedEnclosedKinds());
            EnumSet<ElementKind> enumSet = allowed;
            if (contractContext.tryEnterContract()) {
                EnumSet<ElementKind> enumSet2;
                enumSet = enumSet2 = enumSet;
                this.com$google$java$contract$Q$getAllowedEnclosedKinds(enumSet2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return enumSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getAllowedEnclosedKinds")
    private /* synthetic */ void com$google$java$contract$Q$getAllowedEnclosedKinds(EnumSet<ElementKind> result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$model$ElementModel$getAllowedEnclosedKinds(result);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            void obj;
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (obj == this) {
                boolean bl2 = true;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            if (!(obj instanceof MethodModel)) {
                boolean bl4 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl5;
                    bl4 = bl5 = bl4;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl4;
            }
            MethodModel method = (MethodModel)obj;
            if (!method.getSimpleName().equals(this.getSimpleName())) {
                boolean bl6 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl7;
                    bl6 = bl7 = bl6;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl6;
            }
            List<? extends VariableModel> params = this.getParameters();
            List<? extends VariableModel> others = method.getParameters();
            if (params.size() != others.size()) {
                boolean bl8 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl9;
                    bl8 = bl9 = bl8;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl8;
            }
            Iterator<? extends VariableModel> itParams = params.iterator();
            Iterator<? extends VariableModel> itOthers = others.iterator();
            while (itParams.hasNext()) {
                if (itParams.next().getType().equals(itOthers.next().getType())) continue;
                boolean bl10 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl11;
                    bl10 = bl11 = bl10;
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl10;
            }
            boolean bl12 = method.getEnclosingElement().equals(this.getEnclosingElement());
            if (contractContext.tryEnterContract()) {
                boolean bl13;
                bl12 = bl13 = bl12;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl12;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={39L, 40L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$model$MethodModel() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getExceptions() != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("getExceptions() != null", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.isConstructor() == (this.returnType == null);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new InvariantError("isConstructor() == (returnType == null)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={64L, 65L, 66L, 67L, 68L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$MethodModel(ElementKind kind, String name, TypeName returnType, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = kind != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("kind != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = kind.isMember() && kind != ElementKind.FIELD;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("kind.isMember() && kind != ElementKind.FIELD", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        boolean com$google$java$contract$local$success$2 = false;
        Throwable com$google$java$contract$local$exception$5 = null;
        try {
            com$google$java$contract$local$success$2 = kind != ElementKind.CONSTRUCTOR;
        }
        catch (Throwable com$google$java$contract$local$exception$4) {
            com$google$java$contract$local$exception$5 = com$google$java$contract$local$exception$4;
        }
        if (!com$google$java$contract$local$success$2) {
            return new PreconditionError("kind != ElementKind.CONSTRUCTOR", com$google$java$contract$local$error, com$google$java$contract$local$exception$5);
        }
        boolean com$google$java$contract$local$success$3 = false;
        Throwable com$google$java$contract$local$exception$7 = null;
        try {
            com$google$java$contract$local$success$3 = name != null;
        }
        catch (Throwable com$google$java$contract$local$exception$6) {
            com$google$java$contract$local$exception$7 = com$google$java$contract$local$exception$6;
        }
        if (!com$google$java$contract$local$success$3) {
            return new PreconditionError("name != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$7);
        }
        boolean com$google$java$contract$local$success$4 = false;
        Throwable com$google$java$contract$local$exception$9 = null;
        try {
            com$google$java$contract$local$success$4 = returnType != null;
        }
        catch (Throwable com$google$java$contract$local$exception$8) {
            com$google$java$contract$local$exception$9 = com$google$java$contract$local$exception$8;
        }
        if (!com$google$java$contract$local$success$4) {
            return new PreconditionError("returnType != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$9);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={81L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$MethodModel(MethodModel that, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = that != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("that != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={82L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$MethodModel(MethodModel that) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosingElement() == null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getEnclosingElement() == null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addException", lines={109L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$addException(TypeName exception, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = exception != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("exception != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addException", lines={110L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$addException(TypeName exception) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getExceptions().contains(exception);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getExceptions().contains(exception)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeException", lines={115L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$removeException(TypeName exception, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = exception != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("exception != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeException", lines={116L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$removeException(TypeName exception) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.getExceptions().contains(exception);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!getExceptions().contains(exception)", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getReturnType", lines={121L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$getReturnType(PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.isConstructor();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("!isConstructor()", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getReturnType", lines={122L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$getReturnType(TypeName result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="setReturnType", lines={128L, 129L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$setReturnType(TypeName type, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.isConstructor();
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("!isConstructor()", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = type != null;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("type != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getParameters", lines={147L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$getParameters(List<? extends VariableModel> result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result != null", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addParameter", lines={154L, 155L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$addParameter(VariableModel param, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = param != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("param != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = param.getKind() == ElementKind.PARAMETER;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("param.getKind() == ElementKind.PARAMETER", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="addParameter", lines={158L, 159L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$addParameter(VariableModel param) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.getEnclosedElements().contains(param);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("getEnclosedElements().contains(param)", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = this.getParameters().contains(param);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("getParameters().contains(param)", com$google$java$contract$local$exception$3));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeParameter", lines={166L, 167L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$model$MethodModel$removeParameter(VariableModel param, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = param != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("param != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = param.getKind() == ElementKind.PARAMETER;
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            return new PreconditionError("param.getKind() == ElementKind.PARAMETER", com$google$java$contract$local$error, com$google$java$contract$local$exception$3);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="removeParameter", lines={170L, 171L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$model$MethodModel$removeParameter(VariableModel param) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = !this.getEnclosedElements().contains(param);
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("!getEnclosedElements().contains(param)", com$google$java$contract$local$exception$1));
        }
        boolean com$google$java$contract$local$success$1 = false;
        Throwable com$google$java$contract$local$exception$3 = null;
        try {
            com$google$java$contract$local$success$1 = !this.getParameters().contains(param);
        }
        catch (Throwable com$google$java$contract$local$exception$2) {
            com$google$java$contract$local$exception$3 = com$google$java$contract$local$exception$2;
        }
        if (!com$google$java$contract$local$success$1) {
            ContractRuntime.raise(new PostconditionError("!getParameters().contains(param)", com$google$java$contract$local$exception$3));
        }
    }
}

