/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.InvariantError;
import com.google.java.contract.PostconditionError;
import com.google.java.contract.PreconditionError;
import com.google.java.contract.Requires;
import com.google.java.contract.core.agent.ContractMethodSignature;
import com.google.java.contract.core.model.ContractKind;
import com.google.java.contract.core.runtime.ContractContext;
import com.google.java.contract.core.runtime.ContractRuntime;
import com.google.java.contract.core.util.JavaTokenizer;
import java.io.IOException;
import java.io.Reader;

@Invariant(value={"currentLineNumber >= 1"})
public class LineNumberingTokenizer
extends JavaTokenizer {
    protected long currentLineNumber;

    @Requires(value={"reader != null"})
    public LineNumberingTokenizer(Reader reader) {
        super(reader);
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                this.com$google$java$contract$P$LineNumberingTokenizer(reader);
                contractContext.leaveContract();
            }
            this.currentLineNumber = 1L;
            if (contractContext.tryEnterContract()) {
                if (this.getClass() == LineNumberingTokenizer.class) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (this.getClass() == LineNumberingTokenizer.class) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="<init>")
    private /* synthetic */ void com$google$java$contract$P$LineNumberingTokenizer(Reader reader) {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$LineNumberingTokenizer$LineNumberingTokenizer(reader, com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.INVARIANT)
    private /* synthetic */ void com$google$java$contract$I() {
        this.com$google$java$contract$IH$com$google$java$contract$core$util$LineNumberingTokenizer();
        this.com$google$java$contract$IH$com$google$java$contract$core$util$JavaTokenizer();
    }

    @Override
    protected boolean lex() throws IOException {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                this.com$google$java$contract$P$lex();
                contractContext.leaveContract();
            }
            if (!super.lex()) {
                boolean bl2 = false;
                if (contractContext.tryEnterContract()) {
                    boolean bl3;
                    bl2 = bl3 = bl2;
                    this.com$google$java$contract$Q$lex(bl3);
                    if (bl) {
                        this.com$google$java$contract$I();
                    }
                    contractContext.leaveContract();
                }
                if (bl) {
                    contractContext.leave(this);
                }
                return bl2;
            }
            if (this.nextToken.kind == JavaTokenizer.TokenKind.SPACE || this.nextToken.kind == JavaTokenizer.TokenKind.COMMENT) {
                int lastIndex = -1;
                while ((lastIndex = this.nextToken.text.indexOf(10, lastIndex + 1)) != -1) {
                    ++this.currentLineNumber;
                }
            }
            boolean bl4 = true;
            if (contractContext.tryEnterContract()) {
                boolean bl5;
                bl4 = bl5 = bl4;
                this.com$google$java$contract$Q$lex(bl5);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.PRE, target="lex")
    private /* synthetic */ void com$google$java$contract$P$lex() {
        PreconditionError com$google$java$contract$local$error = null;
        if ((com$google$java$contract$local$error = this.com$google$java$contract$PH$com$google$java$contract$core$util$JavaTokenizer$lex(com$google$java$contract$local$error)) == null) {
            return;
        }
        ContractRuntime.raise(com$google$java$contract$local$error);
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="lex")
    private /* synthetic */ void com$google$java$contract$Q$lex(boolean result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$util$JavaTokenizer$lex(result);
    }

    @Ensures(value={"result >= 1"})
    public long getCurrentLineNumber() {
        ContractContext contractContext = ContractRuntime.getContext();
        boolean bl = contractContext.tryEnter(this);
        try {
            if (contractContext.tryEnterContract()) {
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            long l = this.currentLineNumber;
            if (contractContext.tryEnterContract()) {
                long l2;
                l = l2 = l;
                this.com$google$java$contract$Q$getCurrentLineNumber(l2);
                if (bl) {
                    this.com$google$java$contract$I();
                }
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            return l;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable instanceof Exception && contractContext.tryEnterContract()) {
                Exception exception = (Exception)throwable2;
                if (bl) {
                    this.com$google$java$contract$I();
                }
                throwable2 = exception;
                contractContext.leaveContract();
            }
            if (bl) {
                contractContext.leave(this);
            }
            throw throwable2;
        }
    }

    @ContractMethodSignature(kind=ContractKind.POST, target="getCurrentLineNumber")
    private /* synthetic */ void com$google$java$contract$Q$getCurrentLineNumber(long result) {
        this.com$google$java$contract$QH$com$google$java$contract$core$util$LineNumberingTokenizer$getCurrentLineNumber(result);
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, lines={32L})
    protected /* synthetic */ void com$google$java$contract$IH$com$google$java$contract$core$util$LineNumberingTokenizer() {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = this.currentLineNumber >= 1L;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new InvariantError("currentLineNumber >= 1", com$google$java$contract$local$exception$1));
        }
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="<init>", lines={43L})
    protected /* synthetic */ PreconditionError com$google$java$contract$PH$com$google$java$contract$core$util$LineNumberingTokenizer$LineNumberingTokenizer(Reader reader, PreconditionError com$google$java$contract$local$error) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = reader != null;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            return new PreconditionError("reader != null", com$google$java$contract$local$error, com$google$java$contract$local$exception$1);
        }
        return null;
    }

    @ContractMethodSignature(kind=ContractKind.HELPER, target="getCurrentLineNumber", lines={68L})
    protected /* synthetic */ void com$google$java$contract$QH$com$google$java$contract$core$util$LineNumberingTokenizer$getCurrentLineNumber(long result) {
        boolean com$google$java$contract$local$success$0 = false;
        Throwable com$google$java$contract$local$exception$1 = null;
        try {
            com$google$java$contract$local$success$0 = result >= 1L;
        }
        catch (Throwable com$google$java$contract$local$exception$0) {
            com$google$java$contract$local$exception$1 = com$google$java$contract$local$exception$0;
        }
        if (!com$google$java$contract$local$success$0) {
            ContractRuntime.raise(new PostconditionError("result >= 1", com$google$java$contract$local$exception$1));
        }
    }
}

