/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.util;

import com.google.java.contract.util.Iterables;
import com.google.java.contract.util.Objects;
import com.google.java.contract.util.Predicate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class Predicates {
    private static final Predicate<Object> TRUE = new Predicate<Object>(){

        @Override
        public boolean apply(Object obj) {
            return true;
        }
    };
    private static final Predicate<Object> FALSE = new Predicate<Object>(){

        @Override
        public boolean apply(Object obj) {
            return false;
        }
    };
    private static final Predicate<Object> IS_NULL = new Predicate<Object>(){

        @Override
        public boolean apply(Object obj) {
            return obj == null;
        }
    };
    private static final Predicate<Object> NON_NULL = new Predicate<Object>(){

        @Override
        public boolean apply(Object obj) {
            return obj != null;
        }
    };

    private Predicates() {
    }

    public static <S, T extends S> Predicate<T> narrow(Predicate<S> p) {
        return p;
    }

    public static <T> Predicate<T> constant(boolean b) {
        return b ? Predicates.narrow(TRUE) : Predicates.narrow(FALSE);
    }

    public static <T> Predicate<T> equalTo(final T obj) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T o) {
                return Objects.equal(o, obj);
            }
        };
    }

    public static <T> Predicate<T> isNull() {
        return Predicates.narrow(IS_NULL);
    }

    public static <T> Predicate<T> nonNull() {
        return Predicates.narrow(NON_NULL);
    }

    public static <T extends Comparable<T>> Predicate<T> between(final T low, final T high) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T obj) {
                return !(obj == null || low != null && obj.compareTo((Comparable)low) < 0 || high != null && obj.compareTo((Comparable)high) >= 0);
            }
        };
    }

    public static <T> Predicate<T> in(final Iterable<T> it) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T obj) {
                for (Object elem : it) {
                    if (!Objects.equal(elem, obj)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> in(final Collection<T> c) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T obj) {
                return c.contains(obj);
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<? super T> p) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T obj) {
                return !p.apply(obj);
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<? super T> ... ps) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T obj) {
                for (Predicate p : ps) {
                    if (p.apply(obj)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> ... ps) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T obj) {
                for (Predicate p : ps) {
                    if (!p.apply(obj)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<Iterable<T>> all(final Predicate<? super T> p) {
        return new Predicate<Iterable<T>>(){

            @Override
            public boolean apply(Iterable<T> obj) {
                return Iterables.all(obj, p);
            }
        };
    }

    public static <T> Predicate<Iterable<T>> any(final Predicate<? super T> p) {
        return new Predicate<Iterable<T>>(){

            @Override
            public boolean apply(Iterable<T> obj) {
                return Iterables.any(obj, p);
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> forEntries(final Predicate<? super Set<Map.Entry<K, V>>> p) {
        return new Predicate<Map<K, V>>(){

            @Override
            public boolean apply(Map<K, V> obj) {
                return p.apply(obj.entrySet());
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> forKeys(final Predicate<? super Set<K>> p) {
        return new Predicate<Map<K, V>>(){

            @Override
            public boolean apply(Map<K, V> obj) {
                return p.apply(obj.keySet());
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> forValues(final Predicate<? super Collection<V>> p) {
        return new Predicate<Map<K, V>>(){

            @Override
            public boolean apply(Map<K, V> obj) {
                return p.apply(obj.values());
            }
        };
    }

    public static <K, V> Predicate<Map<K, V>> anyEntry(Predicate<? super Map.Entry<K, V>> p) {
        return Predicates.forEntries(Predicates.any(p));
    }

    public static <K, V> Predicate<Map<K, V>> anyKey(Predicate<? super K> p) {
        return Predicates.forKeys(Predicates.any(p));
    }

    public static <K, V> Predicate<Map<K, V>> anyValue(Predicate<? super V> p) {
        return Predicates.forValues(Predicates.any(p));
    }

    public static <K, V> Predicate<Map<K, V>> allEntries(Predicate<? super Map.Entry<K, V>> p) {
        return Predicates.forEntries(Predicates.all(p));
    }

    public static <K, V> Predicate<Map<K, V>> allKeys(Predicate<? super K> p) {
        return Predicates.forKeys(Predicates.all(p));
    }

    public static <K, V> Predicate<Map<K, V>> allValues(Predicate<? super V> p) {
        return Predicates.forValues(Predicates.all(p));
    }
}

