/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.utils.parquet;

import java.io.File;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.Logging;
import org.bdgenomics.utils.parquet.ParquetLister$;
import org.bdgenomics.utils.parquet.ParquetPartition$;
import org.bdgenomics.utils.parquet.ParquetSchemaType;
import org.bdgenomics.utils.parquet.io.ByteAccess;
import org.bdgenomics.utils.parquet.io.FileLocator;
import org.bdgenomics.utils.parquet.io.LocalFileLocator;
import org.bdgenomics.utils.parquet.rdd.Footer;
import org.bdgenomics.utils.parquet.rdd.ParquetCommon$;
import org.bdgenomics.utils.parquet.rdd.ParquetRowGroup;
import org.slf4j.Logger;
import parquet.avro.AvroSchemaConverter;
import parquet.avro.UsableAvroRecordMaterializer;
import parquet.filter.UnboundRecordFilter;
import parquet.io.api.RecordMaterializer;
import parquet.schema.MessageType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001-\u0011Q\u0002U1scV,G\u000fT5ti\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0001\u0018M]9vKRT!!\u0002\u0004\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001!\u0006\u0002\raM\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!\u0012$D\u0001\u0016\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u0019\u0011\u00051\u0011\r]1dQ\u0016L!AG\u000b\u0003\u000f1{wmZ5oO\"AA\u0004\u0001B\u0001B\u0003%Q$A\bj]\u0012,\u00070\u00192mKN\u001b\u0007.Z7b!\rqa\u0004I\u0005\u0003?=\u0011aa\u00149uS>t\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u0018\u0003\u0011\tgO]8\n\u0005\u0015\u0012#AB*dQ\u0016l\u0017\r\u0003\u0005(\u0001\t\u0005\t\u0015a\u0003)\u0003!\u0019G.Y:t)\u0006<\u0007cA\u0015-]5\t!F\u0003\u0002,\u001f\u00059!/\u001a4mK\u000e$\u0018BA\u0017+\u0005!\u0019E.Y:t)\u0006<\u0007CA\u00181\u0019\u0001!Q!\r\u0001C\u0002I\u0012\u0011\u0001V\t\u0003gY\u0002\"A\u0004\u001b\n\u0005Uz!a\u0002(pi\"Lgn\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\t\nqaZ3oKJL7-\u0003\u0002<q\ti\u0011J\u001c3fq\u0016$'+Z2pe\u0012DQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtDCA D)\t\u0001%\tE\u0002B\u00019j\u0011A\u0001\u0005\u0006Oq\u0002\u001d\u0001\u000b\u0005\b9q\u0002\n\u00111\u0001\u001e\u0011\u001d)\u0005A1A\u0005\u0002\u0019\u000b!\"\u0019<s_N\u001b\u0007.Z7b+\u0005\u0001\u0003B\u0002%\u0001A\u0003%\u0001%A\u0006bmJ|7k\u00195f[\u0006\u0004\u0003b\u0002&\u0001\u0005\u0004%\taS\u0001\u0007M&dG/\u001a:\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!AS(\u000b\u0003\rI!!\u0015(\u0003'Us'm\\;oIJ+7m\u001c:e\r&dG/\u001a:\t\rM\u0003\u0001\u0015!\u0003M\u0003\u001d1\u0017\u000e\u001c;fe\u0002BQ!\u0016\u0001\u0005\nY\u000b\u0011cY8om\u0016\u0014H/\u0011<s_N\u001b\u0007.Z7b)\r9VL\u0018\t\u00031nk\u0011!\u0017\u0006\u00035>\u000baa]2iK6\f\u0017B\u0001/Z\u0005-iUm]:bO\u0016$\u0016\u0010]3\t\u000bi#\u0006\u0019A\u000f\t\u000b}#\u0006\u0019A,\u0002\u001f\u0019LG.Z'fgN\fw-\u001a+za\u0016DQ!\u0019\u0001\u0005\n\t\f1\"\\1uKJL\u0017\r\\5{KRA1m\\<\u007f\u0003\u001f\tI\u0002E\u0002eY:r!!\u001a6\u000f\u0005\u0019LW\"A4\u000b\u0005!T\u0011A\u0002\u001fs_>$h(C\u0001\u0011\u0013\tYw\"A\u0004qC\u000e\\\u0017mZ3\n\u00055t'\u0001C%uKJ\fGo\u001c:\u000b\u0005-|\u0001\"\u00029a\u0001\u0004\t\u0018\u0001\u0003:po\u001e\u0013x.\u001e9\u0011\u0005I,X\"A:\u000b\u0005Q\u0014\u0011a\u0001:eI&\u0011ao\u001d\u0002\u0010!\u0006\u0014\u0018/^3u%><xI]8va\")\u0001\u0010\u0019a\u0001s\u0006\u0011\u0011n\u001c\t\u0003url\u0011a\u001f\u0006\u0003q\nI!!`>\u0003\u0015\tKH/Z!dG\u0016\u001c8\u000f\u0003\u0004\u0000A\u0002\u0007\u0011\u0011A\u0001\r[\u0006$XM]5bY&TXM\u001d\t\u0006\u0003\u0007\tYAL\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005\u0019\u0011\r]5\u000b\u0005a|\u0015\u0002BA\u0007\u0003\u000b\u0011!CU3d_J$W*\u0019;fe&\fG.\u001b>fe\"9\u0011\u0011\u00031A\u0002\u0005M\u0011!\u0003:fcN\u001b\u0007.Z7b!\r\t\u0015QC\u0005\u0004\u0003/\u0011!!\u0005)beF,X\r^*dQ\u0016l\u0017\rV=qK\"9\u00111\u00041A\u0002\u0005M\u0011\u0001D1diV\fGnU2iK6\f\u0007BB1\u0001\t\u0003\ty\u0002F\u0002d\u0003CA\u0001\"a\t\u0002\u001e\u0001\u0007\u0011QE\u0001\tMVdG\u000eU1uQB!\u0011qEA\u0017\u001d\rq\u0011\u0011F\u0005\u0004\u0003Wy\u0011A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,=Aa!\u0019\u0001\u0005\u0002\u0005UB#B2\u00028\u0005\u0005\u0003\u0002CA\u001d\u0003g\u0001\r!a\u000f\u0002\u0017I|w\u000e\u001e'pG\u0006$xN\u001d\t\u0004u\u0006u\u0012bAA w\nYa)\u001b7f\u0019>\u001c\u0017\r^8s\u0011!\t\u0019%a\rA\u0002\u0005\u0015\u0012\u0001\u0004:fY\u0006$\u0018N^3QCRDw!CA$\u0005\u0005\u0005\t\u0012AA%\u00035\u0001\u0016M]9vKRd\u0015n\u001d;feB\u0019\u0011)a\u0013\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u001b\u001a2!a\u0013\u000e\u0011\u001di\u00141\nC\u0001\u0003#\"\"!!\u0013\t\u0015\u0005U\u00131JI\u0001\n\u0003\t9&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0005\u00033\ny'\u0006\u0002\u0002\\)\u001aQ$!\u0018,\u0005\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001b\u0010\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\n\u0019GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$a!MA*\u0005\u0004\u0011\u0004")
public class ParquetLister<T extends IndexedRecord>
implements Logging {
    private final Option<Schema> indexableSchema;
    private final ClassTag<T> classTag;
    private final Schema avroSchema;
    private final UnboundRecordFilter filter;
    private transient Logger org$apache$spark$Logging$$log_;

    public static <T extends IndexedRecord> Option<Schema> $lessinit$greater$default$1() {
        return ParquetLister$.MODULE$.$lessinit$greater$default$1();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Schema avroSchema() {
        return this.avroSchema;
    }

    public UnboundRecordFilter filter() {
        return this.filter;
    }

    private MessageType convertAvroSchema(Option<Schema> schema, MessageType fileMessageType) {
        Option<Schema> option;
        block4: {
            MessageType messageType;
            block3: {
                block2: {
                    option = schema;
                    None$ none$ = None$.MODULE$;
                    Option<Schema> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    messageType = fileMessageType;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Schema s = (Schema)some.x();
                messageType = new AvroSchemaConverter().convert(s);
            }
            return messageType;
        }
        throw new MatchError(option);
    }

    public Iterator<T> org$bdgenomics$utils$parquet$ParquetLister$$materialize(ParquetRowGroup rowGroup, ByteAccess io, RecordMaterializer<T> materializer, ParquetSchemaType reqSchema, ParquetSchemaType actualSchema) {
        return ParquetPartition$.MODULE$.materializeRecords(io, materializer, this.filter(), rowGroup, reqSchema, actualSchema);
    }

    public Iterator<T> materialize(String fullPath) {
        Iterator iterator;
        File file = new File(fullPath);
        LocalFileLocator rootLocator = new LocalFileLocator(file.getParentFile());
        String relativePath = file.getName();
        if (file.isFile()) {
            this.logInfo((Function0<String>)new Serializable(this, fullPath, relativePath){
                public static final long serialVersionUID = 0L;
                private final String fullPath$1;
                private final String relativePath$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Indexing file %s, relative path %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath$1, this.relativePath$1}));
                }
                {
                    void var3_3;
                    this.fullPath$1 = fullPath$1;
                    this.relativePath$1 = var3_3;
                }
            });
            iterator = this.materialize(rootLocator, relativePath);
        } else {
            File[] childFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])file.listFiles()).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean apply(File f) {
                    if (!f.isFile()) return false;
                    if (f.getName().startsWith(".")) return false;
                    String string = f.getName();
                    String string2 = "_SUCCESS";
                    if (string == null) {
                        if (string2 == null) return false;
                        return true;
                    } else if (string.equals(string2)) return false;
                    return true;
                }
            });
            iterator = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])childFiles).flatMap((Function1)new Serializable(this, rootLocator, relativePath){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ParquetLister $outer;
                private final LocalFileLocator rootLocator$1;
                private final String relativePath$1;

                public final TraversableOnce<T> apply(File x0$1) {
                    Iterator<T> iterator;
                    File file = x0$1;
                    String childRelativePath = new StringOps(Predef$.MODULE$.augmentString("%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.relativePath$1, file.getName()}));
                    try {
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final String childRelativePath$1;
                            private final File x1$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Indexing child file %s, relative path %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1.getName(), this.childRelativePath$1}));
                            }
                            {
                                this.childRelativePath$1 = childRelativePath$1;
                                this.x1$1 = x1$1;
                            }
                        });
                        iterator = this.$outer.materialize(this.rootLocator$1, childRelativePath);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final String childRelativePath$1;
                            private final File x1$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("File %s/%s doesn't appear to be a Parquet file; skipping")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1.getName(), this.childRelativePath$1}));
                            }
                            {
                                this.childRelativePath$1 = childRelativePath$1;
                                this.x1$1 = x1$1;
                            }
                        });
                        iterator = Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                    Iterator<T> iterator2 = iterator;
                    return iterator2;
                }
                {
                    void var3_3;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.rootLocator$1 = rootLocator$1;
                    this.relativePath$1 = var3_3;
                }
            }, Array$.MODULE$.canBuildFrom(this.classTag))).iterator();
        }
        return iterator;
    }

    public Iterator<T> materialize(FileLocator rootLocator, String relativePath) {
        FileLocator locator = rootLocator.relativeLocator(relativePath);
        ByteAccess io = locator.bytes();
        Footer footer = ParquetCommon$.MODULE$.readFooter(io);
        MessageType fileMessageType = ParquetCommon$.MODULE$.parseMessageType(ParquetCommon$.MODULE$.readFileMetadata(io));
        ParquetSchemaType actualSchema = new ParquetSchemaType(fileMessageType);
        MessageType requestedMessageType = this.convertAvroSchema(this.indexableSchema, fileMessageType);
        ParquetSchemaType reqSchema = new ParquetSchemaType(requestedMessageType);
        UsableAvroRecordMaterializer avroRecordMaterializer = new UsableAvroRecordMaterializer(requestedMessageType, this.avroSchema());
        this.logInfo((Function0<String>)new Serializable(this, footer){
            public static final long serialVersionUID = 0L;
            private final Footer footer$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("# row groups: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.footer$1.rowGroups().length())}));
            }
            {
                this.footer$1 = footer$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, footer){
            public static final long serialVersionUID = 0L;
            private final Footer footer$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("# total records: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.footer$1.rowGroups().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(ParquetRowGroup x$1) {
                        return x$1.rowCount();
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)}));
            }
            {
                this.footer$1 = footer$1;
            }
        });
        return ((IterableLike)((TraversableLike)footer.rowGroups().zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this, io, actualSchema, reqSchema, avroRecordMaterializer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetLister $outer;
            private final ByteAccess io$1;
            private final ParquetSchemaType actualSchema$1;
            private final ParquetSchemaType reqSchema$1;
            private final UsableAvroRecordMaterializer avroRecordMaterializer$1;

            public final Iterator<T> apply(Tuple2<ParquetRowGroup, Object> x0$2) {
                Tuple2<ParquetRowGroup, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    ParquetRowGroup rowGroup = (ParquetRowGroup)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    if (rowGroup != null) {
                        ParquetRowGroup parquetRowGroup = rowGroup;
                        int n = i;
                        this.$outer.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final ParquetRowGroup x2$1;
                            private final int x3$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("row group %d, # records %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x3$1), BoxesRunTime.boxToLong((long)this.x2$1.rowCount())}));
                            }
                            {
                                this.x2$1 = x2$1;
                                this.x3$1 = x3$1;
                            }
                        });
                        Iterator<T> iterator = this.$outer.org$bdgenomics$utils$parquet$ParquetLister$$materialize(parquetRowGroup, this.io$1, this.avroRecordMaterializer$1, this.reqSchema$1, this.actualSchema$1);
                        return iterator;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.io$1 = io$1;
                this.actualSchema$1 = var3_3;
                this.reqSchema$1 = var4_4;
                this.avroRecordMaterializer$1 = var5_5;
            }
        }, Seq$.MODULE$.canBuildFrom())).iterator();
    }

    public ParquetLister(Option<Schema> indexableSchema, ClassTag<T> classTag) {
        this.indexableSchema = indexableSchema;
        this.classTag = classTag;
        Logging.class.$init$((Logging)this);
        this.avroSchema = ((IndexedRecord)classTag.runtimeClass().newInstance()).getSchema();
        this.filter = null;
    }
}

