/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.utils.parquet.rdd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.bdgenomics.utils.parquet.io.ByteAccess;
import org.bdgenomics.utils.parquet.rdd.Footer;
import parquet.format.FileMetaData;
import parquet.format.converter.MyConverter;
import parquet.org.apache.thrift.protocol.TCompactProtocol;
import parquet.org.apache.thrift.protocol.TProtocol;
import parquet.org.apache.thrift.transport.TIOStreamTransport;
import parquet.org.apache.thrift.transport.TTransport;
import parquet.schema.MessageType;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class ParquetCommon$ {
    public static final ParquetCommon$ MODULE$;
    private final byte[] MAGIC;
    private final MyConverter converter;

    static {
        new ParquetCommon$();
    }

    public byte[] MAGIC() {
        return this.MAGIC;
    }

    public MyConverter converter() {
        return this.converter;
    }

    public MessageType parseMessageType(FileMetaData metadata) {
        return this.converter().convert(metadata);
    }

    public int readInt(byte[] buffer, int offset) {
        return ByteBuffer.wrap((byte[])Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(buffer).slice(offset, offset + 4)).reverse()).getInt();
    }

    public FileMetaData readFileMetadata(ByteAccess io) {
        byte[] magicAndLength = io.readFully(io.length() - (long)this.MAGIC().length - 4L, this.MAGIC().length + 4);
        Predef$.MODULE$.require(Predef$.MODULE$.byteArrayOps((byte[])Predef$.MODULE$.byteArrayOps(magicAndLength).slice(4, magicAndLength.length)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.MAGIC())), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "File does not appear to be a Parquet file";
            }
        });
        int footerLength = this.readInt(magicAndLength, 0);
        Predef$.MODULE$.assert(io.length() >= 0L);
        Predef$.MODULE$.assert(footerLength >= 0, (Function0)new Serializable(footerLength){
            public static final long serialVersionUID = 0L;
            private final int footerLength$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("footerLength %d should be non-negative")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.footerLength$1)}));
            }
            {
                this.footerLength$1 = footerLength$1;
            }
        });
        Predef$.MODULE$.assert(io.length() - (long)this.MAGIC().length - 4L - (long)footerLength >= 0L);
        byte[] footerBytes = io.readFully(io.length() - (long)this.MAGIC().length - 4L - (long)footerLength, footerLength);
        ByteArrayInputStream footerInputStream = new ByteArrayInputStream(footerBytes);
        TCompactProtocol protocol = new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)footerInputStream));
        FileMetaData fileMetadata = new FileMetaData();
        fileMetadata.read((TProtocol)protocol);
        return fileMetadata;
    }

    public Footer readFooter(ByteAccess io) {
        return new Footer(this.readFileMetadata(io));
    }

    private ParquetCommon$() {
        MODULE$ = this;
        this.MAGIC = "PAR1".getBytes(Charset.forName("ASCII"));
        this.converter = new MyConverter();
    }
}

