/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import parquet.Preconditions;
import parquet.avro.AvroSchemaConverter;
import parquet.column.Dictionary;
import parquet.io.InvalidRecordException;
import parquet.io.api.Binary;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.Type;

class AvroIndexedRecordConverter<T extends IndexedRecord>
extends GroupConverter {
    private final ParentValueContainer parent;
    protected T currentRecord;
    private final Converter[] converters;
    private final Schema avroSchema;
    private final Class<? extends IndexedRecord> specificClass;
    private final GenericData model;
    private final Map<Schema.Field, Object> recordDefaults = new HashMap<Schema.Field, Object>();

    public AvroIndexedRecordConverter(MessageType parquetSchema, Schema avroSchema) {
        this(null, (GroupType)parquetSchema, avroSchema);
    }

    public AvroIndexedRecordConverter(ParentValueContainer parent, GroupType parquetSchema, Schema avroSchema) {
        this.parent = parent;
        this.avroSchema = avroSchema;
        int schemaSize = parquetSchema.getFieldCount();
        this.converters = new Converter[schemaSize];
        this.specificClass = SpecificData.get().getClass(avroSchema);
        this.model = this.specificClass == null ? GenericData.get() : SpecificData.get();
        HashMap<String, Integer> avroFieldIndexes = new HashMap<String, Integer>();
        int avroFieldIndex = 0;
        for (Schema.Field field : avroSchema.getFields()) {
            avroFieldIndexes.put(field.name(), avroFieldIndex++);
        }
        int parquetFieldIndex = 0;
        for (Type parquetField : parquetSchema.getFields()) {
            Schema.Field avroField = this.getAvroField(parquetField.getName());
            Schema nonNullSchema = AvroSchemaConverter.getNonNull(avroField.schema());
            final int finalAvroIndex = (Integer)avroFieldIndexes.remove(avroField.name());
            this.converters[parquetFieldIndex++] = AvroIndexedRecordConverter.newConverter(nonNullSchema, parquetField, new ParentValueContainer(){

                @Override
                void add(Object value) {
                    AvroIndexedRecordConverter.this.set(finalAvroIndex, value);
                }
            });
        }
        for (String fieldName : avroFieldIndexes.keySet()) {
            Schema.Field field = avroSchema.getField(fieldName);
            if (field.schema().getType() == Schema.Type.NULL || field.defaultValue() == null || this.model.getDefaultValue(field) == null) continue;
            this.recordDefaults.put(field, this.model.getDefaultValue(field));
        }
    }

    private Schema.Field getAvroField(String parquetFieldName) {
        Schema.Field avroField = this.avroSchema.getField(parquetFieldName);
        for (Schema.Field f : this.avroSchema.getFields()) {
            if (!f.aliases().contains(parquetFieldName)) continue;
            return f;
        }
        if (avroField == null) {
            throw new InvalidRecordException(String.format("Parquet/Avro schema mismatch. Avro field '%s' not found.", parquetFieldName));
        }
        return avroField;
    }

    private static Converter newConverter(Schema schema, Type type, ParentValueContainer parent) {
        if (schema.getType().equals((Object)Schema.Type.BOOLEAN)) {
            return new FieldBooleanConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.INT)) {
            return new FieldIntegerConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.LONG)) {
            return new FieldLongConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.FLOAT)) {
            return new FieldFloatConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.DOUBLE)) {
            return new FieldDoubleConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.BYTES)) {
            return new FieldBytesConverter(parent);
        }
        if (schema.getType().equals((Object)Schema.Type.STRING)) {
            return new FieldStringConverter(parent, type.getOriginalType() == OriginalType.UTF8);
        }
        if (schema.getType().equals((Object)Schema.Type.RECORD)) {
            return new AvroIndexedRecordConverter(parent, type.asGroupType(), schema);
        }
        if (schema.getType().equals((Object)Schema.Type.ENUM)) {
            return new FieldEnumConverter(parent, schema);
        }
        if (schema.getType().equals((Object)Schema.Type.ARRAY)) {
            return new AvroArrayConverter(parent, type, schema);
        }
        if (schema.getType().equals((Object)Schema.Type.MAP)) {
            return new MapConverter(parent, type, schema);
        }
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            return new AvroUnionConverter(parent, type, schema);
        }
        if (schema.getType().equals((Object)Schema.Type.FIXED)) {
            return new FieldFixedConverter(parent, schema);
        }
        throw new UnsupportedOperationException(String.format("Cannot convert Avro type: %s (Parquet type: %s) ", schema, type));
    }

    private void set(int index, Object value) {
        this.currentRecord.put(index, value);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void start() {
        this.currentRecord = (IndexedRecord)(this.specificClass == null ? new GenericData.Record(this.avroSchema) : SpecificData.newInstance(this.specificClass, (Schema)this.avroSchema));
    }

    public void end() {
        this.fillInDefaults();
        if (this.parent != null) {
            this.parent.add(this.currentRecord);
        }
    }

    private void fillInDefaults() {
        for (Map.Entry<Schema.Field, Object> entry : this.recordDefaults.entrySet()) {
            Schema.Field f = entry.getKey();
            Object defaultValue = this.deepCopy(f.schema(), entry.getValue());
            this.currentRecord.put(f.pos(), defaultValue);
        }
    }

    private Object deepCopy(Schema schema, Object value) {
        switch (schema.getType()) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return value;
            }
        }
        return this.model.deepCopy(schema, value);
    }

    T getCurrentRecord() {
        return this.currentRecord;
    }

    static final class MapConverter<V>
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Converter keyValueConverter;
        private Map<String, V> map;

        public MapConverter(ParentValueContainer parent, Type parquetSchema, Schema avroSchema) {
            this.parent = parent;
            this.keyValueConverter = new MapKeyValueConverter(parquetSchema, avroSchema);
        }

        public Converter getConverter(int fieldIndex) {
            return this.keyValueConverter;
        }

        public void start() {
            this.map = new HashMap<String, V>();
        }

        public void end() {
            this.parent.add(this.map);
        }

        final class MapKeyValueConverter
        extends GroupConverter {
            private String key;
            private V value;
            private final Converter keyConverter;
            private final Converter valueConverter;

            public MapKeyValueConverter(Type parquetSchema, Schema avroSchema) {
                this.keyConverter = new PrimitiveConverter(){

                    public final void addBinary(Binary value) {
                        MapKeyValueConverter.this.key = value.toStringUsingUTF8();
                    }
                };
                Type valueType = parquetSchema.asGroupType().getType(0).asGroupType().getType(1);
                Schema valueSchema = avroSchema.getValueType();
                this.valueConverter = AvroIndexedRecordConverter.newConverter(valueSchema, valueType, new ParentValueContainer(){

                    @Override
                    void add(Object value) {
                        MapKeyValueConverter.this.value = value;
                    }
                });
            }

            public Converter getConverter(int fieldIndex) {
                if (fieldIndex == 0) {
                    return this.keyConverter;
                }
                if (fieldIndex == 1) {
                    return this.valueConverter;
                }
                throw new IllegalArgumentException("only the key (0) and value (1) fields expected: " + fieldIndex);
            }

            public void start() {
                this.key = null;
                this.value = null;
            }

            public void end() {
                MapConverter.this.map.put(this.key, this.value);
            }
        }
    }

    static final class AvroUnionConverter<T>
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Converter[] memberConverters;
        private Object memberValue = null;

        public AvroUnionConverter(ParentValueContainer parent, Type parquetSchema, Schema avroSchema) {
            this.parent = parent;
            GroupType parquetGroup = parquetSchema.asGroupType();
            this.memberConverters = new Converter[parquetGroup.getFieldCount()];
            int parquetIndex = 0;
            for (int index = 0; index < avroSchema.getTypes().size(); ++index) {
                Schema memberSchema = (Schema)avroSchema.getTypes().get(index);
                if (memberSchema.getType().equals((Object)Schema.Type.NULL)) continue;
                Type memberType = parquetGroup.getType(parquetIndex);
                this.memberConverters[parquetIndex] = AvroIndexedRecordConverter.newConverter(memberSchema, memberType, new ParentValueContainer(){

                    @Override
                    void add(Object value) {
                        Preconditions.checkArgument((AvroUnionConverter.this.memberValue == null ? 1 : 0) != 0, (String)"Union is resolving to more than one type");
                        AvroUnionConverter.this.memberValue = value;
                    }
                });
                ++parquetIndex;
            }
        }

        public Converter getConverter(int fieldIndex) {
            return this.memberConverters[fieldIndex];
        }

        public void start() {
            this.memberValue = null;
        }

        public void end() {
            this.parent.add(this.memberValue);
        }
    }

    static final class AvroArrayConverter<T>
    extends GroupConverter {
        private final ParentValueContainer parent;
        private final Schema avroSchema;
        private final Converter converter;
        private GenericArray<T> array;

        public AvroArrayConverter(ParentValueContainer parent, Type parquetSchema, Schema avroSchema) {
            this.parent = parent;
            this.avroSchema = avroSchema;
            Type elementType = parquetSchema.asGroupType().getType(0);
            Schema elementSchema = avroSchema.getElementType();
            this.converter = AvroIndexedRecordConverter.newConverter(elementSchema, elementType, new ParentValueContainer(){

                @Override
                void add(Object value) {
                    AvroArrayConverter.this.array.add(value);
                }
            });
        }

        public Converter getConverter(int fieldIndex) {
            return this.converter;
        }

        public void start() {
            this.array = new GenericData.Array(0, this.avroSchema);
        }

        public void end() {
            this.parent.add(this.array);
        }
    }

    static final class FieldFixedConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;
        private final Schema avroSchema;
        private final Class<? extends GenericData.Fixed> fixedClass;
        private final Constructor fixedClassCtor;

        public FieldFixedConverter(ParentValueContainer parent, Schema avroSchema) {
            this.parent = parent;
            this.avroSchema = avroSchema;
            this.fixedClass = SpecificData.get().getClass(avroSchema);
            if (this.fixedClass != null) {
                try {
                    this.fixedClassCtor = this.fixedClass.getConstructor(byte[].class);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.fixedClassCtor = null;
            }
        }

        public final void addBinary(Binary value) {
            if (this.fixedClass == null) {
                this.parent.add(new GenericData.Fixed(this.avroSchema, value.getBytes()));
            } else {
                if (this.fixedClassCtor == null) {
                    throw new IllegalArgumentException("fixedClass specified but fixedClassCtor is null.");
                }
                try {
                    Object fixed = this.fixedClassCtor.newInstance(new Object[]{value.getBytes()});
                    this.parent.add(fixed);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    static final class FieldEnumConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;
        private final Class<? extends Enum> enumClass;

        public FieldEnumConverter(ParentValueContainer parent, Schema enumSchema) {
            this.parent = parent;
            this.enumClass = SpecificData.get().getClass(enumSchema);
        }

        public final void addBinary(Binary value) {
            Object enumValue = value.toStringUsingUTF8();
            if (this.enumClass != null) {
                enumValue = Enum.valueOf(this.enumClass, (String)enumValue);
            }
            this.parent.add(enumValue);
        }
    }

    static final class FieldStringConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;
        private final boolean dictionarySupport;
        private String[] dict;

        public FieldStringConverter(ParentValueContainer parent, boolean dictionarySupport) {
            this.parent = parent;
            this.dictionarySupport = dictionarySupport;
        }

        public final void addBinary(Binary value) {
            this.parent.add(value.toStringUsingUTF8());
        }

        public boolean hasDictionarySupport() {
            return this.dictionarySupport;
        }

        public void setDictionary(Dictionary dictionary) {
            this.dict = new String[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                this.dict[i] = dictionary.decodeToBinary(i).toStringUsingUTF8();
            }
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.add(this.dict[dictionaryId]);
        }
    }

    static final class FieldBytesConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldBytesConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addBinary(Binary value) {
            this.parent.add(ByteBuffer.wrap(value.getBytes()));
        }
    }

    static final class FieldDoubleConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldDoubleConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addInt(int value) {
            this.parent.add(value);
        }

        public final void addLong(long value) {
            this.parent.add(value);
        }

        public final void addFloat(float value) {
            this.parent.add(value);
        }

        public final void addDouble(double value) {
            this.parent.add(value);
        }
    }

    static final class FieldFloatConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldFloatConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addInt(int value) {
            this.parent.add(Float.valueOf(value));
        }

        public final void addLong(long value) {
            this.parent.add(Float.valueOf(value));
        }

        public final void addFloat(float value) {
            this.parent.add(Float.valueOf(value));
        }
    }

    static final class FieldLongConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldLongConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addInt(int value) {
            this.parent.add(value);
        }

        public final void addLong(long value) {
            this.parent.add(value);
        }
    }

    static final class FieldIntegerConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldIntegerConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addInt(int value) {
            this.parent.add(value);
        }
    }

    static final class FieldBooleanConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        public FieldBooleanConverter(ParentValueContainer parent) {
            this.parent = parent;
        }

        public final void addBoolean(boolean value) {
            this.parent.add(value);
        }
    }

    static abstract class ParentValueContainer {
        ParentValueContainer() {
        }

        abstract void add(Object var1);
    }
}

