/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.utils.instrumentation;

import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.tag.Tags;
import java.io.PrintWriter;
import org.bdgenomics.utils.instrumentation.Alignment$;
import org.bdgenomics.utils.instrumentation.ConfigurableMonitor;
import org.bdgenomics.utils.instrumentation.InstrumentationFunctions$;
import org.bdgenomics.utils.instrumentation.ServoTimer;
import org.bdgenomics.utils.instrumentation.ServoTimer$;
import org.bdgenomics.utils.instrumentation.SparkMetrics$;
import org.bdgenomics.utils.instrumentation.SparkMetrics$TimerOrdering$2$;
import org.bdgenomics.utils.instrumentation.StageTiming;
import org.bdgenomics.utils.instrumentation.TableHeader;
import org.bdgenomics.utils.instrumentation.TableHeader$;
import org.bdgenomics.utils.instrumentation.TaskTimer;
import org.bdgenomics.utils.instrumentation.ValueExtractor;
import org.bdgenomics.utils.instrumentation.ValueExtractor$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-e!B\u0001\u0003\u0003\u0003Y!\u0001D*qCJ\\W*\u001a;sS\u000e\u001c(BA\u0002\u0005\u0003=Ign\u001d;sk6,g\u000e^1uS>t'BA\u0003\u0007\u0003\u0015)H/\u001b7t\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u001dA\u0002A1A\u0005\ne\t!\u0002^1tWRKW.\u001a:t+\u0005Q\u0002cA\u000e!E5\tAD\u0003\u0002\u001e=\u00059Q.\u001e;bE2,'BA\u0010\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Cq\u00111\"\u0011:sCf\u0014UO\u001a4feB\u0011acI\u0005\u0003I\t\u0011\u0011\u0002V1tWRKW.\u001a:\t\r\u0019\u0002\u0001\u0015!\u0003\u001b\u0003-!\u0018m]6US6,'o\u001d\u0011\t\u000f!\u0002!\u0019!C\u0005S\u0005i1\u000f^1hK&#Gk\u001c(b[\u0016,\u0012A\u000b\t\u00057-j\u0003'\u0003\u0002-9\t9\u0001*Y:i\u001b\u0006\u0004\bCA\u0007/\u0013\tycBA\u0002J]R\u0004\"!\r\u001b\u000f\u00055\u0011\u0014BA\u001a\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Mr\u0001B\u0002\u001d\u0001A\u0003%!&\u0001\bti\u0006<W-\u00133U_:\u000bW.\u001a\u0011\t\u000fi\u0002!\u0019!C\u0001w\u0005Q1\u000f^1hKRKW.Z:\u0016\u0003q\u00022a\u0007\u0011>!\t1b(\u0003\u0002@\u0005\tY1\u000b^1hKRKW.\u001b8h\u0011\u0019\t\u0005\u0001)A\u0005y\u0005Y1\u000f^1hKRKW.Z:!\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0003\u0015\u0001(/\u001b8u)\t)\u0005\n\u0005\u0002\u000e\r&\u0011qI\u0004\u0002\u0005+:LG\u000fC\u0003J\u0005\u0002\u0007!*A\u0002pkR\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\u0005%|'\"A(\u0002\t)\fg/Y\u0005\u0003#2\u00131\u0002\u0015:j]R<&/\u001b;fe\")1\u000b\u0001C\u0001)\u0006\u0001R.\u00199Ti\u0006<W-\u00133U_:\u000bW.\u001a\u000b\u0004\u000bV;\u0006\"\u0002,S\u0001\u0004i\u0013aB:uC\u001e,\u0017\n\u001a\u0005\u00061J\u0003\r\u0001M\u0001\ngR\fw-\u001a(b[\u0016DQA\u0017\u0001\u0005\u0002m\u000b1C]3d_J$7\u000b^1hK\u0012+(/\u0019;j_:$B\u0001\u0010/^C\")a+\u0017a\u0001[!)\u0001,\u0017a\u0001=B\u0019Qb\u0018\u0019\n\u0005\u0001t!AB(qi&|g\u000eC\u0003c3\u0002\u00071-\u0001\u0005ekJ\fG/[8o!\t!\u0007.D\u0001f\u0015\t\u0011gM\u0003\u0002h\u001d\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005%,'\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u000b-\u0004A\u0011\u00037\u0002\u0013Q\f7o\u001b+j[\u0016\u0014HC\u0001\u0012n\u0011\u0015q'\u000e1\u00011\u0003\u0011q\u0017-\\3\t\u000bA\u0004A\u0011B9\u0002\u0017\u001d,Go\u0014:eKJLgn\u001a\u000b\u0004e\u0006\r\u0001cA:|}:\u0011A/\u001f\b\u0003kbl\u0011A\u001e\u0006\u0003o*\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005it\u0011a\u00029bG.\fw-Z\u0005\u0003yv\u0014\u0001b\u0014:eKJLgn\u001a\u0006\u0003u:\u0001\"AF@\n\u0007\u0005\u0005!A\u0001\u0006TKJ4x\u000eV5nKJDq!!\u0002p\u0001\u0004\t9!\u0001\u0004uS6,'o\u001d\t\u0005g\u0006%a0C\u0002\u0002\fu\u00141aU3r\u0011\u001d\ty\u0001\u0001C\u0005\u0003#\tAbZ3u'>\u0014Ho\u0014:eKJ$B!a\u0005\u0002\u001aA)\u0011'!\u00061[%\u0019\u0011q\u0003\u001c\u0003\u00075\u000b\u0007\u000f\u0003\u0005\u0002\u0006\u00055\u0001\u0019AA\u0004\u0011\u001d\ti\u0002\u0001C\u0005\u0003?\tA\"\u00193e'R\fw-\u001a(b[\u0016$2A`A\u0011\u0011!\t\u0019#a\u0007A\u0002\u0005\u0015\u0012aD:uC\u001e,\u0017\nZ!oIRKW.\u001a:\u0011\u000b5\t9#\f@\n\u0007\u0005%bB\u0001\u0004UkBdWM\r\u0005\b\u0003[\u0001A\u0011BA\u0018\u0003Q1wN]7biN#\u0018mZ3JI\u0006sGMT1nKR)\u0001'!\r\u00024!1a+a\u000bA\u00025Ba\u0001WA\u0016\u0001\u0004q\u0006bBA\u001c\u0001\u0011%\u0011\u0011H\u0001\u0011GJ,\u0017\r^3IK\u0006$WM],ji\"$b!a\u000f\u0002D\u0005\u001d\u0003\u0003B\u000e!\u0003{\u00012AFA \u0013\r\t\tE\u0001\u0002\f)\u0006\u0014G.\u001a%fC\u0012,'\u000f\u0003\u0005\u0002F\u0005U\u0002\u0019AA\u001f\u0003\u0019AW-\u00193fe\"9\u0011\u0011JA\u001b\u0001\u0004i\u0013\u0001\u00039pg&$\u0018n\u001c8\t\u000f\u00055\u0003\u0001\"\u0003\u0002P\u0005\u00012M]3bi\u0016$\u0016m]6IK\u0006$WM\u001d\u000b\u0003\u0003w9q!a\u0015\u0003\u0011#\t)&\u0001\u0007Ta\u0006\u00148.T3ue&\u001c7\u000fE\u0002\u0017\u0003/2a!\u0001\u0002\t\u0012\u0005e3cAA,\u0019!91#a\u0016\u0005\u0002\u0005uCCAA+\u0011)\t\t'a\u0016C\u0002\u0013\u0015\u00111M\u0001\u000b\u0011>\u001cH\u000fV1h\u0017\u0016LXCAA3\u001f\t\t9'\t\u0002\u0002j\u0005!\u0001n\\:u\u0011%\ti'a\u0016!\u0002\u001b\t)'A\u0006I_N$H+Y4LKf\u0004\u0003BCA9\u0003/\u0012\r\u0011\"\u0002\u0002t\u0005y1\u000b^1hK:\u000bW.\u001a+bO.+\u00170\u0006\u0002\u0002v=\u0011\u0011qO\u0011\u00021\"I\u00111PA,A\u00035\u0011QO\u0001\u0011'R\fw-\u001a(b[\u0016$\u0016mZ&fs\u0002B!\"a \u0002X\t\u0007IQAAA\u00035\u0019F/Y4f\u0013\u0012$\u0016mZ&fsV\u0011\u00111Q\b\u0003\u0003\u000b\u000b\u0013A\u0016\u0005\n\u0003\u0013\u000b9\u0006)A\u0007\u0003\u0007\u000bab\u0015;bO\u0016LE\rV1h\u0017\u0016L\b\u0005")
public abstract class SparkMetrics {
    private final ArrayBuffer<TaskTimer> taskTimers = new ArrayBuffer();
    private final HashMap<Object, String> stageIdToName = new HashMap();
    private final ArrayBuffer<StageTiming> stageTimes = new ArrayBuffer();

    public static String StageIdTagKey() {
        return SparkMetrics$.MODULE$.StageIdTagKey();
    }

    public static String StageNameTagKey() {
        return SparkMetrics$.MODULE$.StageNameTagKey();
    }

    public static String HostTagKey() {
        return SparkMetrics$.MODULE$.HostTagKey();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SparkMetrics$TimerOrdering$2$ org$bdgenomics$utils$instrumentation$SparkMetrics$$TimerOrdering$1$lzycompute(Map x$1, VolatileObjectRef x$2) {
        SparkMetrics sparkMetrics = this;
        synchronized (sparkMetrics) {
            if (x$2.elem != null) return (SparkMetrics$TimerOrdering$2$)x$2.elem;
            x$2.elem = new SparkMetrics$TimerOrdering$2$(this, x$1, x$2);
            return (SparkMetrics$TimerOrdering$2$)x$2.elem;
        }
    }

    private ArrayBuffer<TaskTimer> taskTimers() {
        return this.taskTimers;
    }

    private HashMap<Object, String> stageIdToName() {
        return this.stageIdToName;
    }

    public ArrayBuffer<StageTiming> stageTimes() {
        return this.stageTimes;
    }

    public void print(PrintWriter out) {
        ArrayBuffer overallMonitors = (ArrayBuffer)((SeqLike)this.taskTimers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ServoTimer apply(TaskTimer x$1) {
                return x$1.getOverallTimings();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(ServoTimer x$2) {
                return -x$2.getTotalTime();
            }
        }, (Ordering)Ordering.Long$.MODULE$);
        Ordering<ServoTimer> ordering = this.getOrdering((Seq<ServoTimer>)overallMonitors);
        ArrayBuffer monitorsByHost = (ArrayBuffer)((SeqLike)this.taskTimers().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<ServoTimer> apply(TaskTimer x$3) {
                return x$3.getHostTimings();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sorted(ordering);
        ArrayBuffer monitorsByStageName = (ArrayBuffer)((SeqLike)((TraversableLike)this.taskTimers().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<Object, ServoTimer>> apply(TaskTimer x$4) {
                return x$4.getStageTimings();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkMetrics $outer;

            public final ServoTimer apply(Tuple2<Object, ServoTimer> stageIdAndTimer) {
                return this.$outer.org$bdgenomics$utils$instrumentation$SparkMetrics$$addStageName(stageIdAndTimer);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sorted(ordering);
        InstrumentationFunctions$.MODULE$.renderTable(out, "Task Timings", (Seq<Monitor<?>>)overallMonitors, (Seq<TableHeader>)this.createTaskHeader());
        out.println();
        String x$5 = "Host";
        ValueExtractor x$6 = ValueExtractor$.MODULE$.forTagValueWithKey("host");
        Enumeration.Value x$7 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$8 = TableHeader$.MODULE$.apply$default$3();
        InstrumentationFunctions$.MODULE$.renderTable(out, "Task Timings By Host", (Seq<Monitor<?>>)monitorsByHost, (Seq<TableHeader>)this.createHeaderWith(new TableHeader(x$5, x$6, x$8, x$7), 1));
        out.println();
        String x$9 = "Stage ID & Name";
        ValueExtractor x$10 = ValueExtractor$.MODULE$.forTagValueWithKey("stageName");
        Enumeration.Value x$11 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$12 = TableHeader$.MODULE$.apply$default$3();
        InstrumentationFunctions$.MODULE$.renderTable(out, "Task Timings By Stage", (Seq<Monitor<?>>)monitorsByStageName, (Seq<TableHeader>)this.createHeaderWith(new TableHeader(x$9, x$10, x$12, x$11), 1));
    }

    public void mapStageIdToName(int stageId, String stageName) {
        this.stageIdToName().put((Object)BoxesRunTime.boxToInteger((int)stageId), (Object)stageName);
    }

    public ArrayBuffer<StageTiming> recordStageDuration(int stageId, Option<String> stageName, Duration duration) {
        return this.stageTimes().$plus$eq((Object)new StageTiming(stageId, stageName, duration));
    }

    /*
     * WARNING - void declaration
     */
    public TaskTimer taskTimer(String name) {
        void var2_2;
        TaskTimer timer = new TaskTimer(name);
        this.taskTimers().$plus$eq((Object)timer);
        return var2_2;
    }

    private Ordering<ServoTimer> getOrdering(Seq<ServoTimer> timers) {
        VolatileObjectRef TimerOrdering$module = new VolatileObjectRef(null);
        Map<String, Object> sortOrderMap = this.getSortOrder(timers);
        return this.org$bdgenomics$utils$instrumentation$SparkMetrics$$TimerOrdering$1(sortOrderMap, TimerOrdering$module);
    }

    private Map<String, Object> getSortOrder(Seq<ServoTimer> timers) {
        IntRef sortOrder = new IntRef(0);
        return ((TraversableOnce)timers.map((Function1)new Serializable(this, sortOrder){
            public static final long serialVersionUID = 0L;
            private final IntRef sortOrder$1;

            public final Tuple2<String, Object> apply(ServoTimer timer) {
                ++this.sortOrder$1.elem;
                return new Tuple2((Object)timer.getName(), (Object)BoxesRunTime.boxToInteger((int)this.sortOrder$1.elem));
            }
            {
                this.sortOrder$1 = sortOrder$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public ServoTimer org$bdgenomics$utils$instrumentation$SparkMetrics$$addStageName(Tuple2<Object, ServoTimer> stageIdAndTimer) {
        String stageIdAndName = this.formatStageIdAndName(stageIdAndTimer._1$mcI$sp(), (Option<String>)this.stageIdToName().get((Object)BoxesRunTime.boxToInteger((int)stageIdAndTimer._1$mcI$sp())));
        ((ConfigurableMonitor)stageIdAndTimer._2()).addTag(Tags.newTag((String)"stageName", (String)stageIdAndName));
        return (ServoTimer)stageIdAndTimer._2();
    }

    private String formatStageIdAndName(int stageId, Option<String> stageName) {
        return new StringBuilder().append(stageId).append((Object)": ").append(stageName.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unknown";
            }
        })).toString();
    }

    /*
     * WARNING - void declaration
     */
    private ArrayBuffer<TableHeader> createHeaderWith(TableHeader header, int position) {
        void var3_3;
        ArrayBuffer<TableHeader> baseHeader = this.createTaskHeader();
        baseHeader.insert(position, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableHeader[]{header}));
        return var3_3;
    }

    private ArrayBuffer<TableHeader> createTaskHeader() {
        TableHeader[] tableHeaderArray = new TableHeader[6];
        String x$13 = "Metric";
        ValueExtractor x$14 = ValueExtractor$.MODULE$.forTagValueWithKey("name");
        Enumeration.Value x$15 = Alignment$.MODULE$.Left();
        Option<Function1<Object, String>> x$16 = TableHeader$.MODULE$.apply$default$3();
        tableHeaderArray[0] = new TableHeader(x$13, x$14, x$16, x$15);
        tableHeaderArray[1] = new TableHeader("Total Time", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.TotalTimeTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[2] = new TableHeader("Count", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.CountTag()), TableHeader$.MODULE$.apply$default$3(), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[3] = new TableHeader("Mean", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.MeanTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[4] = new TableHeader("Min", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.MinTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        tableHeaderArray[5] = new TableHeader("Max", ValueExtractor$.MODULE$.forMonitorMatchingTag(ServoTimer$.MODULE$.MaxTag()), (Option<Function1<Object, String>>)new Some((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object number) {
                return InstrumentationFunctions$.MODULE$.formatNanos(number);
            }
        }), TableHeader$.MODULE$.apply$default$4());
        return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tableHeaderArray));
    }

    public final SparkMetrics$TimerOrdering$2$ org$bdgenomics$utils$instrumentation$SparkMetrics$$TimerOrdering$1(Map sortOrderMap$1, VolatileObjectRef TimerOrdering$module$1) {
        return TimerOrdering$module$1.elem == null ? this.org$bdgenomics$utils$instrumentation$SparkMetrics$$TimerOrdering$1$lzycompute(sortOrderMap$1, TimerOrdering$module$1) : (SparkMetrics$TimerOrdering$2$)TimerOrdering$module$1.elem;
    }
}

