/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.cli.plugins;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.ValidationStringency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.seqdoop.hadoop_bam.AnySAMInputFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.cli.CLIMRBAMPlugin;
import org.seqdoop.hadoop_bam.cli.CLIMergingAnySAMOutputFormat;
import org.seqdoop.hadoop_bam.cli.Utils;
import org.seqdoop.hadoop_bam.cli.plugins.FixMateMapper;
import org.seqdoop.hadoop_bam.cli.plugins.FixMateReducer;
import org.seqdoop.hadoop_bam.custom.jargs.gnu.CmdLineParser;
import org.seqdoop.hadoop_bam.util.Pair;
import org.seqdoop.hadoop_bam.util.Timer;

public final class FixMate
extends CLIMRBAMPlugin {
    private static final List<Pair<CmdLineParser.Option, String>> optionDescs = new ArrayList<Pair<CmdLineParser.Option, String>>();
    private static final CmdLineParser.Option sortOpt = new CmdLineParser.Option.BooleanOption('s', "sort");
    private static final CmdLineParser.Option noCombinerOpt = new CmdLineParser.Option.BooleanOption('C', "no-combine");
    private static final CmdLineParser.Option stringencyOpt = new CmdLineParser.Option.StringOption("validation-stringency=S");

    public FixMate() {
        super("fixmate", "BAM and SAM mate information fixing", "1.1", "WORKDIR INPATH [INPATH...]", optionDescs, "Merges together the BAM and SAM files (the INPATHs), while filling in mate information, all distributed with Hadoop MapReduce. Output parts are placed in WORKDIR in, by default, headerless and unterminated BAM format.\n\nWhen more than two primary reads with the same name exist in the inputs, the result is unpredictable. Without using the -C option, it is possible that multiple reads are mated to the same read.");
    }

    @Override
    protected int run(CmdLineParser parser) {
        boolean globalSort;
        List<String> args = parser.getRemainingArgs();
        if (args.isEmpty()) {
            System.err.println("fixmate :: WORKDIR not given.");
            return 3;
        }
        if (args.size() == 1) {
            System.err.println("fixmate :: INPATH not given.");
            return 3;
        }
        if (!this.cacheAndSetProperties(parser)) {
            return 3;
        }
        ValidationStringency stringency = Utils.toStringency(parser.getOptionValue(stringencyOpt, ValidationStringency.DEFAULT_STRINGENCY.toString()), "fixmate");
        if (stringency == null) {
            return 3;
        }
        Path wrkDir = new Path(args.get(0));
        List<String> strInputs = args.subList(1, args.size());
        ArrayList<Path> inputs = new ArrayList<Path>(strInputs.size());
        for (String in : strInputs) {
            inputs.add(new Path(in));
        }
        Configuration conf = this.getConf();
        String intermediateOutName = (this.outPath == null ? (Path)inputs.get(0) : this.outPath).getName();
        conf.set("hadoopbam.work.filename", intermediateOutName);
        if (stringency != null) {
            conf.set("hadoopbam.samheaderreader.validation-stringency", stringency.toString());
        }
        if (globalSort = parser.getBoolean(sortOpt)) {
            Utils.setHeaderMergerSortOrder(conf, SAMFileHeader.SortOrder.queryname);
        }
        conf.setStrings("hadoopbam.headermerger.inputs", strInputs.toArray(new String[0]));
        Timer t = new Timer();
        try {
            wrkDir = wrkDir.getFileSystem(conf).makeQualified(wrkDir);
            if (globalSort) {
                Utils.configureSampling(wrkDir, intermediateOutName, conf);
            }
            Job job = new Job(conf);
            job.setJarByClass(FixMate.class);
            job.setMapperClass(FixMateMapper.class);
            job.setReducerClass(FixMateReducer.class);
            if (!parser.getBoolean(noCombinerOpt)) {
                job.setCombinerClass(FixMateReducer.class);
            }
            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(SAMRecordWritable.class);
            job.setInputFormatClass(AnySAMInputFormat.class);
            job.setOutputFormatClass(CLIMergingAnySAMOutputFormat.class);
            for (Path in : inputs) {
                FileInputFormat.addInputPath((Job)job, (Path)in);
            }
            FileOutputFormat.setOutputPath((Job)job, (Path)wrkDir);
            if (globalSort) {
                job.setPartitionerClass(TotalOrderPartitioner.class);
                System.out.println("fixmate :: Sampling...");
                t.start();
                InputSampler.writePartitionFile((Job)job, (InputSampler.Sampler)new InputSampler.RandomSampler(0.01, 10000, Math.max(100, this.reduceTasks)));
                System.out.printf("fixmate :: Sampling complete in %d.%03d s.\n", t.stopS(), t.fms());
            }
            job.submit();
            System.out.println("fixmate :: Waiting for job completion...");
            t.start();
            if (!job.waitForCompletion(this.verbose)) {
                System.err.println("fixmate :: Job failed.");
                return 4;
            }
            System.out.printf("fixmate :: Job complete in %d.%03d s.\n", t.stopS(), t.fms());
        }
        catch (IOException e) {
            System.err.printf("fixmate :: Hadoop error: %s\n", e);
            return 4;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.outPath != null) {
            try {
                Utils.mergeSAMInto(this.outPath, wrkDir, "", "", this.samFormat, conf, "fixmate");
            }
            catch (IOException e) {
                System.err.printf("fixmate :: Output merging failed: %s\n", e);
                return 5;
            }
        }
        return 0;
    }

    static {
        optionDescs.add(new Pair<CmdLineParser.Option, String>(sortOpt, "also globally sort the result by query name"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(noCombinerOpt, "don't use a combiner; less efficient, but guarantees validity of results when there are multiple possible pairings"));
        optionDescs.add(new Pair<CmdLineParser.Option, String>(stringencyOpt, Utils.getStringencyOptHelp()));
    }
}

