/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.algorithms.consensus;

import org.apache.avro.Schema;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.models.Consensus;
import org.bdgenomics.adam.models.IndelTable;
import org.bdgenomics.adam.models.IndelTable$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.read.realignment.IndelRealignmentTarget;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.formats.avro.Variant;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u001b\ta2i\u001c8tK:\u001cXo]$f]\u0016\u0014\u0018\r^8s\rJ|Wn\u00138po:\u001c(BA\u0002\u0005\u0003%\u0019wN\\:f]N,8O\u0003\u0002\u0006\r\u0005Q\u0011\r\\4pe&$\b.\\:\u000b\u0005\u001dA\u0011\u0001B1eC6T!!\u0003\u0006\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t\u00112i\u001c8tK:\u001cXo]$f]\u0016\u0014\u0018\r^8s\u0011!\u0019\u0002A!A!\u0002\u0013!\u0012\u0001\u00024jY\u0016\u0004\"!F\u000e\u000f\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0002\rA\u0013X\rZ3g\u0013\taRD\u0001\u0004TiJLgn\u001a\u0006\u00035]A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0003g\u000e\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0015R\u0011AB1qC\u000eDW-\u0003\u0002(E\ta1\u000b]1sW\u000e{g\u000e^3yi\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"2a\u000b\u0017.!\ty\u0001\u0001C\u0003\u0014Q\u0001\u0007A\u0003C\u0003 Q\u0001\u0007\u0001\u0005C\u00040\u0001\t\u0007I\u0011\u0001\u0019\u0002\u0015%tG-\u001a7UC\ndW-F\u00012!\r\u0011TgN\u0007\u0002g)\u0011AGI\u0001\nEJ|\u0017\rZ2bgRL!AN\u001a\u0003\u0013\t\u0013x.\u00193dCN$\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0007\u0003\u0019iw\u000eZ3mg&\u0011A(\u000f\u0002\u000b\u0013:$W\r\u001c+bE2,\u0007B\u0002 \u0001A\u0003%\u0011'A\u0006j]\u0012,G\u000eV1cY\u0016\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015\u0001\u0004;be\u001e,Go\u001d+p\u0003\u0012$G#\u0001\"\u0011\u0007Y\u0019U)\u0003\u0002E/\t1q\n\u001d;j_:\u00042AR%L\u001b\u00059%B\u0001%#\u0003\r\u0011H\rZ\u0005\u0003\u0015\u001e\u00131A\u0015#E!\ta%+D\u0001N\u0015\tqu*A\u0006sK\u0006d\u0017n\u001a8nK:$(B\u0001)R\u0003\u0011\u0011X-\u00193\u000b\u0005!3\u0011BA*N\u0005YIe\u000eZ3m%\u0016\fG.[4o[\u0016tG\u000fV1sO\u0016$\b\"B+\u0001\t\u00031\u0016!\b9sKB\u0014xnY3tgJ+\u0017\rZ:G_J\u0014V-\u00197jO:lWM\u001c;\u0015\t]K7.\u001c\t\u00041\u0002\u001cgBA-_\u001d\tQV,D\u0001\\\u0015\taF\"\u0001\u0004=e>|GOP\u0005\u00021%\u0011qlF\u0001\ba\u0006\u001c7.Y4f\u0013\t\t'M\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\tyv\u0003\u0005\u0002eO6\tQM\u0003\u0002g\r\u0005!!/[2i\u0013\tAWMA\nSS\u000eD\u0017\t\\5h]6,g\u000e\u001e*fG>\u0014H\rC\u0003k)\u0002\u0007q+A\u0003sK\u0006$7\u000fC\u0003m)\u0002\u0007A#A\u0005sK\u001a,'/\u001a8dK\")a\u000e\u0016a\u0001_\u00061!/Z4j_:\u0004\"\u0001\u000f9\n\u0005EL$a\u0004*fM\u0016\u0014XM\\2f%\u0016<\u0017n\u001c8\t\u000bM\u0004A\u0011\u0001;\u0002\u001b\u0019Lg\u000eZ\"p]N,gn];t)\t)\u0018\u0010E\u0002YAZ\u0004\"\u0001O<\n\u0005aL$!C\"p]N,gn];t\u0011\u0015Q'\u000f1\u0001X\u0001")
public class ConsensusGeneratorFromKnowns
extends ConsensusGenerator {
    private final String file;
    private final SparkContext sc;
    private final Broadcast<IndelTable> indelTable;

    public Broadcast<IndelTable> indelTable() {
        return this.indelTable;
    }

    @Override
    public Option<RDD<IndelRealignmentTarget>> targetsToAdd() {
        ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc);
        String x$7 = this.file;
        None$ x$8 = qual$1.loadVariants$default$2();
        Option<Schema> x$9 = qual$1.loadVariants$default$3();
        Option<SequenceDictionary> x$10 = qual$1.loadVariants$default$4();
        RDD<Variant> rdd = qual$1.loadVariants(x$7, x$8, x$9, x$10);
        return new Some((Object)rdd.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Variant v) {
                return v.getReferenceAllele().length() != v.getAlternateAllele().length();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReferenceRegion apply(Variant v) {
                return new ReferenceRegion(v.getContig().getContigName(), Predef$.MODULE$.Long2long(v.getStart()), Predef$.MODULE$.Long2long(v.getStart()) + (long)v.getReferenceAllele().length());
            }
        }, ClassTag$.MODULE$.apply(ReferenceRegion.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndelRealignmentTarget apply(ReferenceRegion r) {
                return new IndelRealignmentTarget((Option<ReferenceRegion>)new Some((Object)r), r);
            }
        }, ClassTag$.MODULE$.apply(IndelRealignmentTarget.class)));
    }

    @Override
    public Iterable<RichAlignmentRecord> preprocessReadsForRealignment(Iterable<RichAlignmentRecord> reads, String reference, ReferenceRegion region2) {
        return reads;
    }

    @Override
    public Iterable<Consensus> findConsensus(Iterable<RichAlignmentRecord> reads) {
        IndelTable table = (IndelTable)this.indelTable().value();
        long start = BoxesRunTime.unboxToLong((Object)((TraversableOnce)reads.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RichAlignmentRecord x$1) {
                return Predef$.MODULE$.Long2long(x$1.record().getStart());
            }
        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$2, long x$3) {
                return this.apply$mcJJJ$sp(x$2, x$3);
            }

            public long apply$mcJJJ$sp(long x$2, long x$3) {
                return BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(x$2)).min((Object)BoxesRunTime.boxToLong((long)x$3)));
            }
        }));
        long end2 = BoxesRunTime.unboxToLong((Object)((TraversableOnce)reads.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RichAlignmentRecord x$4) {
                return Predef$.MODULE$.Long2long(RichAlignmentRecord$.MODULE$.richRecordToRecord(x$4).getEnd());
            }
        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$5, long x$6) {
                return this.apply$mcJJJ$sp(x$5, x$6);
            }

            public long apply$mcJJJ$sp(long x$5, long x$6) {
                return BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(x$5)).max((Object)BoxesRunTime.boxToLong((long)x$6)));
            }
        }));
        String refId = ((RichAlignmentRecord)reads.head()).record().getContig().getContigName();
        ReferenceRegion region2 = new ReferenceRegion(refId, start, end2 + 1L);
        return table.getIndelsInRegion(region2);
    }

    public ConsensusGeneratorFromKnowns(String file, SparkContext sc) {
        this.file = file;
        this.sc = sc;
        this.indelTable = sc.broadcast((Object)IndelTable$.MODULE$.apply(file, sc), ClassTag$.MODULE$.apply(IndelTable.class));
    }
}

