/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.spark.Logging;
import org.bdgenomics.adam.converters.VariantAnnotationConverter$;
import org.bdgenomics.adam.converters.VariantContextConverter$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.VariantContext$;
import org.bdgenomics.adam.rich.RichVariant$;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.DatabaseVariantAnnotation;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.formats.avro.GenotypeAllele;
import org.bdgenomics.formats.avro.Variant;
import org.bdgenomics.formats.avro.VariantCallingAnnotations;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\t\u001dr!B\u0001\u0003\u0011\u0003Y\u0011a\u0006,be&\fg\u000e^\"p]R,\u0007\u0010^\"p]Z,'\u000f^3s\u0015\t\u0019A!\u0001\u0006d_:4XM\u001d;feNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!a\u0006,be&\fg\u000e^\"p]R,\u0007\u0010^\"p]Z,'\u000f^3s'\ri\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E9\u0012B\u0001\r\u0013\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015QR\u0002\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001e\u001b\t\u0007I\u0011\u0002\u0010\u0002\u001d9{ej\u0018*F\r~\u000bE\nT#M\u000bV\tq\u0004\u0005\u0002!O5\t\u0011E\u0003\u0002#G\u0005qa/\u0019:jC:$8m\u001c8uKb$(B\u0001\u0013&\u0003\u001d1\u0018M]5b]RT\u0011AJ\u0001\u0007QR\u001c(\u000eZ6\n\u0005!\n#AB!mY\u0016dW\r\u0003\u0004+\u001b\u0001\u0006IaH\u0001\u0010\u001d>suLU#G?\u0006cE*\u0012'FA!AA&\u0004EC\u0002\u0013%Q&\u0001\u000eta2LGO\u0012:p[6+H\u000e^5BY2,G.[2GS\u0016dG-F\u0001/!\tyc'D\u00011\u0015\t\t$'\u0001\u0004TG\",W.\u0019\u0006\u0003gQ\nA!\u0019<s_*\u0011Q\u0007C\u0001\u0007CB\f7\r[3\n\u0005]\u0002$!\u0002$jK2$\u0007\u0002C\u001d\u000e\u0011\u0003\u0005\u000b\u0015\u0002\u0018\u00027M\u0004H.\u001b;Ge>lW*\u001e7uS\u0006cG.\u001a7jG\u001aKW\r\u001c3!\u0011\u0015YT\u0002\"\u0003=\u00035\u0019wN\u001c<feR\fE\u000e\\3mKR\u0019Q\bR%\u0011\u0005y\u0012U\"A \u000b\u0005M\u0002%BA!\u0007\u0003\u001d1wN]7biNL!aQ \u0003\u001d\u001d+gn\u001c;za\u0016\fE\u000e\\3mK\")QI\u000fa\u0001\r\u0006\u0011ao\u0019\t\u0003A\u001dK!\u0001S\u0011\u0003\u001dY\u000b'/[1oi\u000e{g\u000e^3yi\")!J\u000fa\u0001?\u00051\u0011\r\u001c7fY\u0016DQaO\u0007\u0005\n1#2!T-b!\rqek\b\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!A\u0015\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012BA+\u0013\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\u0007M+\u0017O\u0003\u0002V%!)!j\u0013a\u00015B\u00111L\u0018\b\u0003#qK!!\u0018\n\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;JAqAY&\u0011\u0002\u0003\u00071-A\u0003jgJ+g\r\u0005\u0002\u0012I&\u0011QM\u0005\u0002\b\u0005>|G.Z1o\u0011\u00159W\u0002\"\u0003i\u00039\u0019wN\u001c<feR\fE\u000e\\3mKN$\"![9\u0011\u0007)|w$D\u0001l\u0015\taW.\u0001\u0003vi&d'\"\u00018\u0002\t)\fg/Y\u0005\u0003a.\u0014!bQ8mY\u0016\u001cG/[8o\u0011\u0015\u0011h\r1\u0001t\u0003\u00051\bC\u0001 u\u0013\t)xHA\u0004WCJL\u0017M\u001c;\t\u000b\u001dlA\u0011B<\u0015\u0005a\\\bc\u00016z?%\u0011!p\u001b\u0002\u0005\u0019&\u001cH\u000fC\u0003}m\u0002\u0007Q0A\u0001h!\tqd0\u0003\u0002\u0000\u007f\tAq)\u001a8pif\u0004X\rC\u0005\u0002\u00045\t\n\u0011\"\u0001\u0002\u0006\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!a\u0002+\t\u0005%\u00111\u0004\t\u0006#\u0005-\u0011qB\u0005\u0004\u0003\u001b\u0011\"AB(qi&|g\u000e\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002B\u0001\u0007[>$W\r\\:\n\t\u0005e\u00111\u0003\u0002\u0013'\u0016\fX/\u001a8dK\u0012K7\r^5p]\u0006\u0014\u0018p\u000b\u0002\u0002\u001eA!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!C;oG\",7m[3e\u0015\r\t9CE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0016\u0003C\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty#DI\u0001\n\u0013\t\t$A\fd_:4XM\u001d;BY2,G.\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0007\u0016\u0004G\u0006m\u0001\"CA\u001c\u001b\u0005\u0005I\u0011BA\u001d\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005S.\u0001\u0003mC:<\u0017\u0002BA#\u0003\u007f\u0011aa\u00142kK\u000e$h!\u0002\b\u0003\u0001\u0005%3CBA$!Y\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\t\u0006N\u0001\u0006gB\f'o[\u0005\u0005\u0003+\nyEA\u0004M_\u001e<\u0017N\\4\t\u0017\u0005e\u0013q\tB\u0001B\u0003%\u0011\u0011B\u0001\u0005I&\u001cG\u000fC\u0004\u001b\u0003\u000f\"\t!!\u0018\u0015\t\u0005}\u0013\u0011\r\t\u0004\u0019\u0005\u001d\u0003BCA-\u00037\u0002\n\u00111\u0001\u0002\n!Y\u0011QMA$\u0011\u000b\u0007I\u0011BA4\u00039\u0019wN\u001c;jOR{'+\u001a4TKF,\"!!\u001b\u0011\u000bm\u000bYG\u0017.\n\u0007\u00055\u0004MA\u0002NCBD1\"!\u001d\u0002H!\u0005\t\u0015)\u0003\u0002j\u0005y1m\u001c8uS\u001e$vNU3g'\u0016\f\b\u0005C\u0006\u0002v\u0005\u001d\u0003R1A\u0005\n\u0005\u001d\u0014A\u0004:fMN+\u0017\u000fV8D_:$\u0018n\u001a\u0005\f\u0003s\n9\u0005#A!B\u0013\tI'A\bsK\u001a\u001cV-\u001d+p\u0007>tG/[4!\u0011!\ti(a\u0012\u0005\u0002\u0005}\u0014aB2p]Z,'\u000f\u001e\u000b\u0005\u0003\u0003\u000b9\t\u0005\u0003O-\u0006\r\u0005\u0003BA\t\u0003\u000bK1\u0001SA\n\u0011\u0019)\u00151\u0010a\u0001\r\"A\u00111RA$\t\u0003\ti)A\nd_:4XM\u001d;U_\u0006sgn\u001c;bi&|g\u000e\u0006\u0003\u0002\u0010\u0006U\u0005c\u0001 \u0002\u0012&\u0019\u00111S \u00033\u0011\u000bG/\u00192bg\u00164\u0016M]5b]R\feN\\8uCRLwN\u001c\u0005\u0007\u000b\u0006%\u0005\u0019\u0001$\t\u0011\u0005e\u0015q\tC\u0005\u00037\u000bAb\u0019:fCR,7i\u001c8uS\u001e$B!!(\u0002$B\u0019a(a(\n\u0007\u0005\u0005vH\u0001\u0004D_:$\u0018n\u001a\u0005\u0007\u000b\u0006]\u0005\u0019\u0001$\t\u0011\u0005\u001d\u0016q\tC\u0005\u0003S\u000b\u0011c\u0019:fCR,\u0017\tR!N-\u0006\u0014\u0018.\u00198u)\u0015\u0019\u00181VAW\u0011\u0019)\u0015Q\u0015a\u0001\r\"A\u0011qVAS\u0001\u0004\t\t,A\u0002bYR\u0004B!EA\u00065\"A\u0011QWA$\t\u0013\t9,\u0001\u0011fqR\u0014\u0018m\u0019;WCJL\u0017M\u001c;ECR\f'-Y:f\u0003:tw\u000e^1uS>tGCBAH\u0003s\u000bY\f\u0003\u0004%\u0003g\u0003\ra\u001d\u0005\u0007\u000b\u0006M\u0006\u0019\u0001$\t\u0011\u0005}\u0016q\tC\u0005\u0003\u0003\f\u0001#\u001a=ue\u0006\u001cGoR3o_RL\b/Z:\u0015\u0015\u0005\r\u0017QYAd\u0003\u0013\f\u0019\u000eE\u0002O-vDa!RA_\u0001\u00041\u0005B\u0002\u0013\u0002>\u0002\u00071\u000f\u0003\u0005\u0002L\u0006u\u0006\u0019AAg\u0003-\tgN\\8uCRLwN\\:\u0011\u0007y\ny-C\u0002\u0002R~\u0012\u0011DV1sS\u0006tGoQ1mY&tw-\u00118o_R\fG/[8og\"A\u0011Q[A_\u0001\u0004\t9.A\u0003tKR\u0004F\nE\u0005\u0012\u00033\fi.!9\u0002p&\u0019\u00111\u001c\n\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004c\u0001\u0011\u0002`&\u0011q0\t\t\u0005\u0003G\fIOD\u0002?\u0003KL1!a:@\u0003!9UM\\8usB,\u0017\u0002BAv\u0003[\u0014qAQ;jY\u0012,'OC\u0002\u0002h~\u00022!EAy\u0013\r\t\u0019P\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002x\u0006\u001dC\u0011BA}\u0003q)\u0007\u0010\u001e:bGRtuN\u001c*fM\u0016\u0014XM\\2f\u000f\u0016tw\u000e^=qKN$\u0002\"a1\u0002|\u0006u\u0018q \u0005\u0007\u000b\u0006U\b\u0019\u0001$\t\r\u0011\n)\u00101\u0001t\u0011!\tY-!>A\u0002\u00055\u0007\u0002\u0003B\u0002\u0003\u000f\"IA!\u0002\u00023\u0015DHO]1diJ+g-\u001a:f]\u000e,w)\u001a8pif\u0004Xm\u001d\u000b\t\u0003\u0007\u00149A!\u0003\u0003\f!1QI!\u0001A\u0002\u0019Ca\u0001\nB\u0001\u0001\u0004\u0019\b\u0002CAf\u0005\u0003\u0001\r!!4\t\u0011\t=\u0011q\tC\u0005\u0005#\ta$\u001a=ue\u0006\u001cGOU3gKJ,gnY3N_\u0012,GnR3o_RL\b/Z:\u0015\u0011\u0005\r'1\u0003B\u000b\u0005/Aa!\u0012B\u0007\u0001\u00041\u0005B\u0002\u0013\u0003\u000e\u0001\u00071\u000f\u0003\u0005\u0002L\n5\u0001\u0019AAg\u0011!\u0011Y\"a\u0012\u0005\n\tu\u0011\u0001I3yiJ\f7\r\u001e,be&\fg\u000e^\"bY2LgnZ!o]>$\u0018\r^5p]N$B!!4\u0003 !1QI!\u0007A\u0002\u0019C\u0001\"! \u0002H\u0011\u0005!1\u0005\u000b\u0004\r\n\u0015\u0002bB#\u0003\"\u0001\u0007\u00111\u0011")
public class VariantContextConverter
implements Serializable,
Logging {
    private final Option<SequenceDictionary> dict;
    private Map<String, String> contigToRefSeq;
    private Map<String, String> refSeqToContig;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<SequenceDictionary> $lessinit$greater$default$1() {
        return VariantContextConverter$.MODULE$.$lessinit$greater$default$1();
    }

    private Map contigToRefSeq$lzycompute() {
        VariantContextConverter variantContextConverter = this;
        synchronized (variantContextConverter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Map map;
                Option<SequenceDictionary> option = this.dict;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SequenceDictionary d = (SequenceDictionary)some.x();
                    map = ((TraversableOnce)((TraversableLike)d.records().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(SequenceRecord x$1) {
                            return x$1.refseq().isDefined();
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, String> apply(SequenceRecord r) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)r.name()), r.refseq().get());
                        }
                    }, Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                } else {
                    map = Predef$.MODULE$.Map().empty();
                }
                this.contigToRefSeq = map;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.contigToRefSeq;
        }
    }

    private Map refSeqToContig$lzycompute() {
        VariantContextConverter variantContextConverter = this;
        synchronized (variantContextConverter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Map map;
                Option<SequenceDictionary> option = this.dict;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SequenceDictionary d = (SequenceDictionary)some.x();
                    map = ((TraversableOnce)((TraversableLike)d.records().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(SequenceRecord x$2) {
                            return x$2.refseq().isDefined();
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, String> apply(SequenceRecord r) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(r.refseq().get()), (Object)r.name());
                        }
                    }, Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                } else {
                    map = Predef$.MODULE$.Map().empty();
                }
                this.refSeqToContig = map;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.refSeqToContig;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private Map<String, String> contigToRefSeq() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.contigToRefSeq$lzycompute() : this.contigToRefSeq;
    }

    private Map<String, String> refSeqToContig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.refSeqToContig$lzycompute() : this.refSeqToContig;
    }

    public Seq<org.bdgenomics.adam.models.VariantContext> convert(VariantContext vc) {
        Option option;
        Some some;
        ObjectRef calling_annotations$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        List list = JavaConversions$.MODULE$.asScalaBuffer(vc.getAlternateAlleles()).toList();
        Some some2 = List$.MODULE$.unapplySeq((Seq)list);
        if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
            Allele allele = (Allele)((LinearSeqOptimized)some2.get()).apply(0);
            Allele allele2 = VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$NON_REF_ALLELE();
            Allele allele3 = allele;
            if (!(allele2 != null ? !allele2.equals(allele3) : allele3 != null)) {
                Variant variant = this.createADAMVariant(vc, (Option<String>)None$.MODULE$);
                Seq<Genotype> genotypes = this.extractReferenceGenotypes(vc, variant, this.calling_annotations$1(vc, calling_annotations$lzy, bitmap$0));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new org.bdgenomics.adam.models.VariantContext[]{VariantContext$.MODULE$.apply(variant, (Iterable<Genotype>)genotypes, (Option<DatabaseVariantAnnotation>)None$.MODULE$)}));
            }
        }
        if (!(some = List$.MODULE$.unapplySeq((Seq)list)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
            Allele allele = (Allele)((LinearSeqOptimized)some.get()).apply(0);
            Predef$.MODULE$.assert(allele.isNonReference(), (Function0)new Serializable(this, vc){
                public static final long serialVersionUID = 0L;
                private final VariantContext vc$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Assertion failed when converting: ").append((Object)this.vc$1.toString()).toString();
                }
                {
                    this.vc$1 = vc$1;
                }
            });
            Variant variant = this.createADAMVariant(vc, (Option<String>)new Some((Object)allele.getDisplayString()));
            Seq<Genotype> genotypes = this.extractReferenceModelGenotypes(vc, variant, this.calling_annotations$1(vc, calling_annotations$lzy, bitmap$0));
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new org.bdgenomics.adam.models.VariantContext[]{VariantContext$.MODULE$.apply(variant, (Iterable<Genotype>)genotypes, (Option<DatabaseVariantAnnotation>)None$.MODULE$)}));
        }
        Some some3 = List$.MODULE$.unapplySeq((Seq)list);
        if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(2) == 0) {
            Allele allele = (Allele)((LinearSeqOptimized)some3.get()).apply(0);
            Allele allele4 = (Allele)((LinearSeqOptimized)some3.get()).apply(1);
            Allele allele5 = VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$NON_REF_ALLELE();
            Allele allele6 = allele4;
            if (!(allele5 != null ? !allele5.equals(allele6) : allele6 != null)) {
                Predef$.MODULE$.assert(allele.isNonReference(), (Function0)new Serializable(this, vc){
                    public static final long serialVersionUID = 0L;
                    private final VariantContext vc$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Assertion failed when converting: ").append((Object)this.vc$1.toString()).toString();
                    }
                    {
                        this.vc$1 = vc$1;
                    }
                });
                Variant variant = this.createADAMVariant(vc, (Option<String>)new Some((Object)allele.getDisplayString()));
                Seq<Genotype> genotypes = this.extractReferenceModelGenotypes(vc, variant, this.calling_annotations$1(vc, calling_annotations$lzy, bitmap$0));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new org.bdgenomics.adam.models.VariantContext[]{VariantContext$.MODULE$.apply(variant, (Iterable<Genotype>)genotypes, (Option<DatabaseVariantAnnotation>)None$.MODULE$)}));
            }
        }
        if (!(option = package$.MODULE$.$colon$plus().unapply((SeqLike)list)).isEmpty()) {
            Allele allele = (Allele)((Tuple2)option.get())._2();
            Allele allele7 = VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$NON_REF_ALLELE();
            Allele allele8 = allele;
            if (!(allele7 != null ? !allele7.equals(allele8) : allele8 != null)) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Multi-allelic site with non-ref symbolic allele").append((Object)vc.toString()).toString());
            }
        }
        VariantContextBuilder vcb = new VariantContextBuilder(vc);
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(vc.getAlternateAlleles()).flatMap((Function1)new Serializable(this, vc, vcb){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverter $outer;
            public final VariantContext vc$1;
            private final VariantContextBuilder vcb$1;

            public final Seq<org.bdgenomics.adam.models.VariantContext> apply(Allele allele) {
                int idx = this.vc$1.getAlleleIndex(allele);
                Predef$.MODULE$.assert(idx >= 1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$convert$3 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unexpected index for alternate allele: ").append((Object)this.$outer.vc$1.toString()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.vcb$1.alleles((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{this.vc$1.getReference(), allele, VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$NON_REF_ALLELE()}))));
                GenotypesContext gc = GenotypesContext.create();
                gc.addAll((Collection)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)this.vc$1.getGenotypes()).map((Function1)new Serializable(this, idx){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$convert$3 $outer;
                    private final int idx$1;

                    public final htsjdk.variant.variantcontext.Genotype apply(htsjdk.variant.variantcontext.Genotype x$6) {
                        return this.$outer.org$bdgenomics$adam$converters$VariantContextConverter$$anonfun$$punchOutGenotype$1(x$6, this.idx$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.idx$1 = idx$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())));
                this.vcb$1.genotypesNoValidation(gc);
                Seq<org.bdgenomics.adam.models.VariantContext> adamVCs = this.$outer.convert(this.vcb$1.make());
                ((IterableLike)adamVCs.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Genotype> apply(org.bdgenomics.adam.models.VariantContext x$7) {
                        return x$7.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Genotype g) {
                        g.put(VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$splitFromMultiAllelicField().pos(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                });
                return adamVCs;
            }

            public final htsjdk.variant.variantcontext.Genotype org$bdgenomics$adam$converters$VariantContextConverter$$anonfun$$punchOutGenotype$1(htsjdk.variant.variantcontext.Genotype g, int idx) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                GenotypeBuilder gb = new GenotypeBuilder(g);
                gb.phased(true);
                if (g.hasAD()) {
                    int[] ad = g.getAD();
                    boxedUnit2 = gb.AD(new int[]{ad[0], ad[idx]});
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (g.hasPL()) {
                    int[] oldPLs = g.getPL();
                    int maxIdx = oldPLs.length;
                    int[] newPLs = (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(GenotypeLikelihoods.getPLIndecesOfAlleles((int)0, (int)idx)).filter((Function1)new Serializable(this, maxIdx){
                        public static final long serialVersionUID = 0L;
                        private final int maxIdx$1;

                        public final boolean apply(int x$3) {
                            return this.apply$mcZI$sp(x$3);
                        }

                        public boolean apply$mcZI$sp(int x$3) {
                            return x$3 < this.maxIdx$1;
                        }
                        {
                            this.maxIdx$1 = maxIdx$1;
                        }
                    })).map((Function1)new Serializable(this, oldPLs){
                        public static final long serialVersionUID = 0L;
                        private final int[] oldPLs$1;

                        public final int apply(int x$4) {
                            return this.apply$mcII$sp(x$4);
                        }

                        public int apply$mcII$sp(int x$4) {
                            return this.oldPLs$1[x$4];
                        }
                        {
                            this.oldPLs$1 = oldPLs$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    boxedUnit = gb.PL((int[])Predef$.MODULE$.intArrayOps(newPLs).map((Function1)new Serializable(this, newPLs){
                        public static final long serialVersionUID = 0L;
                        private final int[] newPLs$1;

                        public final int apply(int x$5) {
                            return this.apply$mcII$sp(x$5);
                        }

                        public int apply$mcII$sp(int x$5) {
                            return x$5 - BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(this.newPLs$1).min((Ordering)Ordering.Int$.MODULE$));
                        }
                        {
                            this.newPLs$1 = newPLs$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return gb.make();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.vc$1 = vc$1;
                this.vcb$1 = vcb$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public DatabaseVariantAnnotation convertToAnnotation(VariantContext vc) {
        Predef$.MODULE$.assert(false, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "TODO";
            }
        });
        return new DatabaseVariantAnnotation();
    }

    private Contig createContig(VariantContext vc) {
        String contigName = (String)this.contigToRefSeq().getOrElse((Object)vc.getChr(), (Function0)new Serializable(this, vc){
            public static final long serialVersionUID = 0L;
            private final VariantContext vc$2;

            public final String apply() {
                return this.vc$2.getChr();
            }
            {
                this.vc$2 = vc$2;
            }
        });
        return Contig.newBuilder().setContigName(contigName).build();
    }

    private Variant createADAMVariant(VariantContext vc, Option<String> alt) {
        Variant.Builder builder = Variant.newBuilder().setContig(this.createContig(vc)).setStart(Predef$.MODULE$.long2Long((long)(vc.getStart() - 1))).setEnd(Predef$.MODULE$.long2Long((long)vc.getEnd())).setReferenceAllele(vc.getReference().getBaseString());
        alt.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final Variant.Builder builder$1;

            public final Variant.Builder apply(String x$8) {
                return this.builder$1.setAlternateAllele(x$8);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    private DatabaseVariantAnnotation extractVariantDatabaseAnnotation(Variant variant, VariantContext vc) {
        DatabaseVariantAnnotation annotation = DatabaseVariantAnnotation.newBuilder().setVariant(variant).build();
        return VariantAnnotationConverter$.MODULE$.convert(vc, annotation);
    }

    private Seq<Genotype> extractGenotypes(VariantContext vc, Variant variant, VariantCallingAnnotations annotations, Function2<htsjdk.variant.variantcontext.Genotype, Genotype.Builder, BoxedUnit> setPL) {
        Seq genotypes = ((SeqLike)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)vc.getGenotypes()).map((Function1)new Serializable(this, vc, variant, annotations, setPL){
            public static final long serialVersionUID = 0L;
            public final VariantContext vc$3;
            private final Variant variant$1;
            private final VariantCallingAnnotations annotations$1;
            private final Function2 setPL$1;

            public final Genotype apply(htsjdk.variant.variantcontext.Genotype g) {
                BoxedUnit boxedUnit;
                Genotype.Builder genotype = Genotype.newBuilder().setVariant(this.variant$1).setVariantCallingAnnotations(this.annotations$1).setSampleId(g.getSampleName()).setAlleles(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(g.getAlleles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final GenotypeAllele apply(Allele x$9) {
                        return VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAllele(this.$outer.vc$3, x$9);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Buffer$.MODULE$.canBuildFrom()))).setIsPhased(Predef$.MODULE$.boolean2Boolean(g.isPhased()));
                Object object = g.hasGQ() ? genotype.setGenotypeQuality(Predef$.MODULE$.int2Integer(g.getGQ())) : BoxedUnit.UNIT;
                Object object2 = g.hasDP() ? genotype.setReadDepth(Predef$.MODULE$.int2Integer(g.getDP())) : BoxedUnit.UNIT;
                if (g.hasAD()) {
                    int[] ad = g.getAD();
                    boxedUnit = genotype.setReferenceReadDepth(Predef$.MODULE$.int2Integer(ad[0])).setAlternateReadDepth(Predef$.MODULE$.int2Integer(ad[1]));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.setPL$1.apply((Object)g, (Object)genotype);
                return VariantAnnotationConverter$.MODULE$.convert(g, genotype.build());
            }
            {
                this.vc$3 = vc$3;
                this.variant$1 = variant$1;
                this.annotations$1 = annotations$1;
                this.setPL$1 = setPL$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
        return genotypes;
    }

    private Seq<Genotype> extractNonReferenceGenotypes(VariantContext vc, Variant variant, VariantCallingAnnotations annotations) {
        Predef$.MODULE$.assert(vc.isBiallelic());
        return this.extractGenotypes(vc, variant, annotations, (Function2<htsjdk.variant.variantcontext.Genotype, Genotype.Builder, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(htsjdk.variant.variantcontext.Genotype g, Genotype.Builder b) {
                if (g.hasPL()) {
                    b.setGenotypeLikelihoods(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.intArrayOps(g.getPL()).toList().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Integer apply(int p) {
                            return Predef$.MODULE$.int2Integer(p);
                        }
                    }, List$.MODULE$.canBuildFrom())));
                }
            }
        });
    }

    private Seq<Genotype> extractReferenceGenotypes(VariantContext vc, Variant variant, VariantCallingAnnotations annotations) {
        Predef$.MODULE$.assert(vc.isBiallelic());
        return this.extractGenotypes(vc, variant, annotations, (Function2<htsjdk.variant.variantcontext.Genotype, Genotype.Builder, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(htsjdk.variant.variantcontext.Genotype g, Genotype.Builder b) {
                if (g.hasPL()) {
                    b.setNonReferenceLikelihoods(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.intArrayOps(g.getPL()).toList().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Integer apply(int p) {
                            return Predef$.MODULE$.int2Integer(p);
                        }
                    }, List$.MODULE$.canBuildFrom())));
                }
            }
        });
    }

    private Seq<Genotype> extractReferenceModelGenotypes(VariantContext vc, Variant variant, VariantCallingAnnotations annotations) {
        return this.extractGenotypes(vc, variant, annotations, (Function2<htsjdk.variant.variantcontext.Genotype, Genotype.Builder, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(htsjdk.variant.variantcontext.Genotype g, Genotype.Builder b) {
                if (g.hasPL()) {
                    int n;
                    Integer[] pls = (Integer[])Predef$.MODULE$.intArrayOps(g.getPL()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Integer apply(int p) {
                            return Predef$.MODULE$.int2Integer(p);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class)));
                    int n2 = g.getPloidy();
                    switch (n2) {
                        default: {
                            Predef$.MODULE$.assert(false, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Ploidy > 2 not supported for this operation";
                                }
                            });
                            n = 0;
                            break;
                        }
                        case 2: {
                            n = 3;
                            break;
                        }
                        case 1: {
                            n = 2;
                        }
                    }
                    int splitAt = n;
                    b.setGenotypeLikelihoods(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pls).slice(0, splitAt)).toList()));
                    b.setNonReferenceLikelihoods(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pls).slice(splitAt, pls.length)).toList()));
                }
            }
        });
    }

    private VariantCallingAnnotations extractVariantCallingAnnotations(VariantContext vc) {
        VariantCallingAnnotations.Builder call = VariantCallingAnnotations.newBuilder();
        Object object = vc.hasLog10PError() ? call.setVariantCallErrorProbability(Predef$.MODULE$.float2Float((float)vc.getPhredScaledQual())) : BoxedUnit.UNIT;
        Object object2 = vc.filtersWereApplied() && vc.isFiltered() ? call.setVariantIsPassing(Predef$.MODULE$.boolean2Boolean(false)).setVariantFilters(new ArrayList(vc.getFilters())) : (vc.filtersWereApplied() ? call.setVariantIsPassing(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT);
        return VariantAnnotationConverter$.MODULE$.convert(vc, call.build());
    }

    public VariantContext convert(org.bdgenomics.adam.models.VariantContext vc) {
        Variant variant = RichVariant$.MODULE$.richVariantToVariant(vc.variant());
        VariantContextBuilder vcb = new VariantContextBuilder().chr((String)this.refSeqToContig().getOrElse((Object)variant.getContig().getContigName().toString(), (Function0)new Serializable(this, variant){
            public static final long serialVersionUID = 0L;
            private final Variant variant$2;

            public final String apply() {
                return this.variant$2.getContig().getContigName().toString();
            }
            {
                this.variant$2 = variant$2;
            }
        })).start(Predef$.MODULE$.Long2long(variant.getStart()) + 1L).stop(Predef$.MODULE$.Long2long(variant.getStart()) + (long)variant.getReferenceAllele().length()).alleles(VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAlleles(variant));
        vc.databases().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Integer> apply(DatabaseVariantAnnotation d) {
                return Option$.MODULE$.apply((Object)d.getDbSnpId());
            }
        }).foreach((Function1)new Serializable(this, vcb){
            public static final long serialVersionUID = 0L;
            private final VariantContextBuilder vcb$2;

            public final VariantContextBuilder apply(Integer d) {
                return this.vcb$2.id(new StringBuilder().append((Object)"rs").append((Object)d).toString());
            }
            {
                this.vcb$2 = vcb$2;
            }
        });
        try {
            vcb.genotypes(JavaConversions$.MODULE$.asJavaCollection((Iterable)vc.genotypes().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final htsjdk.variant.variantcontext.Genotype apply(Genotype g) {
                    VariantCallingAnnotations callAnnotations;
                    GenotypeBuilder gb = new GenotypeBuilder(g.getSampleId().toString(), VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAlleles(g));
                    Option$.MODULE$.apply((Object)g.getIsPhased()).foreach((Function1)new Serializable(this, gb){
                        public static final long serialVersionUID = 0L;
                        private final GenotypeBuilder gb$1;

                        public final GenotypeBuilder apply(Boolean x$10) {
                            return this.gb$1.phased(Predef$.MODULE$.Boolean2boolean(x$10));
                        }
                        {
                            this.gb$1 = gb$1;
                        }
                    });
                    Option$.MODULE$.apply((Object)g.getGenotypeQuality()).foreach((Function1)new Serializable(this, gb){
                        public static final long serialVersionUID = 0L;
                        private final GenotypeBuilder gb$1;

                        public final GenotypeBuilder apply(Integer x$11) {
                            return this.gb$1.GQ(Predef$.MODULE$.Integer2int(x$11));
                        }
                        {
                            this.gb$1 = gb$1;
                        }
                    });
                    Option$.MODULE$.apply((Object)g.getReadDepth()).foreach((Function1)new Serializable(this, gb){
                        public static final long serialVersionUID = 0L;
                        private final GenotypeBuilder gb$1;

                        public final GenotypeBuilder apply(Integer x$12) {
                            return this.gb$1.DP(Predef$.MODULE$.Integer2int(x$12));
                        }
                        {
                            this.gb$1 = gb$1;
                        }
                    });
                    Object object = g.getReferenceReadDepth() == null || g.getAlternateReadDepth() == null ? BoxedUnit.UNIT : gb.AD((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Predef$.MODULE$.Integer2int(g.getReferenceReadDepth()), Predef$.MODULE$.Integer2int(g.getAlternateReadDepth())}), ClassTag$.MODULE$.Int()));
                    Object object2 = g.getVariantCallingAnnotations() == null ? BoxedUnit.UNIT : ((callAnnotations = g.getVariantCallingAnnotations()).getVariantFilters() == null ? BoxedUnit.UNIT : gb.filters(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(callAnnotations.getVariantFilters()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x$13) {
                            return x$13.toString();
                        }
                    }, Buffer$.MODULE$.canBuildFrom()))));
                    Object object3 = g.getGenotypeLikelihoods() == null || g.getGenotypeLikelihoods().isEmpty() ? BoxedUnit.UNIT : gb.PL((int[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(g.getGenotypeLikelihoods()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Integer p) {
                            return Predef$.MODULE$.Integer2int(p);
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()));
                    return gb.make();
                }
            }, Iterable$.MODULE$.canBuildFrom())));
            return vcb.make();
        }
        catch (Throwable throwable) {
            this.log().error(new StringBuilder().append((Object)"Encountered error when converting variant context with variant: \n").append((Object)vc.variant().variant()).append((Object)"\n").append((Object)"and genotypes: \n").append((Object)vc.genotypes().mkString("\n")).toString());
            throw throwable;
        }
    }

    private final VariantCallingAnnotations calling_annotations$lzycompute$1(VariantContext vc$1, ObjectRef calling_annotations$lzy$1, VolatileByteRef bitmap$0$1) {
        VariantContextConverter variantContextConverter = this;
        synchronized (variantContextConverter) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                calling_annotations$lzy$1.elem = this.extractVariantCallingAnnotations(vc$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (VariantCallingAnnotations)calling_annotations$lzy$1.elem;
        }
    }

    private final VariantCallingAnnotations calling_annotations$1(VariantContext vc$1, ObjectRef calling_annotations$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.calling_annotations$lzycompute$1(vc$1, calling_annotations$lzy$1, bitmap$0$1) : (VariantCallingAnnotations)calling_annotations$lzy$1.elem;
    }

    public VariantContextConverter(Option<SequenceDictionary> dict) {
        this.dict = dict;
        Logging.class.$init$((Logging)this);
    }
}

