/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.ReferenceMapping;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.rdd.GenomeBins;
import org.bdgenomics.adam.rdd.ManualRegionPartitioner;
import org.bdgenomics.adam.rdd.SortedIntervalPartitionJoin;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ShuffleRegionJoin$ {
    public static final ShuffleRegionJoin$ MODULE$;

    static {
        new ShuffleRegionJoin$();
    }

    public <T, U> RDD<Tuple2<T, U>> partitionAndJoin(SparkContext sc, RDD<T> leftRDD, RDD<U> rightRDD, SequenceDictionary seqDict, long partitionSize, ReferenceMapping<T> tMapping, ReferenceMapping<U> uMapping, ClassTag<T> tManifest, ClassTag<U> uManifest) {
        Map seqLengths = (Map)Predef$.MODULE$.Map().apply((Seq)seqDict.records().toSeq().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(SequenceRecord rec) {
                return new Tuple2((Object)rec.name().toString(), (Object)BoxesRunTime.boxToLong((long)rec.length()));
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Broadcast bins = sc.broadcast((Object)new GenomeBins(partitionSize, (Map<String, Object>)seqLengths), ClassTag$.MODULE$.apply(GenomeBins.class));
        RDD keyedLeft = leftRDD.flatMap((Function1)new Serializable(tMapping, bins){
            public static final long serialVersionUID = 0L;
            private final ReferenceMapping tMapping$1;
            private final Broadcast bins$1;

            public final TraversableOnce<Tuple2<Tuple2<ReferenceRegion, Object>, T>> apply(T x) {
                ReferenceRegion region2 = this.tMapping$1.getReferenceRegion(x);
                int lo = ((GenomeBins)this.bins$1.value()).getStartBin(region2);
                int hi = ((GenomeBins)this.bins$1.value()).getEndBin(region2);
                return (TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(lo), hi).map((Function1)new Serializable(this, x, region2){
                    public static final long serialVersionUID = 0L;
                    private final Object x$9;
                    private final ReferenceRegion region$1;

                    public final Tuple2<Tuple2<ReferenceRegion, Object>, T> apply(int i) {
                        return new Tuple2((Object)new Tuple2((Object)this.region$1, (Object)BoxesRunTime.boxToInteger((int)i)), this.x$9);
                    }
                    {
                        this.x$9 = x$9;
                        this.region$1 = region$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.tMapping$1 = tMapping$1;
                this.bins$1 = bins$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD keyedRight = rightRDD.flatMap((Function1)new Serializable(uMapping, bins){
            public static final long serialVersionUID = 0L;
            private final ReferenceMapping uMapping$1;
            private final Broadcast bins$1;

            public final TraversableOnce<Tuple2<Tuple2<ReferenceRegion, Object>, U>> apply(U y) {
                ReferenceRegion region2 = this.uMapping$1.getReferenceRegion(y);
                int lo = ((GenomeBins)this.bins$1.value()).getStartBin(region2);
                int hi = ((GenomeBins)this.bins$1.value()).getEndBin(region2);
                return (TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(lo), hi).map((Function1)new Serializable(this, y, region2){
                    public static final long serialVersionUID = 0L;
                    private final Object y$1;
                    private final ReferenceRegion region$2;

                    public final Tuple2<Tuple2<ReferenceRegion, Object>, U> apply(int i) {
                        return new Tuple2((Object)new Tuple2((Object)this.region$2, (Object)BoxesRunTime.boxToInteger((int)i)), this.y$1);
                    }
                    {
                        this.y$1 = y$1;
                        this.region$2 = region$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.uMapping$1 = uMapping$1;
                this.bins$1 = bins$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD sortedLeft = SparkContext$.MODULE$.rddToOrderedRDDFunctions(keyedLeft, Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), (Ordering)Ordering.Int$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class), tManifest).repartitionAndSortWithinPartitions((Partitioner)new ManualRegionPartitioner(((GenomeBins)bins.value()).numBins()));
        RDD sortedRight = SparkContext$.MODULE$.rddToOrderedRDDFunctions(keyedRight, Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), (Ordering)Ordering.Int$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class), uManifest).repartitionAndSortWithinPartitions((Partitioner)new ManualRegionPartitioner(((GenomeBins)bins.value()).numBins()));
        return sortedLeft.zipPartitions(sortedRight, false, (Function2)new Serializable(bins){
            public static final long serialVersionUID = 0L;
            private final Broadcast bins$1;

            public final Iterator<Tuple2<T, U>> apply(Iterator<Tuple2<Tuple2<ReferenceRegion, Object>, T>> leftIter, Iterator<Tuple2<Tuple2<ReferenceRegion, Object>, U>> rightIter) {
                return ShuffleRegionJoin$.MODULE$.org$bdgenomics$adam$rdd$ShuffleRegionJoin$$sweep$1(leftIter, rightIter, this.bins$1);
            }
            {
                this.bins$1 = bins$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public final Iterator org$bdgenomics$adam$rdd$ShuffleRegionJoin$$sweep$1(Iterator leftIter, Iterator rightIter, Broadcast bins$1) {
        Iterator iterator;
        if (leftIter.isEmpty() || rightIter.isEmpty()) {
            iterator = ((IterableLike)scala.collection.Seq$.MODULE$.empty()).toIterator();
        } else {
            BufferedIterator bufferedLeft = leftIter.buffered();
            int currentBin = ((Tuple2)((Tuple2)bufferedLeft.head())._1())._2$mcI$sp();
            ReferenceRegion region2 = ((GenomeBins)bins$1.value()).invert(currentBin);
            iterator = new SortedIntervalPartitionJoin(region2, bufferedLeft, rightIter);
        }
        return iterator;
    }

    private ShuffleRegionJoin$() {
        MODULE$ = this;
    }
}

