/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read.correction;

import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.rdd.read.correction.TrimReads;
import org.bdgenomics.adam.rdd.read.correction.TrimReads$;
import org.bdgenomics.adam.util.PhredUtils$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class TrimReads$
implements Logging,
Serializable {
    public static final TrimReads$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new TrimReads$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rdd, int phredThreshold) {
        TrimReads tr = new TrimReads();
        int readLength = ((AlignmentRecord)rdd.first()).getSequence().length();
        this.log().info("Collecting read quality scores.");
        RDD doubleRdd = rdd.flatMap((Function1)new Serializable(tr){
            public static final long serialVersionUID = 0L;
            private final TrimReads tr$1;

            public final ArrayOps<Tuple2<Tuple2<String, Object>, Object>> apply(AlignmentRecord read) {
                return Predef$.MODULE$.refArrayOps((Object[])this.tr$1.readToDoubles(read));
            }
            {
                this.tr$1 = tr$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
        this.log().info("Summarizing quality scores.");
        Map columnValues = SparkContext$.MODULE$.rddToPairRDDFunctions(doubleRdd, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKeyLocally((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$1, double x$2) {
                return this.apply$mcDDD$sp(x$1, x$2);
            }

            public double apply$mcDDD$sp(double x$1, double x$2) {
                return x$1 + x$2;
            }
        });
        Map columnCounts = SparkContext$.MODULE$.rddToPairRDDFunctions(doubleRdd, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).countByKey();
        doubleRdd.unpersist(doubleRdd.unpersist$default$1());
        Set rgIds = ((TraversableOnce)columnValues.keys().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> p) {
                return (String)p._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        ObjectRef loopRdd = new ObjectRef(rdd);
        rgIds.foreach((Function1)new Serializable(phredThreshold, columnValues, columnCounts, loopRdd){
            public static final long serialVersionUID = 0L;
            public final int phredThreshold$1;
            private final Map columnValues$1;
            private final Map columnCounts$1;
            private final ObjectRef loopRdd$1;

            public final void apply(String rg) {
                Seq qualities = (Seq)((MapLike)this.columnValues$1.filterKeys((Function1)new Serializable(this, rg){
                    public static final long serialVersionUID = 0L;
                    private final String rg$2;

                    public final boolean apply(Tuple2<String, Object> k) {
                        Object object = k._1();
                        String string = this.rg$2;
                        return !(object != null ? !object.equals(string) : string != null);
                    }
                    {
                        this.rg$2 = rg$2;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple2<Tuple2<String, Object>, Object> kv) {
                        return new Tuple2.mcID.sp(((Tuple2)kv._1())._2$mcI$sp(), kv._2$mcD$sp());
                    }
                }, Map$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> kv) {
                        return kv._1$mcI$sp();
                    }
                }, (Ordering)Ordering.Int$.MODULE$);
                Seq counts = (Seq)((MapLike)this.columnCounts$1.filterKeys((Function1)new Serializable(this, rg){
                    public static final long serialVersionUID = 0L;
                    private final String rg$2;

                    public final boolean apply(Tuple2<String, Object> k) {
                        Object object = k._1();
                        String string = this.rg$2;
                        return !(object != null ? !object.equals(string) : string != null);
                    }
                    {
                        this.rg$2 = rg$2;
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple2<Tuple2<String, Object>, Object> kv) {
                        return new Tuple2.mcIJ.sp(((Tuple2)kv._1())._2$mcI$sp(), kv._2$mcJ$sp());
                    }
                }, Map$.MODULE$.canBuildFrom())).toSeq().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> kv) {
                        return kv._1$mcI$sp();
                    }
                }, (Ordering)Ordering.Int$.MODULE$);
                Seq meanQuals = (Seq)((TraversableLike)qualities.zip((GenIterable)counts, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> qc) {
                        Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple2 = qc;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            Tuple2 tuple23 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                int p1 = tuple22._1$mcI$sp();
                                double qual = tuple22._2$mcD$sp();
                                if (tuple23 != null) {
                                    Tuple4 tuple4;
                                    int p2 = tuple23._1$mcI$sp();
                                    long count = tuple23._2$mcJ$sp();
                                    Tuple4 tuple42 = tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)p1), (Object)BoxesRunTime.boxToDouble((double)qual), (Object)BoxesRunTime.boxToInteger((int)p2), (Object)BoxesRunTime.boxToLong((long)count));
                                    int p12 = BoxesRunTime.unboxToInt((Object)tuple42._1());
                                    double qual2 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
                                    int p22 = BoxesRunTime.unboxToInt((Object)tuple42._3());
                                    long count2 = BoxesRunTime.unboxToLong((Object)tuple42._4());
                                    Predef$.MODULE$.assert(p12 == p22, (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "During zip, value ranks disagree.";
                                        }
                                    });
                                    return PhredUtils$.MODULE$.successProbabilityToPhred(package$.MODULE$.exp(qual2 / (double)count2));
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                int trimStart = ((SeqLike)meanQuals.takeWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.apply.1 $outer;

                    public final boolean apply(int x$4) {
                        return this.apply$mcZI$sp(x$4);
                    }

                    public boolean apply$mcZI$sp(int x$4) {
                        return x$4 < this.$outer.phredThreshold$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).length();
                int trimEnd = ((SeqLike)((IterableLike)meanQuals.reverse()).takeWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.apply.1 $outer;

                    public final boolean apply(int x$5) {
                        return this.apply$mcZI$sp(x$5);
                    }

                    public boolean apply$mcZI$sp(int x$5) {
                        return x$5 < this.$outer.phredThreshold$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).length();
                this.loopRdd$1.elem = TrimReads$.MODULE$.apply((RDD<AlignmentRecord>)((RDD)this.loopRdd$1.elem), trimStart, trimEnd, rg);
            }
            {
                this.phredThreshold$1 = phredThreshold$1;
                this.columnValues$1 = columnValues$1;
                this.columnCounts$1 = columnCounts$1;
                this.loopRdd$1 = loopRdd$1;
            }
        });
        return (RDD)loopRdd.elem;
    }

    public RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rdd, int trimStart, int trimEnd, String rg) {
        Predef$.MODULE$.assert(trimStart >= 0 && trimEnd >= 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Trim parameters must be positive.";
            }
        });
        Predef$.MODULE$.assert(((AlignmentRecord)rdd.first()).getSequence().length() > trimStart + trimEnd, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot trim more than the length of the read.";
            }
        });
        this.log().info("Trimming reads.");
        TrimReads tr = new TrimReads();
        return rdd.map((Function1)new Serializable(trimStart, trimEnd, rg, tr){
            public static final long serialVersionUID = 0L;
            private final int trimStart$1;
            private final int trimEnd$1;
            private final String rg$1;
            private final TrimReads tr$2;

            public final AlignmentRecord apply(AlignmentRecord read) {
                String string = read.getRecordGroupName();
                String string2 = this.rg$1;
                return !(string == null ? string2 != null : !string.equals(string2)) || this.rg$1 == null ? this.tr$2.trimRead(read, this.trimStart$1, this.trimEnd$1) : read;
            }
            {
                this.trimStart$1 = trimStart$1;
                this.trimEnd$1 = trimEnd$1;
                this.rg$1 = rg$1;
                this.tr$2 = tr$2;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public String apply$default$4() {
        return null;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TrimReads$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

