/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.variation;

import org.bdgenomics.adam.rdd.variation.GenotypesSummary;
import org.bdgenomics.adam.rdd.variation.GenotypesSummaryCounts;
import org.bdgenomics.adam.rdd.variation.GenotypesSummaryCounts$;
import org.bdgenomics.formats.avro.GenotypeAllele;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class GenotypesSummaryFormatting$ {
    public static final GenotypesSummaryFormatting$ MODULE$;
    private Seq<GenotypesSummaryCounts.ReferenceAndAlternate> allSNVs;
    private volatile boolean bitmap$0;

    static {
        new GenotypesSummaryFormatting$();
    }

    private Seq allSNVs$lzycompute() {
        GenotypesSummaryFormatting$ genotypesSummaryFormatting$ = this;
        synchronized (genotypesSummaryFormatting$) {
            if (!this.bitmap$0) {
                this.allSNVs = (Seq)GenotypesSummaryCounts$.MODULE$.simpleNucleotides().flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final List<GenotypesSummaryCounts.ReferenceAndAlternate> apply(String from) {
                        return (List)GenotypesSummaryCounts$.MODULE$.simpleNucleotides().withFilter((Function1)new Serializable(this, from){
                            public static final long serialVersionUID = 0L;
                            private final String from$1;

                            public final boolean apply(String to) {
                                String string = this.from$1;
                                String string2 = to;
                                return string != null ? !string.equals(string2) : string2 != null;
                            }
                            {
                                this.from$1 = from$1;
                            }
                        }).map((Function1)new Serializable(this, from){
                            public static final long serialVersionUID = 0L;
                            private final String from$1;

                            public final GenotypesSummaryCounts.ReferenceAndAlternate apply(String to) {
                                return new GenotypesSummaryCounts.ReferenceAndAlternate(this.from$1, to);
                            }
                            {
                                this.from$1 = from$1;
                            }
                        }, List$.MODULE$.canBuildFrom());
                    }
                }, List$.MODULE$.canBuildFrom());
                this.bitmap$0 = true;
            }
            return this.allSNVs;
        }
    }

    public String format_csv(GenotypesSummary summary) {
        Seq<List<GenotypeAllele>> genotypeAlleles = this.sortedGenotypeAlleles(summary.aggregateStatistics());
        List basicHeader = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sample", "Genotypes", "Variant Genotypes", "Insertions", "Deletions", "SNVs", "Transitions", "Transversions", "Ti / Tv"}));
        Seq genotypesHeader = (Seq)genotypeAlleles.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(List<GenotypeAllele> x$12) {
                return GenotypesSummaryFormatting$.MODULE$.org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$genotypeAllelesToString(x$12);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq snvsHeader = (Seq)this.allSNVs().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GenotypesSummaryCounts.ReferenceAndAlternate snv) {
                return new StringOps(Predef$.MODULE$.augmentString("%s>%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{snv.reference(), snv.alternate()}));
            }
        }, Seq$.MODULE$.canBuildFrom());
        StringBuilder result = new StringBuilder();
        result.$plus$plus$eq(new StringBuilder().append((Object)"# ").append((Object)((TraversableOnce)((List)basicHeader.$plus$plus((GenTraversableOnce)genotypesHeader, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)snvsHeader, List$.MODULE$.canBuildFrom())).mkString(", ")).append((Object)"\n").toString());
        summary.perSampleStatistics().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, GenotypesSummaryCounts> check$ifrefutable$1) {
                Tuple2<String, GenotypesSummaryCounts> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(genotypeAlleles, result){
            public static final long serialVersionUID = 0L;
            private final Seq genotypeAlleles$1;
            private final StringBuilder result$1;

            public final StringBuilder apply(Tuple2<String, GenotypesSummaryCounts> x$13) {
                Tuple2<String, GenotypesSummaryCounts> tuple2 = x$13;
                if (tuple2 != null) {
                    String sample = (String)tuple2._1();
                    GenotypesSummaryCounts stats = (GenotypesSummaryCounts)tuple2._2();
                    MutableList row = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sample}));
                    row.$plus$plus$eq((TraversableOnce)GenotypesSummaryFormatting$.MODULE$.org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$format_statistics$1(stats, this.genotypeAlleles$1));
                    StringBuilder stringBuilder = this.result$1.$plus$plus$eq(new StringBuilder().append((Object)row.mkString(", ")).append((Object)"\n").toString());
                    return stringBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.genotypeAlleles$1 = genotypeAlleles$1;
                this.result$1 = result$1;
            }
        });
        List final_row = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aggregated"})).$plus$plus((GenTraversableOnce)this.org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$format_statistics$1(summary.aggregateStatistics(), genotypeAlleles), List$.MODULE$.canBuildFrom());
        result.$plus$plus$eq(new StringBuilder().append((Object)final_row.mkString(", ")).append((Object)"\n").toString());
        return result.toString();
    }

    public String format_human_readable(GenotypesSummary summary) {
        StringBuilder result = new StringBuilder();
        ((List)summary.perSampleStatistics().keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable(summary, result){
            public static final long serialVersionUID = 0L;
            private final GenotypesSummary summary$1;
            private final StringBuilder result$2;

            public final StringBuilder apply(String sample) {
                this.result$2.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("Sample: %s\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sample})));
                GenotypesSummaryFormatting$.MODULE$.org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$format_statistics$2((GenotypesSummaryCounts)this.summary$1.perSampleStatistics().apply((Object)sample), this.result$2, this.summary$1);
                return this.result$2.$plus$plus$eq("\n");
            }
            {
                this.summary$1 = summary$1;
                this.result$2 = result$2;
            }
        });
        result.$plus$plus$eq("\nSummary\n");
        result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\tSamples: %d\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)summary.perSampleStatistics().size())})));
        result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\tDistinct variants: %d\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)summary.distinctVariantCount())})));
        result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\tVariants found only in a single sample: %d = %1.3f%%\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)summary.singletonCount()), BoxesRunTime.boxToDouble((double)((double)summary.singletonCount() * 100.0 / (double)summary.distinctVariantCount()))})));
        this.org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$format_statistics$2(summary.aggregateStatistics(), result, summary);
        return result.toString();
    }

    private Seq<List<GenotypeAllele>> sortedGenotypeAlleles(GenotypesSummaryCounts stats) {
        return (Seq)stats.genotypesCounts().keySet().toList().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(List<GenotypeAllele> x$14) {
                return GenotypesSummaryFormatting$.MODULE$.org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$genotypeSortOrder$1(x$14);
            }
        }, (Ordering)Ordering.Int$.MODULE$);
    }

    public String org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$genotypeAllelesToString(List<GenotypeAllele> alleles) {
        return ((TraversableOnce)alleles.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GenotypeAllele x$15) {
                return x$15.toString();
            }
        }, List$.MODULE$.canBuildFrom())).mkString("-");
    }

    public Seq<GenotypesSummaryCounts.ReferenceAndAlternate> allSNVs() {
        return this.bitmap$0 ? this.allSNVs : this.allSNVs$lzycompute();
    }

    /*
     * WARNING - void declaration
     */
    public final Seq org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$format_statistics$1(GenotypesSummaryCounts stats, Seq genotypeAlleles$1) {
        void var3_3;
        MutableList row = (MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$);
        row.$plus$eq((Object)((Object)BoxesRunTime.boxToLong((long)stats.genotypesCount())).toString());
        row.$plus$eq((Object)((Object)BoxesRunTime.boxToLong((long)stats.variantGenotypesCount())).toString());
        row.$plus$eq((Object)((Object)BoxesRunTime.boxToLong((long)stats.insertionCount())).toString());
        row.$plus$eq((Object)((Object)BoxesRunTime.boxToLong((long)stats.deletionCount())).toString());
        row.$plus$eq((Object)((Object)BoxesRunTime.boxToLong((long)stats.singleNucleotideVariantCount())).toString());
        row.$plus$eq((Object)((Object)BoxesRunTime.boxToLong((long)stats.transitionCount())).toString());
        row.$plus$eq((Object)((Object)BoxesRunTime.boxToLong((long)stats.transversionCount())).toString());
        row.$plus$eq((Object)((Object)BoxesRunTime.boxToDouble((double)((double)stats.transitionCount() / (double)stats.transversionCount()))).toString());
        row.$plus$plus$eq((TraversableOnce)genotypeAlleles$1.map((Function1)new Serializable(stats){
            public static final long serialVersionUID = 0L;
            private final GenotypesSummaryCounts stats$1;

            public final String apply(List<GenotypeAllele> x$10) {
                return this.stats$1.genotypesCounts().apply(x$10).toString();
            }
            {
                this.stats$1 = stats$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
        row.$plus$plus$eq((TraversableOnce)this.allSNVs().map((Function1)new Serializable(stats){
            public static final long serialVersionUID = 0L;
            private final GenotypesSummaryCounts stats$1;

            public final String apply(GenotypesSummaryCounts.ReferenceAndAlternate x$11) {
                return this.stats$1.singleNucleotideVariantCounts().apply((Object)x$11).toString();
            }
            {
                this.stats$1 = stats$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
        return var3_3;
    }

    public final StringBuilder org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$format_statistics$2(GenotypesSummaryCounts stats, StringBuilder result, GenotypesSummary summary$1) {
        Option<Object> option;
        block4: {
            String string;
            Object[] objectArray;
            StringOps stringOps;
            block3: {
                block2: {
                    result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\tVariant Genotypes: %d / %d = %1.3f%%\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.variantGenotypesCount()), BoxesRunTime.boxToLong((long)stats.genotypesCount()), BoxesRunTime.boxToDouble((double)((double)stats.variantGenotypesCount() * 100.0 / (double)stats.genotypesCount()))})));
                    this.sortedGenotypeAlleles(summary$1.aggregateStatistics()).foreach((Function1)new Serializable(stats, result){
                        public static final long serialVersionUID = 0L;
                        private final GenotypesSummaryCounts stats$2;
                        private final StringBuilder result$3;

                        public final StringBuilder apply(List<GenotypeAllele> genotype) {
                            long count = BoxesRunTime.unboxToLong((Object)this.stats$2.genotypesCounts().apply(genotype));
                            return this.result$3.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\t%20s: %9d = %1.3f%%\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GenotypesSummaryFormatting$.MODULE$.org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$genotypeAllelesToString(genotype), BoxesRunTime.boxToLong((long)count), BoxesRunTime.boxToDouble((double)((double)count * 100.0 / (double)this.stats$2.genotypesCount()))})));
                        }
                        {
                            this.stats$2 = stats$2;
                            this.result$3 = result$3;
                        }
                    });
                    result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\tInsertions: %d\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.insertionCount())})));
                    result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\tDeletions: %d\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.deletionCount())})));
                    result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\tMultiple nucleotide variants: %d\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.multipleNucleotideVariantCount())})));
                    result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\tSingle nucleotide variants: %d\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.singleNucleotideVariantCount())})));
                    result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\t\tTransitions / transversions: %4d / %4d = %1.3f\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.transitionCount()), BoxesRunTime.boxToLong((long)stats.transversionCount()), BoxesRunTime.boxToDouble((double)((double)stats.transitionCount() / (double)stats.transversionCount()))})));
                    boolean from = false;
                    boolean to = false;
                    this.allSNVs().foreach((Function1)new Serializable(stats, result){
                        public static final long serialVersionUID = 0L;
                        private final GenotypesSummaryCounts stats$2;
                        private final StringBuilder result$3;

                        public final StringBuilder apply(GenotypesSummaryCounts.ReferenceAndAlternate snv) {
                            return this.result$3.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\t\t%s>%s %9d\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{snv.reference(), snv.alternate(), this.stats$2.singleNucleotideVariantCounts().apply((Object)snv)})));
                        }
                        {
                            this.stats$2 = stats$2;
                            this.result$3 = result$3;
                        }
                    });
                    stringOps = new StringOps(Predef$.MODULE$.augmentString("\tAverage read depth at called variants: %s\n"));
                    objectArray = new Object[1];
                    option = stats.averageReadDepthAtVariants();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    double depth = BoxesRunTime.unboxToDouble((Object)some.x());
                    string = new StringOps(Predef$.MODULE$.augmentString("%1.1f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)depth)}));
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                string = "[no variant calls, or read depth missing for one or more variant calls]";
            }
            objectArray[0] = string;
            result.$plus$plus$eq(stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
            return result.$plus$plus$eq(new StringOps(Predef$.MODULE$.augmentString("\tPhased genotypes: %d / %d = %1.3f%%\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.phasedCount()), BoxesRunTime.boxToLong((long)stats.genotypesCount()), BoxesRunTime.boxToDouble((double)((double)stats.phasedCount() * (double)100 / (double)stats.genotypesCount()))})));
        }
        throw new MatchError(option);
    }

    public final int org$bdgenomics$adam$rdd$variation$GenotypesSummaryFormatting$$genotypeSortOrder$1(List genotype) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)genotype.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(GenotypeAllele x0$2) {
                GenotypeAllele genotypeAllele;
                block8: {
                    int n;
                    block6: {
                        block7: {
                            boolean bl;
                            block5: {
                                genotypeAllele = x0$2;
                                GenotypeAllele genotypeAllele2 = GenotypeAllele.Ref;
                                GenotypeAllele genotypeAllele3 = genotypeAllele;
                                if (genotypeAllele2 != null ? !genotypeAllele2.equals(genotypeAllele3) : genotypeAllele3 != null) break block5;
                                n = 0;
                                break block6;
                            }
                            GenotypeAllele genotypeAllele4 = GenotypeAllele.Alt;
                            GenotypeAllele genotypeAllele5 = genotypeAllele;
                            if (!(genotypeAllele4 != null ? !genotypeAllele4.equals(genotypeAllele5) : genotypeAllele5 != null)) {
                                bl = true;
                            } else {
                                GenotypeAllele genotypeAllele6 = GenotypeAllele.OtherAlt;
                                GenotypeAllele genotypeAllele7 = genotypeAllele;
                                bl = !(genotypeAllele6 != null ? !genotypeAllele6.equals(genotypeAllele7) : genotypeAllele7 != null);
                            }
                            if (!bl) break block7;
                            n = 1;
                            break block6;
                        }
                        GenotypeAllele genotypeAllele8 = GenotypeAllele.NoCall;
                        GenotypeAllele genotypeAllele9 = genotypeAllele;
                        if (genotypeAllele8 != null ? !genotypeAllele8.equals(genotypeAllele9) : genotypeAllele9 != null) break block8;
                        n = 10;
                    }
                    return n;
                }
                throw new MatchError((Object)genotypeAllele);
            }
        }, List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private GenotypesSummaryFormatting$() {
        MODULE$ = this;
    }
}

