/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.variation;

import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.VariantContextConverter;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.models.VariantContext$;
import org.bdgenomics.adam.rdd.ADAMSequenceDictionaryRDDAggregator;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat$;
import org.bdgenomics.adam.rich.RichVariant;
import org.bdgenomics.adam.rich.RichVariant$;
import org.bdgenomics.formats.avro.DatabaseVariantAnnotation;
import org.bdgenomics.formats.avro.Genotype;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001b\tQb+\u0019:jC:$8i\u001c8uKb$(\u000b\u0012#Gk:\u001cG/[8og*\u00111\u0001B\u0001\nm\u0006\u0014\u0018.\u0019;j_:T!!\u0002\u0004\u0002\u0007I$GM\u0003\u0002\b\u0011\u0005!\u0011\rZ1n\u0015\tI!\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019A\u0002cA\b\u0011%5\tA!\u0003\u0002\u0012\t\t\u0019\u0013\tR!N'\u0016\fX/\u001a8dK\u0012K7\r^5p]\u0006\u0014\u0018P\u0015#E\u0003\u001e<'/Z4bi>\u0014\bCA\n\u0017\u001b\u0005!\"BA\u000b\u0007\u0003\u0019iw\u000eZ3mg&\u0011q\u0003\u0006\u0002\u000f-\u0006\u0014\u0018.\u00198u\u0007>tG/\u001a=u!\tIb$D\u0001\u001b\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e\u0015\u00051\u0011\r]1dQ\u0016L!a\b\u000e\u0003\u000f1{wmZ5oO\"AQ\u0001\u0001B\u0001B\u0003%\u0011\u0005E\u0002#IIi\u0011a\t\u0006\u0003\u000biI!!J\u0012\u0003\u0007I#E\tC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0003S-\u0002\"A\u000b\u0001\u000e\u0003\tAQ!\u0002\u0014A\u0002\u0005BQ!\f\u0001\u0005\u00029\nQdZ3u'\u0016\fX/\u001a8dKJ+7m\u001c:eg\u001a\u0013x.\\#mK6,g\u000e\u001e\u000b\u0003_i\u00022\u0001M\u001b8\u001b\u0005\t$B\u0001\u001a4\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002i\u0005)1oY1mC&\u0011a'\r\u0002\u0004'\u0016$\bCA\n9\u0013\tIDC\u0001\bTKF,XM\\2f%\u0016\u001cwN\u001d3\t\u000bmb\u0003\u0019\u0001\n\u0002\t\u0015dW-\u001c\u0005\u0006{\u0001!\tAP\u0001\u001eU>Lg\u000eR1uC\n\f7/\u001a,be&\fg\u000e^!o]>$\u0018\r^5p]R\u0011\u0011e\u0010\u0005\u0006\u0001r\u0002\r!Q\u0001\u0004C:t\u0007c\u0001\u0012%\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005CZ\u0014xN\u0003\u0002H\u0011\u00059am\u001c:nCR\u001c\u0018BA%E\u0005e!\u0015\r^1cCN,g+\u0019:jC:$\u0018I\u001c8pi\u0006$\u0018n\u001c8\t\u000b-\u0003A\u0011\u0001'\u0002#\u001d,GoQ1mYN,GoU1na2,7\u000fF\u0001N!\rqe+\u0017\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!A\u0015\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014BA+4\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\t1K7\u000f\u001e\u0006\u0003+N\u0002\"A\u00170\u000f\u0005mcV\"A\u001a\n\u0005u\u001b\u0014A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!X\u001a\t\u000b\t\u0004A\u0011A2\u0002\u0017\u0005$\u0017-\u001c,D\rN\u000bg/\u001a\u000b\u0004C\u00114\u0007\"B3b\u0001\u0004I\u0016\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\t\u000f\u001d\f\u0007\u0013!a\u0001Q\u0006!A-[2u!\rY\u0016n[\u0005\u0003UN\u0012aa\u00149uS>t\u0007CA\nm\u0013\tiGC\u0001\nTKF,XM\\2f\t&\u001cG/[8oCJL\bbB8\u0001#\u0003%\t\u0001]\u0001\u0016C\u0012\fWNV\"G'\u00064X\r\n3fM\u0006,H\u000e\u001e\u00133+\u0005\t(F\u00015sW\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003%)hn\u00195fG.,GM\u0003\u0002yg\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005i,(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class VariantContextRDDFunctions
extends ADAMSequenceDictionaryRDDAggregator<VariantContext>
implements Logging {
    private final RDD<VariantContext> rdd;

    @Override
    public Set<SequenceRecord> getSequenceRecordsFromElement(VariantContext elem) {
        return ((TraversableOnce)elem.genotypes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SequenceRecord apply(Genotype gt) {
                return SequenceRecord$.MODULE$.fromSpecificRecord((SpecificRecord)gt.getVariant());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public RDD<VariantContext> joinDatabaseVariantAnnotation(RDD<DatabaseVariantAnnotation> ann) {
        RDD x$7 = this.rdd.keyBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RichVariant apply(VariantContext x$1) {
                return x$1.variant();
            }
        });
        ClassTag x$8 = ClassTag$.MODULE$.apply(RichVariant.class);
        ClassTag x$9 = ClassTag$.MODULE$.apply(VariantContext.class);
        Null$ x$10 = SparkContext$.MODULE$.rddToPairRDDFunctions$default$4(x$7);
        RDD x$11 = SparkContext$.MODULE$.rddToPairRDDFunctions(x$7, x$8, x$9, null).leftOuterJoin(ann.keyBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RichVariant apply(DatabaseVariantAnnotation x$2) {
                return RichVariant$.MODULE$.variantToRichVariant(x$2.getVariant());
            }
        }));
        ClassTag x$12 = ClassTag$.MODULE$.apply(RichVariant.class);
        ClassTag x$13 = ClassTag$.MODULE$.apply(Tuple2.class);
        Null$ x$14 = SparkContext$.MODULE$.rddToPairRDDFunctions$default$4(x$11);
        return SparkContext$.MODULE$.rddToPairRDDFunctions(x$11, x$12, x$13, null).values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VariantContext apply(Tuple2<VariantContext, Option<DatabaseVariantAnnotation>> x0$1) {
                Tuple2<VariantContext, Option<DatabaseVariantAnnotation>> tuple2 = x0$1;
                if (tuple2 != null) {
                    VariantContext v = (VariantContext)tuple2._1();
                    Option a = (Option)tuple2._2();
                    if (v != null) {
                        VariantContext variantContext = v;
                        VariantContext variantContext2 = VariantContext$.MODULE$.apply(RichVariant$.MODULE$.richVariantToVariant(variantContext.variant()), variantContext.genotypes(), (Option<DatabaseVariantAnnotation>)a);
                        return variantContext2;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VariantContext.class));
    }

    public List<String> getCallsetSamples() {
        return Predef$.MODULE$.refArrayOps((Object[])this.rdd.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(VariantContext c) {
                return (Seq)((TraversableOnce)c.genotypes().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Genotype x$3) {
                        return x$3.getSampleId();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq().distinct();
            }
        }, ClassTag$.MODULE$.apply(String.class)).distinct().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$4) {
                return x$4.toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect()).toList();
    }

    public RDD<VariantContext> adamVCFSave(String filePath, Option<SequenceDictionary> dict) {
        VCFFormat vcfFormat;
        VCFFormat vCFFormat = vcfFormat = VCFFormat.inferFromFilePath((String)filePath);
        VCFFormat vCFFormat2 = VCFFormat.VCF;
        Predef$.MODULE$.assert(!(vCFFormat != null ? !vCFFormat.equals(vCFFormat2) : vCFFormat2 != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "BCF not yet supported";
            }
        });
        this.rdd.cache();
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Writing %s file to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vcfFormat, filePath})));
        List<String> header2 = this.getCallsetSamples();
        Broadcast bcastHeader = this.rdd.context().broadcast(header2, ClassTag$.MODULE$.apply(List.class));
        long mp = this.rdd.mapPartitionsWithIndex((Function2)new Serializable(this, bcastHeader){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextRDDFunctions $outer;
            private final Broadcast bcastHeader$1;

            public final Iterator<Object> apply(int idx, Iterator<VariantContext> iter) {
                this.$outer.log().warn(new StringBuilder().append((Object)"Setting header for partition ").append((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
                VariantContextRDDFunctions variantContextRDDFunctions = this.$outer;
                synchronized (variantContextRDDFunctions) {
                    ADAMVCFOutputFormat$.MODULE$.setHeader((Seq<String>)((Seq)this.bcastHeader$1.value()));
                    this.$outer.log().warn(new StringBuilder().append((Object)"Set VCF header for partition ").append((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
                    return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bcastHeader$1 = bcastHeader$1;
            }
        }, this.rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Int()).count();
        if (mp != 0L) {
            this.log().warn("Had more than 0 elements after map partitions call to set VCF header across cluster.");
        }
        VariantContextConverter converter = new VariantContextConverter(dict);
        RDD gatkVCs = this.rdd.map((Function1)new Serializable(this, converter){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter converter$1;

            /*
             * WARNING - void declaration
             */
            public final VariantContextWritable apply(VariantContext v) {
                void var2_2;
                VariantContextWritable vcw = new VariantContextWritable();
                vcw.set(this.converter$1.convert(v));
                return var2_2;
            }
            {
                this.converter$1 = converter$1;
            }
        }, ClassTag$.MODULE$.apply(VariantContextWritable.class));
        RDD withKey = gatkVCs.keyBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LongWritable apply(VariantContextWritable v) {
                return new LongWritable((long)v.get().getStart());
            }
        });
        Configuration conf = this.rdd.context().hadoopConfiguration();
        conf.set("hadoopbam.vcf.output-format", vcfFormat.toString());
        SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(VariantContextWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsNewAPIHadoopFile(filePath, LongWritable.class, VariantContextWritable.class, ADAMVCFOutputFormat.class, conf);
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Write %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)gatkVCs.count())})));
        return this.rdd.unpersist(this.rdd.unpersist$default$1());
    }

    public Option<SequenceDictionary> adamVCFSave$default$2() {
        return None$.MODULE$;
    }

    public VariantContextRDDFunctions(RDD<VariantContext> rdd) {
        this.rdd = rdd;
        super(rdd);
    }
}

