/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.util.TwoBitFile$;
import org.bdgenomics.adam.util.TwoBitRecord;
import org.bdgenomics.utils.parquet.io.ByteAccess;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ut!B\u0001\u0003\u0011\u0003Y\u0011A\u0003+x_\nKGOR5mK*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u000b)^|')\u001b;GS2,7CA\u0007\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\")q#\u0004C\u00011\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\b55\u0011\r\u0011\"\u0001\u001c\u00031i\u0015iR%D?:+VJQ#S+\u0005a\u0002CA\t\u001e\u0013\tq\"CA\u0002J]RDa\u0001I\u0007!\u0002\u0013a\u0012!D'B\u000f&\u001buLT+N\u0005\u0016\u0013\u0006\u0005C\u0004#\u001b\t\u0007I\u0011A\u000e\u0002\u001d\t\u000b5+R*`!\u0016\u0013vLQ-U\u000b\"1A%\u0004Q\u0001\nq\tqBQ!T\u000bN{\u0006+\u0012*`\u0005f#V\t\t\u0005\bM5\u0011\r\u0011\"\u0001\u001c\u0003%\u0011\u0015\fV#`'&SV\t\u0003\u0004)\u001b\u0001\u0006I\u0001H\u0001\u000b\u0005f#ViX*J5\u0016\u0003\u0003b\u0002\u0016\u000e\u0005\u0004%\taK\u0001\u0005\u001b\u0006\u001b6*F\u0001-!\t\tR&\u0003\u0002/%\t!!)\u001f;f\u0011\u0019\u0001T\u0002)A\u0005Y\u0005)Q*Q*LA!9!'\u0004b\u0001\n\u0003Y\u0012A\u0004,F%NKuJT0P\r\u001a\u001bV\t\u0016\u0005\u0007i5\u0001\u000b\u0011\u0002\u000f\u0002\u001fY+%kU%P\u001d~{eIR*F)\u0002BqAN\u0007C\u0002\u0013\u00051$A\u000bT\u000bF+VIT\"F?\u000e{UK\u0014+`\u001f\u001a35+\u0012+\t\raj\u0001\u0015!\u0003\u001d\u0003Y\u0019V)U+F\u001d\u000e+ulQ(V\u001dR{vJ\u0012$T\u000bR\u0003\u0003b\u0002\u001e\u000e\u0005\u0004%\taG\u0001\u0017\u0011\u0016\u000bE)\u0012*`%\u0016\u001bVI\u0015,F\t~{eIR*F)\"1A(\u0004Q\u0001\nq\tq\u0003S#B\t\u0016\u0013vLU#T\u000bJ3V\tR0P\r\u001a\u001bV\t\u0016\u0011\t\u000fyj!\u0019!C\u00017\u0005\tb)\u0013'F?&sE)\u0012-`\u001f\u001a35+\u0012+\t\r\u0001k\u0001\u0015!\u0003\u001d\u0003I1\u0015\nT#`\u0013:#U\tW0P\r\u001a\u001bV\t\u0016\u0011\t\u000f\tk!\u0019!C\u00017\u0005qa*Q'F?NK%,R0T\u0013j+\u0005B\u0002#\u000eA\u0003%A$A\bO\u00036+ulU%[\u000b~\u001b\u0016JW#!\u0011\u001d1UB1A\u0005\u0002m\t1b\u0014$G'\u0016#vlU%[\u000b\"1\u0001*\u0004Q\u0001\nq\tAb\u0014$G'\u0016#vlU%[\u000b\u0002BqAS\u0007C\u0002\u0013\u00051$\u0001\u0005J\u001dR{6+\u0013.F\u0011\u0019aU\u0002)A\u00059\u0005I\u0011J\u0014+`'&SV\t\t\u0005\b\u001d6\u0011\r\u0011\"\u0001\u001c\u00035!e*Q0T\u0013j+ulU%[\u000b\"1\u0001+\u0004Q\u0001\nq\ta\u0002\u0012(B?NK%,R0T\u0013j+\u0005\u0005C\u0004S\u001b\t\u0007I\u0011A\u000e\u0002!\tcujQ&`\u0007>+f\nV0T\u0013j+\u0005B\u0002+\u000eA\u0003%A$A\tC\u0019>\u001b5jX\"P+:#vlU%[\u000b\u0002BqAV\u0007C\u0002\u0013\u00051$\u0001\bQ\u000bJ{&\tT(D\u0017~\u001b\u0016JW#\t\rak\u0001\u0015!\u0003\u001d\u0003=\u0001VIU0C\u0019>\u001b5jX*J5\u0016\u0003\u0003b\u0002.\u000e\u0005\u0004%\taG\u0001\u0019'\u0016\u000bvLU#D\u001fJ#uLU#T\u000bJ3V\tR0T\u0013j+\u0005B\u0002/\u000eA\u0003%A$A\rT\u000bF{&+R\"P%\u0012{&+R*F%Z+EiX*J5\u0016\u0003c\u0001\u0002\b\u0003\u0001y\u001b\"!\u0018\t\t\u0011\u0001l&\u0011!Q\u0001\n\u0005\f!BY=uK\u0006\u001b7-Z:t!\t\u0011\u0017.D\u0001d\u0015\t!W-\u0001\u0002j_*\u0011amZ\u0001\ba\u0006\u0014\u0018/^3u\u0015\tAg!A\u0003vi&d7/\u0003\u0002kG\nQ!)\u001f;f\u0003\u000e\u001cWm]:\t\u000b]iF\u0011\u00017\u0015\u00055t\u0007C\u0001\u0007^\u0011\u0015\u00017\u000e1\u0001b\u0011\u001d\u0001XL1A\u0005\u0002E\fQAY=uKN,\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\f1A\\5p\u0015\u00059\u0018\u0001\u00026bm\u0006L!!\u001f;\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0004|;\u0002\u0006IA]\u0001\u0007Ef$Xm\u001d\u0011\t\u000ful&\u0019!C\u00017\u00051a.^7TKFDaa`/!\u0002\u0013a\u0012a\u00028v[N+\u0017\u000f\t\u0005\t\u0003\u0007i\u0006\u0019!C\u00017\u0005\u0001\u0012N\u001c3fqJ+7m\u001c:e'R\f'\u000f\u001e\u0005\n\u0003\u000fi\u0006\u0019!C\u0001\u0003\u0013\tA#\u001b8eKb\u0014VmY8sIN#\u0018M\u001d;`I\u0015\fH\u0003BA\u0006\u0003#\u00012!EA\u0007\u0013\r\tyA\u0005\u0002\u0005+:LG\u000fC\u0005\u0002\u0014\u0005\u0015\u0011\u0011!a\u00019\u0005\u0019\u0001\u0010J\u0019\t\u000f\u0005]Q\f)Q\u00059\u0005\t\u0012N\u001c3fqJ+7m\u001c:e'R\f'\u000f\u001e\u0011\t\u0013\u0005mQL1A\u0005\n\u0005u\u0011aD:fcJ+7m\u001c:e'R\f'\u000f^:\u0016\u0005\u0005}\u0001cBA\u0011\u0003W\ty\u0003H\u0007\u0003\u0003GQA!!\n\u0002(\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003S\u0011\u0012AC2pY2,7\r^5p]&!\u0011QFA\u0012\u0005\ri\u0015\r\u001d\t\u0005\u0003c\t9DD\u0002\u0012\u0003gI1!!\u000e\u0013\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011HA\u001e\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0007\n\t\u0011\u0005}R\f)A\u0005\u0003?\t\u0001c]3r%\u0016\u001cwN\u001d3Ti\u0006\u0014Ho\u001d\u0011\t\u0013\u0005\rSL1A\u0005\u0002\u0005\u0015\u0013AC:fcJ+7m\u001c:egV\u0011\u0011q\t\t\t\u0003C\tY#a\f\u0002JA\u0019A\"a\u0013\n\u0007\u00055#A\u0001\u0007Uo>\u0014\u0015\u000e\u001e*fG>\u0014H\r\u0003\u0005\u0002Ru\u0003\u000b\u0011BA$\u0003-\u0019X-\u001d*fG>\u0014Hm\u001d\u0011\t\u000f\u0005US\f\"\u0003\u0002X\u0005Q!/Z1e\u0011\u0016\fG-\u001a:\u0015\u0003qAq!a\u0017^\t\u0013\ti&\u0001\bsK\u0006$\u0017J\u001c3fq\u0016sGO]=\u0015\t\u0005}\u0013Q\r\t\u0007#\u0005\u0005\u0014q\u0006\u000f\n\u0007\u0005\r$C\u0001\u0004UkBdWM\r\u0005\b\u0003\u0007\tI\u00061\u0001\u001d\u0011\u001d\tI'\u0018C\u0001\u0003W\nq!\u001a=ue\u0006\u001cG\u000f\u0006\u0003\u00020\u00055\u0004\u0002CA8\u0003O\u0002\r!!\u001d\u0002\rI,w-[8o!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<\t\u00051Qn\u001c3fYNLA!a\u001f\u0002v\ty!+\u001a4fe\u0016t7-\u001a*fO&|g\u000e")
public class TwoBitFile {
    private final ByteBuffer bytes;
    private final int numSeq;
    private int indexRecordStart;
    private final Map<String, Object> seqRecordStarts;
    private final Map<String, TwoBitRecord> seqRecords;

    public static int SEQ_RECORD_RESERVED_SIZE() {
        return TwoBitFile$.MODULE$.SEQ_RECORD_RESERVED_SIZE();
    }

    public static int PER_BLOCK_SIZE() {
        return TwoBitFile$.MODULE$.PER_BLOCK_SIZE();
    }

    public static int BLOCK_COUNT_SIZE() {
        return TwoBitFile$.MODULE$.BLOCK_COUNT_SIZE();
    }

    public static int DNA_SIZE_SIZE() {
        return TwoBitFile$.MODULE$.DNA_SIZE_SIZE();
    }

    public static int INT_SIZE() {
        return TwoBitFile$.MODULE$.INT_SIZE();
    }

    public static int OFFSET_SIZE() {
        return TwoBitFile$.MODULE$.OFFSET_SIZE();
    }

    public static int NAME_SIZE_SIZE() {
        return TwoBitFile$.MODULE$.NAME_SIZE_SIZE();
    }

    public static int FILE_INDEX_OFFSET() {
        return TwoBitFile$.MODULE$.FILE_INDEX_OFFSET();
    }

    public static int HEADER_RESERVED_OFFSET() {
        return TwoBitFile$.MODULE$.HEADER_RESERVED_OFFSET();
    }

    public static int SEQUENCE_COUNT_OFFSET() {
        return TwoBitFile$.MODULE$.SEQUENCE_COUNT_OFFSET();
    }

    public static int VERSION_OFFSET() {
        return TwoBitFile$.MODULE$.VERSION_OFFSET();
    }

    public static byte MASK() {
        return TwoBitFile$.MODULE$.MASK();
    }

    public static int BYTE_SIZE() {
        return TwoBitFile$.MODULE$.BYTE_SIZE();
    }

    public static int BASES_PER_BYTE() {
        return TwoBitFile$.MODULE$.BASES_PER_BYTE();
    }

    public static int MAGIC_NUMBER() {
        return TwoBitFile$.MODULE$.MAGIC_NUMBER();
    }

    public ByteBuffer bytes() {
        return this.bytes;
    }

    public int numSeq() {
        return this.numSeq;
    }

    public int indexRecordStart() {
        return this.indexRecordStart;
    }

    public void indexRecordStart_$eq(int x$1) {
        this.indexRecordStart = x$1;
    }

    private Map<String, Object> seqRecordStarts() {
        return this.seqRecordStarts;
    }

    public Map<String, TwoBitRecord> seqRecords() {
        return this.seqRecords;
    }

    private int readHeader() {
        this.bytes().order(ByteOrder.LITTLE_ENDIAN);
        Object object = this.bytes().getInt(0) != TwoBitFile$.MODULE$.MAGIC_NUMBER() ? this.bytes().order(ByteOrder.BIG_ENDIAN) : BoxedUnit.UNIT;
        if (this.bytes().getInt(0) != TwoBitFile$.MODULE$.MAGIC_NUMBER()) {
            throw new IllegalStateException();
        }
        Predef$.MODULE$.assert(this.bytes().getInt(TwoBitFile$.MODULE$.VERSION_OFFSET()) == 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Version must be zero";
            }
        });
        Predef$.MODULE$.assert(this.bytes().getInt(TwoBitFile$.MODULE$.HEADER_RESERVED_OFFSET()) == 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Reserved field must be zero";
            }
        });
        Predef$.MODULE$.assert(this.bytes().hasArray());
        return this.bytes().getInt(TwoBitFile$.MODULE$.SEQUENCE_COUNT_OFFSET());
    }

    public Tuple2<String, Object> org$bdgenomics$adam$util$TwoBitFile$$readIndexEntry(int indexRecordStart) {
        byte nameSize = this.bytes().get(indexRecordStart);
        String name2 = new String(this.bytes().array(), indexRecordStart + TwoBitFile$.MODULE$.NAME_SIZE_SIZE(), (int)nameSize, "UTF-8");
        int contigOffset = this.bytes().getInt(indexRecordStart + TwoBitFile$.MODULE$.NAME_SIZE_SIZE() + nameSize);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)name2), (Object)BoxesRunTime.boxToInteger((int)contigOffset));
    }

    public String extract(ReferenceRegion region2) {
        TwoBitRecord record = (TwoBitRecord)this.seqRecords().apply((Object)region2.referenceName());
        int contigLength = record.dnaSize();
        Predef$.MODULE$.assert(region2.start() >= 0L);
        Predef$.MODULE$.assert(region2.end() <= (long)contigLength);
        int offset = record.dnaOffset();
        StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)region2.width()).foreach((Function1)new Serializable(this, region2, offset, sb){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TwoBitFile $outer;
            private final ReferenceRegion region$1;
            private final int offset$1;
            private final StringBuilder sb$1;

            public final StringBuilder apply(int i) {
                char c;
                byte by = this.$outer.bytes().get(this.offset$1 + ((int)this.region$1.start() + i) / TwoBitFile$.MODULE$.BASES_PER_BYTE());
                long slot = (this.region$1.start() + (long)i) % (long)TwoBitFile$.MODULE$.BASES_PER_BYTE() + 1L;
                long shift = (long)TwoBitFile$.MODULE$.BYTE_SIZE() - 2L * slot;
                int n = (int)((long)by >> (int)shift) & TwoBitFile$.MODULE$.MASK();
                switch (n) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                    case 3: {
                        c = 'G';
                        break;
                    }
                    case 2: {
                        c = 'A';
                        break;
                    }
                    case 1: {
                        c = 'C';
                        break;
                    }
                    case 0: {
                        c = 'T';
                    }
                }
                char nt = c;
                return this.sb$1.$plus$eq(nt);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.region$1 = region$1;
                this.offset$1 = offset$1;
                this.sb$1 = sb$1;
            }
        });
        return sb.toString();
    }

    public TwoBitFile(ByteAccess byteAccess) {
        this.bytes = ByteBuffer.wrap(byteAccess.readFully(0L, (int)byteAccess.length()));
        this.numSeq = this.readHeader();
        this.indexRecordStart = TwoBitFile$.MODULE$.FILE_INDEX_OFFSET();
        this.seqRecordStarts = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numSeq()).map((Function1)new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.seqRecords = ((Map)this.seqRecordStarts().map((Function1)new $anonfun$2(this), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }
}

