@REM ----------------------------------------------------------------------------
@REM  Copyright 2001-2006 The Apache Software Foundation.
@REM
@REM  Licensed under the Apache License, Version 2.0 (the "License");
@REM  you may not use this file except in compliance with the License.
@REM  You may obtain a copy of the License at
@REM
@REM       http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM  Unless required by applicable law or agreed to in writing, software
@REM  distributed under the License is distributed on an "AS IS" BASIS,
@REM  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM  See the License for the specific language governing permissions and
@REM  limitations under the License.
@REM ----------------------------------------------------------------------------
@REM
@REM   Copyright (c) 2001-2006 The Apache Software Foundation.  All rights
@REM   reserved.

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup
set REPO=


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\repo

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\commons-cli\commons-cli\1.2\commons-cli-1.2.jar;"%REPO%"\commons-httpclient\commons-httpclient\3.1\commons-httpclient-3.1.jar;"%REPO%"\commons-codec\commons-codec\1.4\commons-codec-1.4.jar;"%REPO%"\commons-logging\commons-logging\1.1.1\commons-logging-1.1.1.jar;"%REPO%"\org\apache\commons\commons-compress\1.4.1\commons-compress-1.4.1.jar;"%REPO%"\org\tukaani\xz\1.0\xz-1.0.jar;"%REPO%"\org\slf4j\slf4j-api\1.7.5\slf4j-api-1.7.5.jar;"%REPO%"\log4j\log4j\1.2.17\log4j-1.2.17.jar;"%REPO%"\org\xerial\snappy\snappy-java\1.1.1.6\snappy-java-1.1.1.6.jar;"%REPO%"\org\bdgenomics\bdg-utils\bdg-utils-parquet\0.1.1\bdg-utils-parquet-0.1.1.jar;"%REPO%"\com\twitter\parquet-avro\1.6.0rc4\parquet-avro-1.6.0rc4.jar;"%REPO%"\com\twitter\parquet-column\1.6.0rc4\parquet-column-1.6.0rc4.jar;"%REPO%"\com\twitter\parquet-common\1.6.0rc4\parquet-common-1.6.0rc4.jar;"%REPO%"\com\twitter\parquet-encoding\1.6.0rc4\parquet-encoding-1.6.0rc4.jar;"%REPO%"\com\twitter\parquet-generator\1.6.0rc4\parquet-generator-1.6.0rc4.jar;"%REPO%"\com\twitter\parquet-hadoop\1.6.0rc4\parquet-hadoop-1.6.0rc4.jar;"%REPO%"\com\twitter\parquet-jackson\1.6.0rc4\parquet-jackson-1.6.0rc4.jar;"%REPO%"\com\twitter\parquet-format\2.2.0-rc1\parquet-format-2.2.0-rc1.jar;"%REPO%"\org\apache\httpcomponents\httpclient\4.3.2\httpclient-4.3.2.jar;"%REPO%"\org\apache\httpcomponents\httpcore\4.3.1\httpcore-4.3.1.jar;"%REPO%"\org\bdgenomics\bdg-utils\bdg-utils-metrics\0.1.1\bdg-utils-metrics-0.1.1.jar;"%REPO%"\org\bdgenomics\bdg-utils\bdg-utils-misc\0.1.1\bdg-utils-misc-0.1.1.jar;"%REPO%"\com\netflix\servo\servo-core\0.5.5\servo-core-0.5.5.jar;"%REPO%"\com\google\code\findbugs\annotations\2.0.0\annotations-2.0.0.jar;"%REPO%"\org\scoverage\scalac-scoverage-plugin_2.10\0.99.2\scalac-scoverage-plugin_2.10-0.99.2.jar;"%REPO%"\commons-io\commons-io\1.3.2\commons-io-1.3.2.jar;"%REPO%"\org\bdgenomics\bdg-formats\bdg-formats\0.4.0\bdg-formats-0.4.0.jar;"%REPO%"\org\apache\avro\avro\1.7.6\avro-1.7.6.jar;"%REPO%"\org\codehaus\jackson\jackson-core-asl\1.9.13\jackson-core-asl-1.9.13.jar;"%REPO%"\org\codehaus\jackson\jackson-mapper-asl\1.9.13\jackson-mapper-asl-1.9.13.jar;"%REPO%"\com\thoughtworks\paranamer\paranamer\2.3\paranamer-2.3.jar;"%REPO%"\org\bdgenomics\adam\adam-core\0.16.0\adam-core-0.16.0.jar;"%REPO%"\com\esotericsoftware\kryo\kryo\2.21\kryo-2.21.jar;"%REPO%"\com\esotericsoftware\reflectasm\reflectasm\1.07\reflectasm-1.07-shaded.jar;"%REPO%"\org\ow2\asm\asm\4.0\asm-4.0.jar;"%REPO%"\com\esotericsoftware\minlog\minlog\1.2\minlog-1.2.jar;"%REPO%"\org\objenesis\objenesis\1.2\objenesis-1.2.jar;"%REPO%"\it\unimi\dsi\fastutil\6.4.4\fastutil-6.4.4.jar;"%REPO%"\org\seqdoop\hadoop-bam\7.0.0\hadoop-bam-7.0.0.jar;"%REPO%"\org\seqdoop\cofoja\1.1-r150\cofoja-1.1-r150.jar;"%REPO%"\org\seqdoop\htsjdk\1.118\htsjdk-1.118.jar;"%REPO%"\org\apache\ant\ant\1.8.2\ant-1.8.2.jar;"%REPO%"\org\apache\ant\ant-launcher\1.8.2\ant-launcher-1.8.2.jar;"%REPO%"\org\apache\bcel\bcel\5.2\bcel-5.2.jar;"%REPO%"\jakarta-regexp\jakarta-regexp\1.4\jakarta-regexp-1.4.jar;"%REPO%"\org\apache\commons\commons-jexl\2.1.1\commons-jexl-2.1.1.jar;"%REPO%"\org\testng\testng\6.8.8\testng-6.8.8.jar;"%REPO%"\org\beanshell\bsh\2.0b4\bsh-2.0b4.jar;"%REPO%"\com\beust\jcommander\1.27\jcommander-1.27.jar;"%REPO%"\com\google\guava\guava\14.0.1\guava-14.0.1.jar;"%REPO%"\org\bdgenomics\adam\adam-apis\0.16.0\adam-apis-0.16.0.jar;"%REPO%"\org\scala-lang\scala-library\2.10.4\scala-library-2.10.4.jar;"%REPO%"\org\slf4j\slf4j-log4j12\1.7.5\slf4j-log4j12-1.7.5.jar;"%REPO%"\args4j\args4j\2.0.23\args4j-2.0.23.jar;"%REPO%"\org\fusesource\scalate\scalate-core_2.10\1.6.1\scalate-core_2.10-1.6.1.jar;"%REPO%"\org\fusesource\scalate\scalate-util_2.10\1.6.1\scalate-util_2.10-1.6.1.jar;"%REPO%"\org\scala-lang\scala-compiler\2.10.0\scala-compiler-2.10.0.jar;"%REPO%"\org\scalatra\scalatra-json_2.10\2.3.0\scalatra-json_2.10-2.3.0.jar;"%REPO%"\org\json4s\json4s-core_2.10\3.2.10\json4s-core_2.10-3.2.10.jar;"%REPO%"\org\json4s\json4s-ast_2.10\3.2.10\json4s-ast_2.10-3.2.10.jar;"%REPO%"\org\scala-lang\scalap\2.10.0\scalap-2.10.0.jar;"%REPO%"\org\scalatra\scalatra_2.10\2.3.0\scalatra_2.10-2.3.0.jar;"%REPO%"\org\scalatra\scalatra-common_2.10\2.3.0\scalatra-common_2.10-2.3.0.jar;"%REPO%"\org\clapper\grizzled-slf4j_2.10\1.0.2\grizzled-slf4j_2.10-1.0.2.jar;"%REPO%"\org\scalatra\rl\rl_2.10\0.4.10\rl_2.10-0.4.10.jar;"%REPO%"\com\googlecode\juniversalchardet\juniversalchardet\1.0.3\juniversalchardet-1.0.3.jar;"%REPO%"\eu\medsea\mimeutil\mime-util\2.1.3\mime-util-2.1.3.jar;"%REPO%"\joda-time\joda-time\2.3\joda-time-2.3.jar;"%REPO%"\org\joda\joda-convert\1.6\joda-convert-1.6.jar;"%REPO%"\org\scala-lang\scala-reflect\2.10.4\scala-reflect-2.10.4.jar;"%REPO%"\org\bdgenomics\adam\adam-cli\0.16.0\adam-cli-0.16.0.jar

set ENDORSED_DIR=
if NOT "%ENDORSED_DIR%" == "" set CLASSPATH="%BASEDIR%"\%ENDORSED_DIR%\*;%CLASSPATH%

if NOT "%CLASSPATH_PREFIX%" == "" set CLASSPATH=%CLASSPATH_PREFIX%;%CLASSPATH%

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS%  -classpath %CLASSPATH% -Dapp.name="adam" -Dapp.repo="%REPO%" -Dapp.home="%BASEDIR%" -Dbasedir="%BASEDIR%" org.bdgenomics.adam.cli.ADAMMain %CMD_LINE_ARGS%
if %ERRORLEVEL% NEQ 0 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=%ERRORLEVEL%

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@REM If error code is set to 1 then the endlocal was done already in :error.
if %ERROR_CODE% EQU 0 @endlocal


:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
