/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import java.util.Date;
import org.apache.spark.Logging;
import org.bdgenomics.adam.models.Attribute;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.models.TagType$;
import org.bdgenomics.adam.util.AttributeUtils$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001\u0017\t\u00112+Q'SK\u000e|'\u000fZ\"p]Z,'\u000f^3s\u0015\t\u0019A!\u0001\u0006d_:4XM\u001d;feNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\r%U\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\u0007\u0014\u0013\t!bB\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!\u0004C\u0001\u0007CB\f7\r[3\n\u0005q9\"a\u0002'pO\u001eLgn\u001a\u0005\u0006=\u0001!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003\tAQa\t\u0001\u0005\u0002\u0011\nqaY8om\u0016\u0014H\u000f\u0006\u0003&[]z\u0004C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\u0011\tgO]8\u000b\u0005)2\u0011a\u00024pe6\fGo]\u0005\u0003Y\u001d\u0012q\"\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a\u0005\u0006]\t\u0002\raL\u0001\ng\u0006l'+Z2pe\u0012\u0004\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u0011M\fW\u000e^8pYNT\u0011\u0001N\u0001\u0007QR\u001c(\u000eZ6\n\u0005Y\n$!C*B\u001bJ+7m\u001c:e\u0011\u0015A$\u00051\u0001:\u0003\u0011!\u0017n\u0019;\u0011\u0005ijT\"A\u001e\u000b\u0005q\"\u0011AB7pI\u0016d7/\u0003\u0002?w\t\u00112+Z9vK:\u001cW\rR5di&|g.\u0019:z\u0011\u0015\u0001%\u00051\u0001B\u0003)\u0011X-\u00193He>,\bo\u001d\t\u0003u\tK!aQ\u001e\u0003+I+7m\u001c:e\u000fJ|W\u000f\u001d#jGRLwN\\1ss\u0002")
public class SAMRecordConverter
implements Serializable,
Logging {
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public AlignmentRecord convert(SAMRecord samRecord, SequenceDictionary dict, RecordGroupDictionary readGroups) {
        try {
            BoxedUnit boxedUnit;
            Object object;
            Object object2;
            BoxedUnit boxedUnit2;
            String qual;
            int n;
            String cigar;
            String string = cigar = samRecord.getCigarString();
            String string2 = "*";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                n = 0;
            } else {
                int count = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(cigar)).takeWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$1) {
                        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$1));
                    }
                }))).toInt();
                char operator = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(cigar)).dropWhile((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$2) {
                        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$2));
                    }
                }))).head());
                n = operator == 'H' ? count : 0;
            }
            int startTrim = n;
            int endTrim = cigar.endsWith("H") ? new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(cigar)).dropRight(1))).reverse())).takeWhile((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$3) {
                    return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$3));
                }
            }))).reverse())).toInt() : 0;
            AlignmentRecord.Builder builder = AlignmentRecord.newBuilder().setReadName(samRecord.getReadName()).setSequence(samRecord.getReadString()).setCigar(cigar).setBasesTrimmedFromStart(Predef$.MODULE$.int2Integer(startTrim)).setBasesTrimmedFromEnd(Predef$.MODULE$.int2Integer(endTrim)).setOrigQual(SAMUtils.phredToFastq((byte[])samRecord.getOriginalBaseQualities()));
            String string3 = qual = samRecord.getBaseQualityString();
            String string4 = "*";
            Object object3 = !(string3 != null ? !string3.equals(string4) : string4 != null) ? BoxedUnit.UNIT : builder.setQual(qual);
            int readReference = Predef$.MODULE$.Integer2int(samRecord.getReferenceIndex());
            if (readReference != -1) {
                BoxedUnit boxedUnit3;
                builder.setContig(SequenceRecord$.MODULE$.toADAMContig((SequenceRecord)dict.apply(samRecord.getReferenceName()).get()));
                int start = samRecord.getAlignmentStart();
                Predef$.MODULE$.assert(start != 0, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Start cannot equal 0 if contig is set.";
                    }
                });
                builder.setStart(Predef$.MODULE$.long2Long((long)(start - 1)));
                if (samRecord.getAttribute("OP") == null) {
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    builder.setOldPosition(Predef$.MODULE$.long2Long((long)Predef$.MODULE$.Integer2int(samRecord.getIntegerAttribute("OP")) - 1L));
                    boxedUnit3 = builder.setOldCigar(samRecord.getStringAttribute("OC"));
                }
                long end = (long)start - 1L + (long)samRecord.getCigar().getReferenceLength();
                builder.setEnd(Predef$.MODULE$.long2Long(end));
                int mapq = samRecord.getMappingQuality();
                Object object4 = mapq != 255 ? builder.setMapq(Predef$.MODULE$.int2Integer(mapq)) : BoxedUnit.UNIT;
                if (samRecord.getReadUnmappedFlag()) {
                    boxedUnit2 = builder.setReadMapped(Predef$.MODULE$.boolean2Boolean(false));
                } else {
                    builder.setReadMapped(Predef$.MODULE$.boolean2Boolean(true));
                    Object object5 = samRecord.getReadNegativeStrandFlag() ? builder.setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                    if (samRecord.getNotPrimaryAlignmentFlag()) {
                        builder.setSupplementaryAlignment(Predef$.MODULE$.boolean2Boolean(samRecord.getSupplementaryAlignmentFlag()));
                        boxedUnit2 = builder.setSecondaryAlignment(Predef$.MODULE$.boolean2Boolean(!samRecord.getSupplementaryAlignmentFlag()));
                    } else {
                        boxedUnit2 = builder.setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true));
                    }
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            int mateReference = Predef$.MODULE$.Integer2int(samRecord.getMateReferenceIndex());
            if (mateReference != -1) {
                builder.setMateContig(SequenceRecord$.MODULE$.toADAMContig((SequenceRecord)dict.apply(samRecord.getMateReferenceName()).get()));
                int mateStart = samRecord.getMateAlignmentStart();
                object2 = mateStart > 0 ? builder.setMateAlignmentStart(Predef$.MODULE$.long2Long((long)(mateStart - 1))) : BoxedUnit.UNIT;
            } else {
                object2 = BoxedUnit.UNIT;
            }
            if (samRecord.getFlags() != 0) {
                Object object6;
                if (samRecord.getReadPairedFlag()) {
                    builder.setReadPaired(Predef$.MODULE$.boolean2Boolean(true));
                    Object object7 = samRecord.getMateNegativeStrandFlag() ? builder.setMateNegativeStrand(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                    Object object8 = samRecord.getMateUnmappedFlag() ? BoxedUnit.UNIT : builder.setMateMapped(Predef$.MODULE$.boolean2Boolean(true));
                    Object object9 = samRecord.getProperPairFlag() ? builder.setProperPair(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                    Object object10 = samRecord.getFirstOfPairFlag() ? builder.setFirstOfPair(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                    object6 = samRecord.getSecondOfPairFlag() ? builder.setSecondOfPair(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                } else {
                    object6 = BoxedUnit.UNIT;
                }
                Object object11 = samRecord.getDuplicateReadFlag() ? builder.setDuplicateRead(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                object = samRecord.getReadFailsVendorQualityCheckFlag() ? builder.setFailedVendorQualityChecks(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            ObjectRef tags = new ObjectRef((Object)Nil$.MODULE$);
            int tlen = samRecord.getInferredInsertSize();
            if (tlen != 0) {
                tags.elem = ((List)tags.elem).$colon$colon((Object)new Attribute("TLEN", (Enumeration.Value)TagType$.MODULE$.Integer(), BoxesRunTime.boxToInteger((int)tlen)));
            }
            if (samRecord.getAttributes() != null) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(samRecord.getAttributes()).asScala()).foreach((Function1)new Serializable(this, builder, tags){
                    public static final long serialVersionUID = 0L;
                    private final AlignmentRecord.Builder builder$1;
                    private final ObjectRef tags$1;

                    public final Object apply(SAMRecord.SAMTagAndValue attr) {
                        AlignmentRecord.Builder builder;
                        String string = attr.tag;
                        String string2 = "MD";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            builder = this.builder$1.setMismatchingPositions(attr.value.toString());
                        } else {
                            this.tags$1.elem = ((List)this.tags$1.elem).$colon$colon((Object)AttributeUtils$.MODULE$.convertSAMTagAndValue(attr));
                            builder = BoxedUnit.UNIT;
                        }
                        return builder;
                    }
                    {
                        this.builder$1 = builder$1;
                        this.tags$1 = tags$1;
                    }
                });
            }
            Object object12 = ((List)tags.elem).isEmpty() ? BoxedUnit.UNIT : builder.setAttributes(((List)tags.elem).mkString("\t"));
            SAMReadGroupRecord recordGroup = samRecord.getReadGroup();
            if (recordGroup == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Option$.MODULE$.apply((Object)recordGroup.getRunDate()).foreach((Function1)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final AlignmentRecord.Builder builder$1;

                    public final AlignmentRecord.Builder apply(Date date) {
                        return this.builder$1.setRecordGroupRunDateEpoch(Predef$.MODULE$.long2Long(date.getTime()));
                    }
                    {
                        this.builder$1 = builder$1;
                    }
                });
                boxedUnit = builder.setRecordGroupName(recordGroup.getReadGroupId()).setRecordGroupSequencingCenter(recordGroup.getSequencingCenter()).setRecordGroupDescription(recordGroup.getDescription()).setRecordGroupFlowOrder(recordGroup.getFlowOrder()).setRecordGroupKeySequence(recordGroup.getKeySequence()).setRecordGroupLibrary(recordGroup.getLibrary()).setRecordGroupPredictedMedianInsertSize(recordGroup.getPredictedMedianInsertSize()).setRecordGroupPlatform(recordGroup.getPlatform()).setRecordGroupPlatformUnit(recordGroup.getPlatformUnit()).setRecordGroupSample(recordGroup.getSample());
            }
            return builder.build();
        }
        catch (Throwable throwable) {
            this.log().error(new StringBuilder().append((Object)"Conversion of read: ").append((Object)samRecord).append((Object)" failed.").toString());
            throw throwable;
        }
    }

    public SAMRecordConverter() {
        Logging.class.$init$((Logging)this);
    }
}

