/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.common;

public class IntHashMap<T> {
    private transient Entry<T>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int n) {
        this(n, 0.75f);
    }

    public IntHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry<T>[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry<Object> entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(int n) {
        Entry<T>[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public T get(int n) {
        Entry<T>[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                return (T)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry<T>[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry<Object> entry = entryArray[n3];
            while (entry != null) {
                Entry<T> entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object put(int n, T t) {
        Entry<T>[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object> entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n) {
                Object e = entry.value;
                entry.value = t;
                return e;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry<T>(n, n, t, entryArray[n2]);
        ++this.count;
        return null;
    }

    public Object remove(int n) {
        Entry<T>[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry<Object> entry = entryArray[n2];
        Entry<T> entry2 = null;
        while (entry != null) {
            if (entry.hash == n) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object e = entry.value;
                entry.value = null;
                return e;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry<T>[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    private static class Entry<E> {
        final int hash;
        final int key;
        E value;
        Entry<E> next;

        protected Entry(int n, int n2, E e, Entry<E> entry) {
            this.hash = n;
            this.key = n2;
            this.value = e;
            this.next = entry;
        }
    }
}

