/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRC32InputStream
extends InputStream {
    private final InputStream delegate;
    private final CRC32 crc32 = new CRC32();

    public CRC32InputStream(InputStream inputStream) {
        this.delegate = inputStream;
    }

    public int getCRC32() {
        return (int)this.crc32.getValue();
    }

    @Override
    public int read() throws IOException {
        int n = this.delegate.read();
        if (n != -1) {
            this.crc32.update(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.delegate.read(byArray);
        if (n != -1) {
            this.crc32.update(byArray, 0, n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.delegate.read(byArray, n, n2);
        this.crc32.update(byArray, n, n3);
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.delegate.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int n) {
        this.delegate.mark(n);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

