/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.common.Version;
import java.util.Arrays;

public final class CramHeader {
    public static final byte[] MAGIC = "CRAM".getBytes();
    private Version version;
    private final byte[] id = new byte[20];
    private SAMFileHeader samFileHeader;

    private CramHeader() {
        Arrays.fill(this.id, (byte)0);
    }

    public CramHeader(Version version, String string, SAMFileHeader sAMFileHeader) {
        Arrays.fill(this.id, (byte)0);
        this.version = version;
        if (string != null) {
            System.arraycopy(string.getBytes(), 0, this.id, 0, Math.min(string.length(), this.id.length));
        }
        this.samFileHeader = sAMFileHeader;
    }

    public void setID(String string) {
        System.arraycopy(string.getBytes(), 0, this.id, 0, Math.min(this.id.length, string.length()));
    }

    public CramHeader clone() {
        CramHeader cramHeader = new CramHeader();
        cramHeader.version = this.version;
        System.arraycopy(this.id, 0, cramHeader.id, 0, this.id.length);
        cramHeader.samFileHeader = this.getSamFileHeader().clone();
        return cramHeader;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof CramHeader)) {
            return false;
        }
        CramHeader cramHeader = (CramHeader)object;
        if (this.getVersion().major != cramHeader.getVersion().major) {
            return false;
        }
        if (this.getVersion().minor != cramHeader.getVersion().minor) {
            return false;
        }
        return Arrays.equals(this.id, cramHeader.id) && this.getSamFileHeader().equals(cramHeader.getSamFileHeader());
    }

    public SAMFileHeader getSamFileHeader() {
        return this.samFileHeader;
    }

    public byte[] getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }
}

